/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facelets;

import com.intellij.ProjectTopics;
import com.intellij.jsf.JsfProjectComponent;
import com.intellij.jsf.facelets.lang.FaceletsFileViewProvider;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FaceletsManager
extends SimpleModificationTracker {
    private static final Key<CachedValue<Boolean>> KEY = new Key("faceletsEnabled");
    private final CachedValueProvider<Boolean> myCachedValueProvider = () -> {
        if (module.isDisposed()) {
            return null;
        }
        JsfProjectComponent component = JsfProjectComponent.getInstance(module.getProject());
        boolean value = false;
        switch (component.getState().faceletsSupport) {
            case AUTO: {
                value = JsfCommonUtils.isJsfSupported(module);
                break;
            }
            case ENABLED: {
                value = true;
                break;
            }
            case DISABLED: {
                value = false;
            }
        }
        return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{this, component});
    };

    public FaceletsManager(Module module) {
        MessageBusConnection messageBusConnection = module.getMessageBus().connect();
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                FaceletsManager.this.doChange();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/facelets/FaceletsManager$2", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/facelets/FaceletsManager$2", "moduleAdded"));
                }
                FaceletsManager.this.doChange();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/facelets/FaceletsManager$2", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/facelets/FaceletsManager$2", "moduleRemoved"));
                }
                FaceletsManager.this.doChange();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/facelets/FaceletsManager$2", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/jsf/facelets/FaceletsManager$2", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "com/intellij/jsf/facelets/FaceletsManager$2", "modulesRenamed"));
                }
                FaceletsManager.this.doChange();
            }
        });
        module.getProject().getMessageBus().connect((Disposable)module).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FaceletsManager.this.doChange();
            }

            public void exitDumbMode() {
                FaceletsManager.this.doChange();
            }
        });
    }

    private void doChange() {
        this.incModificationCount();
    }

    public static boolean isFaceletFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/facelets/FaceletsManager", "isFaceletFile"));
        }
        return file.getViewProvider() instanceof FaceletsFileViewProvider;
    }

    public static boolean isFaceletsEnabled(Project project, VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || module.isDisposed()) {
            return false;
        }
        return FaceletsManager.isFaceletsEnabled(module);
    }

    public static boolean isFaceletsEnabled(Module module) {
        FaceletsManager manager = (FaceletsManager)((Object)ModuleServiceManager.getService((Module)module, FaceletsManager.class));
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, KEY, manager.myCachedValueProvider, false);
    }
}

