/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation.ui;

import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.ui.WebPathChooserDescriptor;
import com.intellij.jsf.generation.EntityGenerateInfo;
import com.intellij.jsf.generation.FacesGenerationTemplateUtil;
import com.intellij.jsf.generation.FacesGenerationTemplatesFactory;
import com.intellij.jsf.generation.GenerateSettings;
import com.intellij.jsf.generation.ui.FacesGenerationTableView;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.CaptionComponent;
import icons.JsfIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FacesGenerationPanel
implements Disposable {
    private CaptionComponent myCaption;
    private JPanel myRootPane;
    private JPanel myTablePanel;
    private JPanel mySettingPanel;
    private JTabbedPane myTabbedPane;
    private JPanel myEditTab;
    private JTextField myManagedBeanClassName;
    private TextFieldWithBrowseButton myManagedBeanDirectory;
    private TextFieldWithBrowseButton myPagesGenerationPath;
    private final GenerateSettings myGenerateSettings;
    private JCheckBox myCreateSubdirectoriesCheckBox;
    private JCheckBox myAutoGenerateNamesCheckBox;
    private JPanel myManagedBeanTab;
    private JPanel myViewTab;
    private JPanel myCreateTab;
    private JPanel myListTab;
    private JPanel myConverterTab;
    private JComboBox myFacesConfigComboBox;
    private JTextField myManagedBeanTextField;
    private JCheckBox myGenerateIndexPageCheckBox;
    private JTextField myEditActionTextField;
    private JTextField myViewActionTextField;
    private JTextField myCreateActionTextField;
    private JTextField myShowListActionTextField;
    private final List<EntityGenerateInfo> myEntityInfos;
    private EditorTextField myManagedBeanEditorText;
    private EditorTextField myConverterEditorText;
    private EditorTextField myEditEditorText;
    private EditorTextField myViewEditorText;
    private EditorTextField myListEditorText;
    private EditorTextField myCreateEditorText;
    private FacesGenerationTableView myTableView;
    private final Module myModule;
    private final PersistencePackage myPersistenceUnit;
    private static final String EMPTY_PATH = "<empty path>";
    private static final String EMPTY_PACKAGE = "<empty package>";
    private static final String DEFAULT_PACKAGE = "<default>";
    private final WebFacet myWebFacet;
    private final PersistenceFacet myFacet;
    private final PersistenceModelBrowser myBrowser;

    public FacesGenerationPanel(WebFacet webFacet, PersistenceFacet facet, PersistencePackage persistenceUnit) {
        this.myWebFacet = webFacet;
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myModule = webFacet.getModule();
        this.myPersistenceUnit = persistenceUnit;
        this.myBrowser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)facet, (PersistencePackage)persistenceUnit, null);
        this.myEntityInfos = this.getDefaultEntityInfos();
        this.myGenerateSettings = new GenerateSettings(this.myModule, this.myPersistenceUnit, this.myBrowser);
        this.init();
        this.updatePreview();
        this.updateOKAction();
        this.updatePathControls();
        this.updateCheckboxes();
        this.myCaption.setIcon(JsfIcons.BigIcons.Component);
    }

    private void init() {
        this.myTableView = new FacesGenerationTableView(this.myEntityInfos, this.myModule, this.myPersistenceUnit, this.myBrowser);
        int selectedRow = this.myEntityInfos.size() > 0 ? 1 : 0;
        this.myTableView.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        this.myTablePanel.setLayout(new BorderLayout());
        this.myTablePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTableView)), "Center");
        this.myManagedBeanDirectory.getTextField().setEditable(false);
        this.myManagedBeanEditorText = this.createEditorTextField(StdFileTypes.JAVA);
        this.myConverterEditorText = this.createEditorTextField(StdFileTypes.JAVA);
        this.myEditEditorText = this.createEditorTextField(StdFileTypes.JSP);
        this.myViewEditorText = this.createEditorTextField(StdFileTypes.JSP);
        this.myListEditorText = this.createEditorTextField(StdFileTypes.JSP);
        this.myCreateEditorText = this.createEditorTextField(StdFileTypes.JSP);
        this.myViewTab.add((Component)this.myViewEditorText, "Center");
        this.myEditTab.add((Component)this.myEditEditorText, "Center");
        this.myListTab.add((Component)this.myListEditorText, "Center");
        this.myCreateTab.add((Component)this.myCreateEditorText, "Center");
        this.myManagedBeanTab.add((Component)this.myManagedBeanEditorText, "Center");
        this.myConverterTab.add((Component)this.myConverterEditorText, "Center");
        this.myFacesConfigComboBox.setModel(new DefaultComboBoxModel<XmlFile>(this.getFacesConfigs()));
        this.myFacesConfigComboBox.setRenderer(new ListCellRendererWrapper<XmlFile>(){

            public void customize(JList list, XmlFile value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getName());
                    this.setIcon(value.getIcon(0));
                }
            }
        });
        if (this.myFacesConfigComboBox.getSelectedItem() != null) {
            this.myGenerateSettings.setFacesConfig((XmlFile)this.myFacesConfigComboBox.getSelectedItem());
        }
        this.addListeners();
        this.updatePreview();
    }

    private XmlFile[] getFacesConfigs() {
        Set<XmlFile> xmls = FacesConfigUtils.getConfigurationFiles(this.myWebFacet);
        ArrayList<XmlFile> nonResourceFacesConfigs = new ArrayList<XmlFile>();
        for (XmlFile xml : xmls) {
            if (FacesConfigUtils.isFacesConfigResource(xml)) continue;
            nonResourceFacesConfigs.add(xml);
        }
        return nonResourceFacesConfigs.toArray(new XmlFile[nonResourceFacesConfigs.size()]);
    }

    private EditorTextField createEditorTextField(LanguageFileType fileType) {
        EditorTextField textField = new EditorTextField("", this.myModule.getProject(), (FileType)fileType){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setVerticalScrollbarVisible(true);
                editor.setHorizontalScrollbarVisible(true);
                return editor;
            }

            protected boolean isOneLineMode() {
                return false;
            }
        };
        return textField;
    }

    private EntityGenerateInfo getSelectedEntity() {
        int selectedRow = this.myTableView.getSelectedRow();
        if (selectedRow < 0) {
            selectedRow = 0;
        }
        return (EntityGenerateInfo)this.myTableView.getItems().get(selectedRow);
    }

    private void addListeners() {
        this.myTableView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FacesGenerationPanel.this.updatePreview();
            }
        });
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FacesGenerationPanel.this.updatePreview();
            }
        });
        this.myManagedBeanDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageChooserDialog chooser = new PackageChooserDialog(FacesBundle.message("faces.generation.dialog.choose.package.title", new Object[0]), FacesGenerationPanel.this.myModule.getProject());
                chooser.show();
                PsiPackage selectedPackage = chooser.getSelectedPackage();
                if (selectedPackage != null) {
                    FacesGenerationPanel.this.myGenerateSettings.setManagedBeanPackage(selectedPackage);
                    String qualifiedName = selectedPackage.getQualifiedName();
                    FacesGenerationPanel.this.myManagedBeanDirectory.setText(qualifiedName.trim().length() == 0 ? FacesGenerationPanel.DEFAULT_PACKAGE : qualifiedName);
                    FacesGenerationPanel.this.updatePreview();
                    FacesGenerationPanel.this.updateOKAction();
                    FacesGenerationPanel.this.updatePathControls();
                }
            }
        });
        this.myPagesGenerationPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<WebRoot> webRoots = this.findWebRoots();
                WebPathChooserDescriptor descriptor = new WebPathChooserDescriptor(false, true, false, false, false, false, webRoots);
                descriptor.setRoots(ContainerUtil.map(webRoots, (Function)((NullableFunction)root -> root.getFile())));
                descriptor.setShowFileSystemRoots(false);
                descriptor.withTreeRootVisible(descriptor.getRoots().size() == 1);
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)FacesGenerationPanel.this.myModule.getProject(), null);
                if (files.length > 0) {
                    FacesGenerationPanel.this.myGenerateSettings.setPagesGenerateDirectory(files[0]);
                    FacesGenerationPanel.this.myPagesGenerationPath.setText(files[0].getPath());
                    FacesGenerationPanel.this.updateOKAction();
                    FacesGenerationPanel.this.updatePathControls();
                }
            }

            private List<WebRoot> findWebRoots() {
                if (FacesGenerationPanel.this.myWebFacet == null) {
                    return Collections.emptyList();
                }
                return FacesGenerationPanel.this.myWebFacet.getWebRoots();
            }
        });
        this.myFacesConfigComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacesGenerationPanel.this.myGenerateSettings.setFacesConfig((XmlFile)FacesGenerationPanel.this.myFacesConfigComboBox.getSelectedItem());
                FacesGenerationPanel.this.updateOKAction();
            }
        });
        this.addTextFieldListener(this.myManagedBeanTextField);
        this.myCreateSubdirectoriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacesGenerationPanel.this.updateCheckboxes();
            }
        });
    }

    private void updateCheckboxes() {
        if (!this.myCreateSubdirectoriesCheckBox.isSelected()) {
            this.myAutoGenerateNamesCheckBox.setSelected(true);
            this.myAutoGenerateNamesCheckBox.setEnabled(false);
        } else {
            this.myAutoGenerateNamesCheckBox.setEnabled(true);
        }
    }

    private void updatePathControls() {
        boolean isPagesPathEmpty = this.myPagesGenerationPath.getText().trim().length() == 0 || this.myPagesGenerationPath.getText().trim().equals(EMPTY_PATH);
        boolean isMBPackgeEmpty = this.myManagedBeanDirectory.getText().trim().length() == 0 || this.myManagedBeanDirectory.getText().trim().equals(EMPTY_PACKAGE);
        this.myPagesGenerationPath.getTextField().setForeground(isPagesPathEmpty ? BaseControl.ERROR_FOREGROUND : Color.BLACK);
        if (isPagesPathEmpty) {
            this.myPagesGenerationPath.setText(EMPTY_PATH);
        }
        this.myPagesGenerationPath.getTextField().setToolTipText(isPagesPathEmpty ? FacesBundle.message("faces.generation.dialog.choose.folder.tooltip", new Object[0]) : null);
        this.myManagedBeanDirectory.getTextField().setForeground(isMBPackgeEmpty ? BaseControl.ERROR_FOREGROUND : Color.BLACK);
        if (isMBPackgeEmpty) {
            this.myManagedBeanDirectory.setText(EMPTY_PACKAGE);
        }
        this.myManagedBeanDirectory.getTextField().setToolTipText(isMBPackgeEmpty ? FacesBundle.message("faces.generation.dialog.choose.package.tooltip", new Object[0]) : null);
    }

    private void addTextFieldListener(JTextField textField) {
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FacesGenerationPanel.this.updatePreview();
            }
        });
    }

    private void updatePreview() {
        this.updatePreview(this.myViewTab, this.myViewEditorText, (Function<EntityGenerateInfo, String>)((Function)s -> s.getViewTemplate()));
        this.updatePreview(this.myEditTab, this.myEditEditorText, (Function<EntityGenerateInfo, String>)((Function)s -> s.getEditTemplate()));
        this.updatePreview(this.myCreateTab, this.myCreateEditorText, (Function<EntityGenerateInfo, String>)((Function)s -> s.getCreateTemplate()));
        this.updatePreview(this.myListTab, this.myListEditorText, (Function<EntityGenerateInfo, String>)((Function)s -> s.getListTemplate()));
        this.updatePreview(this.myManagedBeanTab, this.myManagedBeanEditorText, (Function<EntityGenerateInfo, String>)((Function)s -> s.getManagedBeanTemplate()));
        this.updatePreview(this.myConverterTab, this.myConverterEditorText, (Function<EntityGenerateInfo, String>)new ConstantFunction((Object)"converter_template.java"));
    }

    private boolean updatePreview(JPanel tab, EditorTextField field, Function<EntityGenerateInfo, String> fun) {
        if (!this.myTabbedPane.getSelectedComponent().equals(tab)) {
            return false;
        }
        EntityGenerateInfo generateInfo = this.getSelectedEntity();
        field.setDocument(EditorFactory.getInstance().createDocument((CharSequence)this.getTemplateText(generateInfo, (String)fun.fun((Object)generateInfo))));
        return true;
    }

    private String getTemplateText(EntityGenerateInfo generateInfo, String templateName) {
        String text = generateInfo.isDefaultSettings() ? FacesGenerationTemplatesFactory.getTemplate(templateName).getText() : FacesGenerationTemplateUtil.createTemplateText(generateInfo, this.getGenerateSettings(), templateName);
        if (text == null) {
            text = "";
        }
        return text;
    }

    public PersistencePackage getPersistenceUnit() {
        return this.myPersistenceUnit;
    }

    public JComponent getComponent() {
        return this.myRootPane;
    }

    public void dispose() {
    }

    public List<EntityGenerateInfo> getEntityInfos() {
        return this.myEntityInfos;
    }

    private List<EntityGenerateInfo> getDefaultEntityInfos() {
        ArrayList<EntityGenerateInfo> infos = new ArrayList<EntityGenerateInfo>();
        for (PersistentEntity persistentEntity : this.getEntities()) {
            infos.add(new EntityGenerateInfo(persistentEntity, this.myModule, this.myBrowser));
        }
        return infos;
    }

    private List<? extends PersistentEntity> getEntities() {
        return this.myFacet.getEntityMappings(this.myPersistenceUnit).getModelHelper().getPersistentEntities();
    }

    private void createUIComponents() {
    }

    protected void updateOKAction() {
    }

    public boolean isOKActionEnabled() {
        return this.myGenerateSettings.isReadyToGenerate();
    }

    public GenerateSettings getGenerateSettings() {
        this.updateSettings();
        return this.myGenerateSettings;
    }

    private void updateSettings() {
        this.myGenerateSettings.setManagedBeanSuffix(this.myManagedBeanTextField.getText());
        this.myGenerateSettings.setAutoCreateNames(this.myAutoGenerateNamesCheckBox.isSelected());
        this.myGenerateSettings.setCreateSubdirectories(this.myCreateSubdirectoriesCheckBox.isSelected());
        this.myGenerateSettings.setGenerateIndexPage(this.myGenerateIndexPageCheckBox.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        CaptionComponent captionComponent;
        JPanel jPanel9;
        this.myRootPane = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 5, 0, 5), -1, -1, false, false));
        this.myCaption = captionComponent = new CaptionComponent();
        captionComponent.setDescriptionText("Automatically create the JSF application that can be used to view and modify data through the Web interface. ");
        captionComponent.setText("Generate Java Server Faces");
        jPanel9.add((Component)captionComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel9.add((Component)jPanel10, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Entities", (int)0, (int)0, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(150);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setOrientation(0);
        jSplitPane.setDividerSize(4);
        jPanel10.add((Component)jSplitPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myTablePanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel8);
        this.mySettingPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 5, 0, 5), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel7);
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        this.myTabbedPane = jBTabbedPane;
        jBTabbedPane.setTabPlacement(1);
        jPanel7.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 200), null));
        this.myViewTab = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("View", null, jPanel6, null);
        this.myEditTab = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Edit", null, jPanel5, null);
        this.myCreateTab = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Create", null, jPanel4, null);
        this.myListTab = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("List", null, jPanel3, null);
        this.myManagedBeanTab = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Managed Bean", null, jPanel2, null);
        this.myConverterTab = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Converter", null, jPanel, null);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 5, 0, 5), -1, -1, false, false));
        jPanel12.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel9.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel12.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"General Settings", (int)0, (int)0, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCreateSubdirectoriesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Create subfolders");
        jCheckBox3.setSelected(false);
        jPanel13.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAutoGenerateNamesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Automatically generate names");
        jCheckBox2.setSelected(true);
        jPanel13.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGenerateIndexPageCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Generate index page");
        jPanel13.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel13.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Create JSF pages in folder:");
        jPanel14.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Faces Config:");
        jPanel14.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFacesConfigComboBox = jComboBox = new JComboBox();
        jPanel14.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPagesGenerationPath = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setEditable(false);
        textFieldWithBrowseButton2.setEnabled(true);
        jPanel14.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(250, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Create Managed Beans in package:");
        jPanel14.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Managed Bean names suffix:");
        jPanel14.add((Component)jLabel4, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManagedBeanDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel14.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 3, 1, 1, 0, 1, 7, 0, null, new Dimension(250, -1), null));
        this.myManagedBeanTextField = jTextField = new JTextField();
        jTextField.setText("ManagedBean");
        jPanel14.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 3, 0, null, new Dimension(250, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }
}

