/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.JspxFileType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.flows.FlowsCommonUtils;
import com.intellij.jsf.flows.FlowsPresentationUtils;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.model.xml.flows.FlowDefinition;
import com.intellij.jsf.model.xml.flows.FlowNode;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.XmlUtil;
import icons.JsfIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionAttributeValueReference
extends BasicAttributeValueReference {
    @NonNls
    private static final String UI_INCLUDE_ATTR_NAME = "include";
    private static final XmlAttributeValuePattern INCLUDE_SRC_PATTERN = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"src"}).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("include")).withNamespace(XmlUtil.FACELETS_URIS));
    private boolean myIncludesSearch;
    private final PsiElement myElement;

    public ActionAttributeValueReference(PsiElement element) {
        super(element);
        this.myElement = element;
    }

    @Nullable
    public PsiElement resolve() {
        String actionValue = ((XmlAttributeValue)this.myElement).getValue();
        if (StringUtil.isEmptyOrSpaces((String)actionValue)) {
            return null;
        }
        List<GenericDomValue<String>> fromActions = ActionAttributeValueReference.getNonEmptyFromOutcomes(this.myElement);
        for (GenericDomValue<String> genericDomValue : fromActions) {
            if (!actionValue.equals(genericDomValue.getStringValue())) continue;
            return genericDomValue.getXmlElement();
        }
        if (ActionAttributeValueReference.isJSF_2_0(this.myElement)) {
            Module module;
            PsiFile psiFile = ActionAttributeValueReference.getPsiFile(this.myElement);
            for (PsiFile file : this.collectXhtmlNeighbours(psiFile)) {
                if (!actionValue.equals(FileUtil.getNameWithoutExtension((String)file.getName()))) continue;
                return file;
            }
            if (JsfCommonUtils.isFlowSupported(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement)) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) != null) {
                Pair<PsiElement, String> flowDefinitionByName = FlowsCommonUtils.findFlowDefinitionByName(module, actionValue);
                if (flowDefinitionByName != null) {
                    return (PsiElement)flowDefinitionByName.first;
                }
                Set<CdiProduces.Method> producers = FlowsCommonUtils.getFlowDefinitionProducers(module);
                for (CdiProduces.Method producer : producers) {
                    for (Pair<PsiElement, String> definition : FlowsCommonUtils.getViewIds((PsiMethod)producer.getPsiElement(), module)) {
                        if (!actionValue.equals(definition.second)) continue;
                        return FlowsCommonUtils.getOrCreateNodeFakeElement(definition);
                    }
                }
                FlowNode node = FlowsCommonUtils.findFlowNode(actionValue, psiFile, module);
                if (node != null) {
                    return node.getXmlElement();
                }
            }
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        for (GenericDomValue<String> value : ActionAttributeValueReference.getNonEmptyFromOutcomes(this.myElement)) {
            String action = value.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)action)) continue;
            variants.add((LookupElement)LookupElementBuilder.create((String)action));
        }
        if (ActionAttributeValueReference.isJSF_2_0(this.myElement)) {
            PsiFile psiFile = ActionAttributeValueReference.getPsiFile(this.myElement);
            for (PsiFile file : this.collectXhtmlNeighbours(psiFile)) {
                String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)file.getName());
                variants.add((LookupElement)LookupElementBuilder.create((String)nameWithoutExtension).withIcon(file.getIcon(0)).withTypeText(file.getName()));
            }
            if (JsfCommonUtils.isFlowSupported(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement))) {
                ActionAttributeValueReference.addFlowsVariants(variants, psiFile);
            }
        }
        Object[] objectArray = variants.toArray(new LookupElement[variants.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/ActionAttributeValueReference", "getVariants"));
        }
        return objectArray;
    }

    private static void addFlowsVariants(List<LookupElement> variants, PsiFile psiFile) {
        FlowDefinition flowByFile;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module != null) {
            ActionAttributeValueReference.addAnnotatedFlowDefinitions(variants, module);
            Set<PsiDirectory> directories = FlowsCommonUtils.getFlowsDirectories(module);
            for (PsiDirectory directory : directories) {
                FlowDefinition flowDefinition = FlowsCommonUtils.getExplicitFlowDefinition(directory);
                if (flowDefinition != null) {
                    String flowId = flowDefinition.getId().getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)flowId)) continue;
                    variants.add((LookupElement)FlowsPresentationUtils.createExplicitFlowLookupElement(flowId));
                    continue;
                }
                variants.add((LookupElement)FlowsPresentationUtils.createImplicitFlowLookupElement(directory));
            }
        }
        if ((flowByFile = FlowsCommonUtils.getFlowByFile(psiFile)) != null) {
            for (FlowNode flowNode : FlowsCommonUtils.getFlowNodes(flowByFile)) {
                String flowId = flowNode.getId().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)flowId)) continue;
                variants.add((LookupElement)LookupElementBuilder.create((String)flowId).withIcon(JsfIcons.NavigationRule).withTypeText("Flow: " + flowByFile.getId().getStringValue()));
            }
        }
    }

    private static void addAnnotatedFlowDefinitions(@NotNull List<LookupElement> variants, @NotNull Module module) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/jsf/references/ActionAttributeValueReference", "addAnnotatedFlowDefinitions"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/references/ActionAttributeValueReference", "addAnnotatedFlowDefinitions"));
        }
        for (CdiProduces.Method producer : FlowsCommonUtils.getFlowDefinitionProducers(module)) {
            Set<Pair<PsiElement, String>> ids = FlowsCommonUtils.getFlowIds((PsiMethod)producer.getPsiElement(), module);
            for (Pair<PsiElement, String> flowDefinition : ids) {
                variants.add((LookupElement)FlowsPresentationUtils.createAnnotatedFlowLookupElement((String)flowDefinition.second));
            }
            String flowName = ids.size() == 1 ? (String)ids.iterator().next().second : ((PsiMethod)producer.getPsiElement()).getName();
            for (Pair<PsiElement, String> pair : FlowsCommonUtils.getViewIds((PsiMethod)producer.getPsiElement(), module)) {
                variants.add((LookupElement)FlowsPresentationUtils.createAnnotatedViewLookupElement(flowName, (String)pair.second));
            }
        }
    }

    public boolean isReferenceTo(PsiElement element) {
        return !this.myIncludesSearch && super.isReferenceTo(element);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (ActionAttributeValueReference.isJSF_2_0(this.myElement) && newElementName.contains(".")) {
            newElementName = newElementName.substring(0, newElementName.indexOf("."));
        }
        return super.handleElementRename(newElementName);
    }

    public boolean isSoft() {
        return true;
    }

    private static List<GenericDomValue<String>> getNonEmptyFromOutcomes(PsiElement element) {
        ArrayList<GenericDomValue<String>> fromActions = new ArrayList<GenericDomValue<String>>();
        PsiFile psiFile = ActionAttributeValueReference.getPsiFile(element);
        FacesConfig facesConfig = ActionAttributeValueReference.getMergedFacesConfig(psiFile);
        if (facesConfig != null) {
            for (NavigationRule rule : facesConfig.getNavigationRules()) {
                GenericDomValue<PathReference> fromViewId = rule.getFromViewId();
                if (!ActionAttributeValueReference.acceptFromViewId(psiFile, fromViewId)) continue;
                for (NavigationCase aCase : rule.getNavigationCases()) {
                    GenericDomValue<String> fromOutcomes = aCase.getFromOutcome();
                    String value = fromOutcomes.getStringValue();
                    if (value == null || value.trim().length() <= 0) continue;
                    fromActions.add(fromOutcomes);
                }
            }
        }
        return fromActions;
    }

    private static boolean isJSF_2_0(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/ActionAttributeValueReference", "isJSF_2_0"));
        }
        return JsfCommonUtils.isJsf_2_0(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    private Set<PsiFile> collectXhtmlNeighbours(@Nullable PsiFile psiFile) {
        HashSet files = new HashSet();
        ActionAttributeValueReference.collectNeighbours(psiFile, (Set<PsiFile>)files);
        if (psiFile != null) {
            this.collectUIIncludeContainers(psiFile, (Set<PsiFile>)files);
        }
        return files;
    }

    private static void collectNeighbours(@Nullable PsiFile psiFile, @NotNull Set<PsiFile> files) {
        PsiDirectory directory;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/jsf/references/ActionAttributeValueReference", "collectNeighbours"));
        }
        if (psiFile != null && (directory = psiFile.getContainingDirectory()) != null) {
            for (PsiFile file : directory.getFiles()) {
                if (psiFile == file || !(file.getFileType() instanceof JspxFileType)) continue;
                files.add(file);
            }
        }
    }

    private void collectUIIncludeContainers(@NotNull PsiFile psiFile, @NotNull Set<PsiFile> files) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jsf/references/ActionAttributeValueReference", "collectUIIncludeContainers"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/jsf/references/ActionAttributeValueReference", "collectUIIncludeContainers"));
        }
        this.myIncludesSearch = true;
        ReferencesSearch.search((PsiElement)psiFile).forEach(psiReference -> {
            PsiFile containingFile;
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jsf/references/ActionAttributeValueReference", "lambda$collectUIIncludeContainers$0"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/jsf/references/ActionAttributeValueReference", "lambda$collectUIIncludeContainers$0"));
            }
            PsiElement element = psiReference.getElement();
            if (INCLUDE_SRC_PATTERN.accepts((Object)element, new ProcessingContext()) && (containingFile = element.getContainingFile()) != psiFile && !files.contains(containingFile)) {
                ActionAttributeValueReference.collectNeighbours(containingFile, files);
            }
            return true;
        });
        this.myIncludesSearch = false;
    }

    private static boolean acceptFromViewId(PsiFile containingFile, GenericDomValue<PathReference> fromViewId) {
        String stringValue = fromViewId.getStringValue();
        if (stringValue == null || stringValue.trim().equals("*")) {
            return true;
        }
        PathReference webPath = (PathReference)fromViewId.getValue();
        if (webPath == null) {
            return false;
        }
        PsiElement element = webPath.resolve();
        return containingFile.equals(element) || element instanceof PsiDirectory && element.equals(containingFile.getParent());
    }

    @Nullable
    private static FacesConfig getMergedFacesConfig(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)virtualFile, (Project)psiFile.getProject());
        if (webFacet == null) {
            return null;
        }
        FacesDomModel combinedModel = FacesDomModelManager.getInstance(psiFile.getProject()).getCombinedModel(webFacet);
        if (combinedModel == null) {
            return null;
        }
        return combinedModel.getFacesConfig();
    }

    @Nullable
    private static PsiFile getPsiFile(PsiElement element) {
        return element.getContainingFile().getOriginalFile();
    }
}

