/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfLibraryDirectoryReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    public JsfLibraryDirectoryReference(PsiElement psiElement) {
        super(psiElement);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet resolvResultSet = new HashSet();
        for (PsiDirectory psiDirectory : JsfCommonUtils.getResourceLibraryDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), this.getValue())) {
            resolvResultSet.add(new PsiElementResolveResult((PsiElement)psiDirectory));
        }
        ResolveResult[] resolveResultArray = resolvResultSet.toArray(new ResolveResult[resolvResultSet.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfLibraryDirectoryReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        java.util.HashSet<String> added = new java.util.HashSet<String>();
        Set<PsiDirectory> directories = JsfCommonUtils.getTopLevelLibraryDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()));
        for (PsiDirectory directory : directories) {
            for (PsiDirectory subDirectory : directory.getSubdirectories()) {
                if (added.contains(subDirectory.getName())) continue;
                variants.add(subDirectory);
                added.add(subDirectory.getName());
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfLibraryDirectoryReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = FacesBundle.message("cannot.resolve.library", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfLibraryDirectoryReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        Set<PsiDirectory> context = JsfCommonUtils.getTopLevelLibraryDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()));
        for (PsiDirectory psiDirectory : context) {
            if (!psiDirectory.isWritable()) continue;
            return new LocalQuickFix[]{this.createLocalQuickFix(psiDirectory)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private LocalQuickFix createLocalQuickFix(final PsiDirectory parentDirectory) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = FacesBundle.message("create.resource.directory", JsfLibraryDirectoryReference.this.getValue());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfLibraryDirectoryReference$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = FacesBundle.message("jsf.relocatable.resources", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfLibraryDirectoryReference$1", "getFamilyName"));
                }
                return string;
            }

            @Nullable
            public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/references/JsfLibraryDirectoryReference$1", "getElementToMakeWritable"));
                }
                return null;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/references/JsfLibraryDirectoryReference$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jsf/references/JsfLibraryDirectoryReference$1", "applyFix"));
                }
                parentDirectory.createSubdirectory(JsfLibraryDirectoryReference.this.getValue());
            }
        };
    }
}

