/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jsf.references.libraries.providers.ReferenceProviderCustomDataHolder;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiVariantsPsiReferenceProvider
extends PsiReferenceProvider
implements ReferenceProviderCustomDataHolder {
    private String myItems = null;

    protected Set<String> getAllVariants() {
        String items = this.getUserData();
        if (StringUtil.isEmptyOrSpaces((String)items)) {
            return Collections.emptySet();
        }
        HashSet map = new HashSet();
        for (String s : StringUtil.split((String)items, (String)",")) {
            String trimmed = s.trim();
            if (StringUtil.isEmpty((String)trimmed)) continue;
            map.add(trimmed);
        }
        return map;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlElement) {
            PsiReference[] psiReferenceArray = new PsiReference[]{this.createReference((XmlElement)element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    protected PsiReference createReference(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider", "createReference"));
        }
        return new MultiVariantsReference(element);
    }

    @Override
    public String getUserData() {
        return this.myItems;
    }

    @Override
    public void putUserData(@Nullable String userData) {
        this.myItems = userData;
    }

    public String getUnresolvedMessagePattern(String value) {
        if (StringUtil.isEmptyOrSpaces((String)this.getUserData())) {
            return FacesBundle.message("value.format.exception", value);
        }
        return FacesBundle.message("value.must.be.one.of", this.getUserData());
    }

    public static String getProviderName() {
        return "variants";
    }

    protected class MultiVariantsReference
    extends PsiReferenceBase<XmlElement>
    implements EmptyResolveMessageProvider {
        public MultiVariantsReference(XmlElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider$MultiVariantsReference", "<init>"));
            }
            super((PsiElement)element);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = MultiVariantsPsiReferenceProvider.this.getUnresolvedMessagePattern(this.getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider$MultiVariantsReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }

        public PsiElement resolve() {
            if (MultiVariantsPsiReferenceProvider.this.getAllVariants().contains(this.getValue())) {
                return this.getElement();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            HashSet items = new HashSet();
            for (String entry : MultiVariantsPsiReferenceProvider.this.getAllVariants()) {
                items.add(LookupElementBuilder.create((String)entry));
            }
            Object[] objectArray = items.toArray(new LookupElementBuilder[items.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider$MultiVariantsReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

