/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.jsf.toolWindow.tree.JsfTreeStructure;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JsfTreeRootNode
extends SimpleNode {
    private Project myProject;
    private JsfTreeStructure myTreeStructure;

    public JsfTreeRootNode(@NotNull Project project, @NotNull JsfTreeStructure jsfTreeStructure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/toolWindow/tree/nodes/JsfTreeRootNode", "<init>"));
        }
        if (jsfTreeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsfTreeStructure", "com/intellij/jsf/toolWindow/tree/nodes/JsfTreeRootNode", "<init>"));
        }
        this.myProject = project;
        this.myTreeStructure = jsfTreeStructure;
    }

    public SimpleNode[] getChildren() {
        ArrayList<JsfModuleNode> children = new ArrayList<JsfModuleNode>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!JsfCommonUtils.isJsfSupported(module)) continue;
            children.add(new JsfModuleNode(module, this.myTreeStructure, this));
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    public boolean isAutoExpandNode() {
        return true;
    }
}

