/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DataSourceCopySettingsAction;
import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/DataSourceCopySettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doCopySettings", "dss", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "placeToClipboard", "b", "", "update", "database-impl"})
public final class DataSourceCopySettingsAction
extends DumbAwareAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        boolean visible = false;
        boolean enabled = false;
        try {
            PsiElement[] psiElementArray;
            if ((PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(e.getDataContext()) == null) {
                return;
            }
            PsiElement[] nodes2 = psiElementArray;
            List dataSources = JBIterable.from((Iterable)ArraysKt.asIterable((Object[])nodes2)).filter(DbDataSource.class).toList();
            int dss2 = CollectionsKt.count((Iterable)((Iterable)JBIterable.from((Iterable)dataSources).filter(DbDataSourceImpl.class).filter((Condition)update.dss.1.INSTANCE)));
            Collection collection = dataSources;
            visible = !collection.isEmpty();
            enabled = visible && dss2 > 0;
        }
        finally {
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiElement[] psiElementArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(e.getDataContext());
        if (psiElementArray == null) {
            return;
        }
        PsiElement[] nodes2 = psiElementArray;
        List dss2 = JBIterable.from((Iterable)ArraysKt.asIterable((Object[])nodes2)).filter(DbDataSourceImpl.class).map((Function)actionPerformed.dss.1.INSTANCE).filter(LocalDataSource.class).toList();
        Collection collection = dss2;
        if (!collection.isEmpty()) {
            List list = dss2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dss");
            this.doCopySettings(list);
        }
    }

    private final void doCopySettings(List<? extends LocalDataSource> dss2) {
        StringBuilder b = new StringBuilder(1024);
        b.append(DataSourceSettingsHelperKt.DATA_SOURCE_SETTINGS_HEADER).append('\n');
        for (LocalDataSource charSequence : dss2) {
            DataSourceSettingsHelperKt.exportSettings(charSequence, b);
        }
        CharSequence charSequence = b;
        if (charSequence.length() == 0) {
            return;
        }
        this.placeToClipboard(b);
    }

    private final void placeToClipboard(CharSequence b) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((Object)b).toString()));
    }
}

