/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpConfigurationImpl;
import com.intellij.database.dump.dbdump.DumpDialog;
import com.intellij.database.dump.dbdump.DumpManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeDumpAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        boolean enabled = NativeDumpAction.isEnabled(e);
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)NativeDumpAction.getDataSource(e));
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)ObjectUtils.assertNotNull((Object)dataSource));
        DumpConfiguration configuration = (DumpConfiguration)ObjectUtils.assertNotNull((Object)DumpConfigurationImpl.of(dialect));
        e.getPresentation().setText(String.format("Dump Data with '%s'", StringUtil.escapeMnemonics((String)configuration.getName())));
    }

    public void actionPerformed(AnActionEvent e) {
        DumpManager manager;
        DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)NativeDumpAction.getDataSource(e));
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        DumpConfiguration configuration = (DumpConfiguration)ObjectUtils.assertNotNull((Object)DumpConfigurationImpl.of(dialect));
        Collection<DbElement> selected = NativeDumpAction.getProcessedElements(e, configuration);
        Project project = (Project)ObjectUtils.assertNotNull((Object)e.getProject());
        DumpDialog dialog = new DumpDialog(dataSource, project, manager = new DumpManager(dataSource, selected, project, configuration), configuration);
        if (dialog.showAndGet()) {
            manager.dump();
        }
        Disposer.dispose((Disposable)manager);
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElements(@Nullable Project project) {
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
            }
            return jBIterable;
        }
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        if (view2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
            }
            return jBIterable;
        }
        Set elements = view2.getTreeBuilder().getSelectedElements();
        JBIterable jBIterable = JBIterable.from((Iterable)elements).filter(DatabaseStructure.GroupElement.class).filter(element -> element.getParent() instanceof DbNamespaceImpl).flatMap(NativeDumpAction::expandGroupElement).append((Iterable)JBIterable.from((Iterable)elements).filter(DbElement.class)).unique();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
        }
        return jBIterable;
    }

    @NotNull
    private static Iterable<DbElement> expandGroupElement(@NotNull DatabaseStructure.GroupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/NativeDumpAction", "expandGroupElement"));
        }
        DbElement parent = (DbElement)element.getParent();
        ObjectKind kind = element.getChildKind();
        JBIterable jBIterable = DbImplUtil.isDataTable(kind) ? parent.getDbChildren(DbElement.class, kind) : JBIterable.of((Object)parent);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "expandGroupElement"));
        }
        return jBIterable;
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "isEnabled"));
        }
        DbDataSource dataSource = NativeDumpAction.getDataSource(e);
        if (dataSource == null) {
            return false;
        }
        LocalDataSource delegate = (LocalDataSource)dataSource.getDelegate();
        if (!NativeDumpAction.isHostAndPortExists(delegate)) {
            return false;
        }
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(DbImplUtil.getDatabaseDialect((DbElement)dataSource));
        return configuration != null && !NativeDumpAction.getProcessedElements(e, configuration).isEmpty() && e.getProject() != null;
    }

    @NotNull
    private static Collection<DbElement> getProcessedElements(@NotNull AnActionEvent e, @NotNull DumpConfiguration configuration) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "getProcessedElements"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/actions/NativeDumpAction", "getProcessedElements"));
        }
        JBIterable<DbElement> elements = NativeDumpAction.getSelectedElements(e.getProject());
        Collection<DbElement> collection = configuration.filterElements(elements.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getProcessedElements"));
        }
        return collection;
    }

    private static boolean isHostAndPortExists(@NotNull LocalDataSource source) {
        String url;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/actions/NativeDumpAction", "isHostAndPortExists"));
        }
        DatabaseDriver driver = source.getDatabaseDriver();
        RawConnectionConfig config = source.getConnectionConfig();
        String string = url = config == null ? null : config.getUrl();
        if (url == null || driver == null) {
            return false;
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create());
        return hostPort != null && hostPort.first != null && hostPort.second != null;
    }

    @Nullable
    private static DbDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "getDataSource"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        HashSet sources = ContainerUtil.newHashSet();
        elements.forEach(element -> sources.add(element.getDataSource()));
        DbDataSource first = (DbDataSource)ContainerUtil.getFirstItem((Collection)sources);
        return sources.size() == 1 && first != null && DbImplUtil.canConnectTo((DbElement)first) ? first : null;
    }
}

