/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryActionBase
extends DumbAwareAction
implements Toggleable {
    public void update(AnActionEvent e) {
        boolean enabled;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext());
        JdbcConsole console = this.getConsole(e);
        boolean isToolbar = ActionPlaces.isToolbarPlace((String)e.getPlace());
        boolean editorOrStructurePopup = EditorUtil.isRealFileEditor((Editor)editor) || editor == null && fileEditor instanceof TextEditor;
        boolean bl = enabled = editorOrStructurePopup && JdbcConsoleProvider.isSqlAtPlace(file, editor) && (!this.isConsoleRequired() || console != null);
        if (enabled && console != null && console.isValid()) {
            TextRange range = ScriptModelUtil.getSelectedStatementsRange(console);
            e.getPresentation().setEnabled(range.getLength() > 0);
            e.getPresentation().setVisible(true);
            e.getPresentation().putClientProperty("selected", (Object)(!console.isIdle() ? 1 : 0));
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || isToolbar);
    }

    @Nullable
    protected JdbcConsole getConsole(AnActionEvent e) {
        return JdbcConsole.findConsole(e);
    }

    protected boolean isConsoleRequired() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        JdbcConsoleProvider.Info info = (JdbcConsoleProvider.Info)ObjectUtils.chooseNotNull((Object)QueryActionBase.getInfoClassic(e), (Object)QueryActionBase.findInfoFromFileStructure(e));
        if (info == null) {
            return;
        }
        this.invokeImpl(e, this.getConsole(e), info);
    }

    @Nullable
    private static JdbcConsoleProvider.Info getInfoClassic(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/QueryActionBase", "getInfoClassic"));
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        PsiElement elementAt = JdbcConsoleProvider.elementAt(file, null, editor);
        if (elementAt == null) {
            return null;
        }
        return JdbcConsoleProvider.findScriptModel(file, elementAt, editor);
    }

    @Nullable
    private static JdbcConsoleProvider.Info findInfoFromFileStructure(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/QueryActionBase", "findInfoFromFileStructure"));
        }
        JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? DataManagerImpl.validateEditor((Editor)((TextEditor)fileEditor).getEditor()) : null;
        if (file == null || elements.isEmpty() || editor == null) {
            return null;
        }
        THashSet set = ContainerUtil.newTroveSet();
        for (PsiElement pe : elements) {
            if (!file.equals(pe.getContainingFile())) {
                return null;
            }
            set.add(pe.getTextRange());
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ScriptModel model = QueryActionBase.filterRanges(SqlPsiFacade.getInstance((Project)project).createScriptModel(file), (Set<TextRange>)set);
        return new JdbcConsoleProvider.Info(file, file, model, (EditorEx)editor, null);
    }

    private static <V> ScriptModel<V> filterRanges(ScriptModel<V> model, final Set<TextRange> set) {
        return model.rawTransform((Function)new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> s) {
                return (SyntaxTraverser)s.regard(Conditions.compose((Function)s.api.TO_RANGE, range -> set.contains(range)));
            }
        });
    }

    protected abstract void invokeImpl(@NotNull AnActionEvent var1, @Nullable JdbcConsole var2, @NotNull JdbcConsoleProvider.Info var3);
}

