/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.DomainWrapper;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentityDomain
extends Domain
implements DomainWrapper {
    private static final String IDENTITY = " IDENTITY";
    private final Domain myDomain;

    public IdentityDomain(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/IdentityDomain", "<init>"));
        }
        super(domain.getPoint(), domain.getDomainType(), domain.simpleName());
        this.myDomain = domain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/IdentityDomain", "narrow"));
        }
        IdentityDomain identityDomain = new IdentityDomain(this.myDomain.narrow(domain));
        if (identityDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IdentityDomain", "narrow"));
        }
        return identityDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/IdentityDomain", "narrow"));
        }
        IdentityDomain identityDomain = new IdentityDomain(this.myDomain.narrow(provider));
        if (identityDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IdentityDomain", "narrow"));
        }
        return identityDomain;
    }

    @Override
    @NotNull
    public Domain unwrap() {
        Domain domain = this.myDomain;
        if (domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IdentityDomain", "unwrap"));
        }
        return domain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myDomain.name() + IDENTITY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IdentityDomain", "name"));
        }
        return string;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality cardinality = this.myDomain.cardinality();
        if (cardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IdentityDomain", "cardinality"));
        }
        return cardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/IdentityDomain", "getCompatibility"));
        }
        Compatibility compatibility = this.myDomain.getCompatibility(domain);
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IdentityDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/IdentityDomain", "trim"));
        }
        return this.myDomain.trim(o);
    }

    @Override
    public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/IdentityDomain", "isSuitable"));
        }
        return StringUtil.equalsIgnoreCase((CharSequence)(this.simpleName() + IDENTITY), (CharSequence)descriptor.getTypeName());
    }
}

