/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.registry.MsSql05Domains;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsSql08Domains
extends MsSql05Domains {
    private static final int MAX_TIME_FRACTION = 7;

    public MsSql08Domains() {
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 7, 7, true));
        this.add(new FractionDomain("datetime2", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
    }

    @Override
    public boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/registry/MsSql08Domains", "isSuitable"));
        }
        return dialect.getFamilyId().isMicrosoft() && productVersion != null && DataSourceUiUtil.isMsSql2008(productVersion);
    }
}

