/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.util.Version;

class DatabaseModelModernLoader {
    static final Map<String, Version> SUPPORTED_VERSIONS = ContainerUtil.immutableMapBuilder().put((Object)Postgres.RDBMS.code, (Object)Version.of((int[])new int[]{9})).put((Object)Oracle.RDBMS.code, (Object)Version.of((int[])new int[]{9})).put((Object)Mssql.RDBMS.code, (Object)Version.of((int[])new int[]{9})).put((Object)Sybase.RDBMS.code, (Object)Version.of((int[])new int[]{15})).put((Object)Mysql.RDBMS.code, (Object)Version.of((int[])new int[]{5, 1})).put((Object)Sqlite.RDBMS.code, (Object)Version.ZERO).build();
    static final Version UNATTAINABLE_FUTURE = Version.of((int[])new int[]{Integer.MAX_VALUE});
    private static final Logger LOG = Logger.getInstance(DatabaseModelModernLoader.class);
    private static final BasicNamespace[] NO_NAMESPACES = new BasicNamespace[0];

    DatabaseModelModernLoader() {
    }

    static void performModernIntrospection(@NotNull ModelFactory modelFactory, @NotNull DBFacade facade, @NotNull LoaderContext context, @NotNull DasModel dasModel, @NotNull ProgressIndicator indicator, @NotNull DBIntrospectionOptions options, @NotNull Function<IntrospectionScope, IntrospectionScope> introspectionScopeUpd, boolean forceLegacy) {
        boolean modern;
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (introspectionScopeUpd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScopeUpd", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        boolean bl = modern = !forceLegacy;
        if (modern) {
            Version serverVersion = facade.getConnectionInfo().serverVersion;
            Version supportedVersion = (Version)ObjectUtils.notNull((Object)SUPPORTED_VERSIONS.get(facade.rdbms().code), (Object)UNATTAINABLE_FUTURE);
            modern = serverVersion.compareTo(supportedVersion) >= 0;
        }
        DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(modelFactory, facade, !modern);
        introspector.setOptions(options);
        LocalDataSource dataSource = context.getDataSource();
        String extra = context.isSchemaListOnly() ? " [schemas only]" : "";
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dasModel, BasicModModel.class);
        indicator.setText("Preparing to " + (model == null ? "complete" : "incremental") + " introspection (" + facade.rdbms().code + ")");
        introspector.init(model);
        model = introspector.getModel();
        if (model != dasModel && dataSource != null) {
            dataSource.setModel(model);
        }
        introspector.setProgressIndicator(indicator);
        DatabaseModelModernLoader.performIntrospectionNewWay(context, introspector, introspectionScopeUpd);
        indicator.setText("Finishing introspection (" + facade.rdbms().code + ")" + extra);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static BasicNamespace[] getNamespacesToIntrospect(@NotNull LoaderContext context, @NotNull BasicModModel model) {
        List namespaces;
        boolean allSchemas;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
        }
        if (context.isSchemaListOnly()) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        if (context.getSelection().contains("*")) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(DasObject.class).transform(DasUtil::getSchemaObject).filter(o -> o.getDbParent() != null).transform(o -> IntrospectionScopes.scopeOf(o.getDbParent().getName(), o.getName()));
        @NotNull JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s -> IntrospectionScopes.fromSchemaPattern(s));
        List scopes = fromStringPatterns.append((Iterable)fromDasObjects).unique().toList();
        boolean bl = allSchemas = !JBIterable.from((Iterable)scopes).filter(s -> s.containsSchema("*", "*")).isEmpty();
        if (allSchemas) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        JBIterable visibleNamespaces = ((JBTreeTraverser)model.traverser().expand(object -> object.getKind() != ObjectKind.SCHEMA)).filter(BasicNamespace.class).filter(BasicNamespace::isVisible);
        int nonLimitedCount = visibleNamespaces.filter(n -> n.getKind() == ObjectKind.SCHEMA || n.getKind() == ObjectKind.DATABASE && !n.hasChildren()).size();
        if (nonLimitedCount == (namespaces = visibleNamespaces.filter(object -> {
            if (object.getKind() == ObjectKind.SCHEMA) {
                for (IntrospectionScope scope : scopes) {
                    if (!DatabaseModelLoader.schemaMatches(object, scope)) continue;
                    return true;
                }
            }
            if (object.getKind() == ObjectKind.DATABASE && !object.hasChildren()) {
                for (IntrospectionScope scope : scopes) {
                    if (!scope.containsDatabase(object.getName())) continue;
                    return true;
                }
            }
            return false;
        }).toList()).size()) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        BasicNamespace[] basicNamespaceArray = namespaces.toArray(new BasicNamespace[namespaces.size()]);
        if (basicNamespaceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
        }
        return basicNamespaceArray;
    }

    private static void performIntrospectionNewWay(LoaderContext context, DBIntrospector introspector, @NotNull Function<IntrospectionScope, IntrospectionScope> introspectionScopeUpd) {
        if (introspectionScopeUpd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScopeUpd", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performIntrospectionNewWay"));
        }
        Runnable introspect = () -> {
            if (introspectionScopeUpd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScopeUpd", "com/intellij/database/dataSource/DatabaseModelModernLoader", "lambda$performIntrospectionNewWay$8"));
            }
            DbImplUtil.performSrcOperation(introspector.getModel(), () -> {
                IntrospectionScope firstScope;
                if (introspectionScopeUpd == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScopeUpd", "com/intellij/database/dataSource/DatabaseModelModernLoader", "lambda$null$7"));
                }
                IntrospectionScope introspectionScope = firstScope = (IntrospectionScope)introspectionScopeUpd.fun(null);
                BasicModModel model = introspector.getModel();
                boolean empty = model.getModelRoots().isEmpty();
                try {
                    introspector.introspectNamespaces();
                    introspectionScope = context.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                    Set<BasicDatabase> dbs = DatabaseModelModernLoader.getDatabases(context, introspector);
                    if (dbs.isEmpty()) {
                        dbs = DatabaseModelModernLoader.getDatabasesFromScope(context, introspector);
                    }
                    if (!dbs.isEmpty()) {
                        introspector.introspectDatabaseSchemas(dbs.toArray(new BasicDatabase[dbs.size()]));
                        introspectionScope = context.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                    }
                }
                finally {
                    if (empty && introspectionScope.isEmpty()) {
                        introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                        introspectionScopeUpd.fun((Object)introspectionScope);
                    } else if (!introspectionScope.equals(firstScope)) {
                        introspectionScopeUpd.fun((Object)introspectionScope);
                    }
                }
                DatabaseModelModernLoader.updateModelVisibility(model, introspectionScope);
                if (context.isSchemaListOnly()) {
                    return;
                }
                introspector.introspectAuto(DatabaseModelModernLoader.getNamespacesToIntrospect(context, model));
            });
        };
        try {
            LocalDataSource dataSource = context.getDataSource();
            if (dataSource != null) {
                dataSource.performBatch(introspect);
            } else {
                introspect.run();
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
        }
    }

    private static Set<BasicDatabase> getDatabases(LoaderContext context, DBIntrospector introspector) {
        JBIterable sel = JBIterable.from(context.getSelection());
        return sel.append((Iterable)sel.filter(DbElement.class).transform(DbElement::getDelegate)).filter(BasicDatabase.class).filter(o -> o.getModel() == introspector.getModel()).toSet();
    }

    private static Set<BasicDatabase> getDatabasesFromScope(LoaderContext context, DBIntrospector introspector) {
        IntrospectionScope scope;
        LocalDataSource source = context.getDataSource();
        IntrospectionScope introspectionScope = scope = source == null ? null : source.getIntrospectionScope();
        if (scope == null || scope.isEmpty()) {
            return Collections.emptySet();
        }
        JBIterable dbs = introspector.getModel().getModelRoots().filter(BasicDatabase.class);
        if (scope.containsDatabase("*")) {
            return dbs.toSet();
        }
        return dbs.filter(db -> db.isCurrent() && scope.containsDatabase("@") || scope.containsDatabase(db.getName())).toSet();
    }

    static void updateModelVisibility(@NotNull BasicModModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelModernLoader", "updateModelVisibility"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelModernLoader", "updateModelVisibility"));
        }
        model.modify(BasicModRoot.class, r -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelModernLoader", "lambda$updateModelVisibility$11"));
            }
            DatabaseModelModernLoader.updateDatabasesVisibility(r.familyOf(ObjectKind.DATABASE), scope);
            DatabaseModelModernLoader.updateSchemasVisibility(r.familyOf(ObjectKind.SCHEMA), null, scope);
        });
    }

    private static void updateDatabasesVisibility(@Nullable Family<? extends BasicElement> databases, @NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelModernLoader", "updateDatabasesVisibility"));
        }
        if (databases == null) {
            return;
        }
        boolean all = scope.containsDatabase("*");
        for (BasicModMateDatabase database : databases.jbi().filter(BasicModMateDatabase.class)) {
            boolean visible = all || scope.containsDatabase(database.getName()) || database.isCurrent() && scope.containsDatabase("@");
            database.setVisible(visible);
            DatabaseModelModernLoader.updateSchemasVisibility(database.familyOf(ObjectKind.SCHEMA), database, scope);
        }
    }

    private static void updateSchemasVisibility(@Nullable Family<? extends BasicElement> schemas2, @Nullable BasicDatabase database, @NotNull IntrospectionScope scope) {
        boolean hasDatabase;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelModernLoader", "updateSchemasVisibility"));
        }
        if (schemas2 == null) {
            return;
        }
        String db = database == null ? "*" : database.getName();
        boolean dbCurrent = database != null && database.isCurrent();
        boolean bl = hasDatabase = scope.containsDatabase(db) || dbCurrent && scope.containsDatabase("@");
        if (!hasDatabase) {
            schemas2.jbi().filter(BasicModMateNamespace.class).forEach(s -> s.setVisible(false));
            return;
        }
        for (BasicModMateNamespace schema : schemas2.jbi().filter(BasicModMateNamespace.class)) {
            boolean visible = scope.containsSchema(db, schema.getName());
            visible |= dbCurrent && scope.containsSchema("@", schema.getName());
            visible |= schema.isCurrent() && scope.containsSchema(db, "@");
            schema.setVisible(visible |= schema.isCurrent() && dbCurrent && scope.containsSchema("@", "@"));
        }
    }
}

