/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorage
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcStorage.class);
    private final Project myProject;
    private final String myStorageRoot;
    protected final FsAccess myFsAccess;
    private final Map<String, DbDataSourceLayout> myDsLayouts;
    private boolean myDsChanged;

    public static boolean isEnabled() {
        return LazyData.STORAGE_ENABLED;
    }

    public static boolean isWritable() {
        return DbSrcStorage.isEnabled();
    }

    @NotNull
    public static DbSrcStorage getInstance(@Nullable Project project) {
        DbSrcStorage service = project == null ? (DbSrcStorage)ServiceManager.getService(App.class) : (DbSrcStorage)ServiceManager.getService((Project)project, DbSrcStorage.class);
        DbSrcStorage dbSrcStorage = service == null ? new DbSrcStorage(project) : service;
        if (dbSrcStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        return dbSrcStorage;
    }

    @NotNull
    public static DbSrcStorage getInstance(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        Project project = dataSource.getProject();
        LocalDataSource localDataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class));
        if (localDataSource != null && localDataSource.isGlobal()) {
            project = null;
        }
        DbSrcStorage dbSrcStorage = DbSrcStorage.getInstance(project);
        if (dbSrcStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        return dbSrcStorage;
    }

    public DbSrcStorage(@Nullable Project project) {
        this(project, FsAccess.INSTANCE);
    }

    public DbSrcStorage(final @Nullable Project project, @NotNull FsAccess fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "<init>"));
        }
        this.myDsLayouts = ContainerUtil.newHashMap();
        this.myFsAccess = fs;
        this.myProject = project;
        this.myStorageRoot = DbSrcStorage.getStorageRoot(project);
        Disposer.register((Disposable)(project != null ? project : ApplicationManager.getApplication()), (Disposable)this);
        DataSourceListener listener = new DataSourceListener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$1", "dataSourceAdded"));
                }
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$1", "dataSourceRemoved"));
                }
                if (project == null != dataSource.isGlobal()) {
                    return;
                }
                DbSrcStorage.this.myDsChanged = true;
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            }
        };
        if (project == null) {
            DataSourceStorage.getStorage().addDataSourceListener(listener, this);
        } else {
            DataSourceManagerEx.getInstanceEx(project).addDataSourceListener(listener, this);
        }
    }

    public void dispose() {
        this.myDsLayouts.values().forEach(Disposer::dispose);
    }

    @NotNull
    public String getStorageRoot() {
        String string = this.myStorageRoot;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getStorageRoot"));
        }
        return string;
    }

    @NotNull
    public FsAccess getFsAccess() {
        FsAccess fsAccess = this.myFsAccess;
        if (fsAccess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getFsAccess"));
        }
        return fsAccess;
    }

    @NotNull
    public List<String> getDataSources() {
        List<String> list = Arrays.asList(this.myFsAccess.list(new BiPath(this.myStorageRoot, null)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getDataSources"));
        }
        return list;
    }

    public boolean exists(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "exists"));
        }
        return this.myFsAccess.getAttributes(new BiPath(this.buildPath(dataSourceId), null)) != null;
    }

    @Nullable
    public String getDataSourceId(@Nullable String path) {
        String st;
        String rootPath;
        if (path == null) {
            return null;
        }
        int jarIdx = path.indexOf("!/");
        if (jarIdx != -1) {
            path = path.substring(0, jarIdx);
        }
        if (!path.startsWith(rootPath = this.myStorageRoot)) {
            return null;
        }
        Iterator subPath = JBIterable.from(DbSrcFileSystem.splitPath(path.substring(rootPath.length()))).filter(StringUtil::isNotEmpty).iterator();
        String res = subPath.hasNext() ? (String)subPath.next() : null;
        String string = st = subPath.hasNext() ? (String)subPath.next() : null;
        if (!"_src_".equals(st) && !"_staging_".equals(st)) {
            return null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DbDataSourceLayout getLayout(@NotNull String dataSourceId) {
        LocalDataSource source;
        DbDataSourceLayout layout;
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getLayout"));
        }
        Map<String, DbDataSourceLayout> map = this.myDsLayouts;
        synchronized (map) {
            List<? extends LocalDataSource> sources;
            layout = this.myDsLayouts.get(dataSourceId);
            if (layout == null) {
                layout = new DbDataSourceLayout(dataSourceId, this.buildPath(dataSourceId), this.myFsAccess);
                this.myDsLayouts.put(dataSourceId, layout);
            }
            if ((source = (LocalDataSource)((Object)ContainerUtil.find(sources = DbSrcUtils.getDataSources(this.myProject), s -> {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "lambda$getLayout$0"));
                }
                return s.getUniqueId().equals(dataSourceId);
            }))) != null && this.myProject == null != source.isGlobal()) {
                LOG.warn("Searching data source elsewhere");
            }
            if (!sources.isEmpty() && this.myDsChanged) {
                Set actualIds = JBIterable.from(sources).transform(AbstractDataSource::getUniqueId).append((Object)dataSourceId).toSet();
                Iterator<Map.Entry<String, DbDataSourceLayout>> it = this.myDsLayouts.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, DbDataSourceLayout> entry = it.next();
                    if (actualIds.contains(entry.getKey())) continue;
                    Disposer.dispose((Disposable)entry.getValue());
                    it.remove();
                }
            }
            this.myDsChanged = false;
        }
        if (source != null && source.getDefaultDialect() != null && layout.getLanguage().getID() != source.getDefaultDialect()) {
            SqlLanguageDialect lang;
            String defaultDialect = source.getDefaultDialect();
            SqlLanguageDialect sqlLanguageDialect = lang = StringUtil.isEmpty((String)defaultDialect) ? null : DbSqlUtil.findDialectById(defaultDialect);
            if (lang == null) {
                lang = DbSqlUtil.getGenericDialect();
            }
            layout.updateSettings(lang);
        }
        DbDataSourceLayout dbDataSourceLayout = layout;
        if (dbDataSourceLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getLayout"));
        }
        return dbDataSourceLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLayouts() {
        Map<String, DbDataSourceLayout> map = this.myDsLayouts;
        synchronized (map) {
            Iterator<Map.Entry<String, DbDataSourceLayout>> it = this.myDsLayouts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DbDataSourceLayout> entry = it.next();
                Disposer.dispose((Disposable)entry.getValue());
                it.remove();
            }
        }
    }

    @NotNull
    public String buildPath(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "buildPath"));
        }
        String string = this.myStorageRoot + "/" + dataSourceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "buildPath"));
        }
        return string;
    }

    @NotNull
    public static String getStorageRoot(@Nullable Project project) {
        String storage = DataSourceStorage.getStoragePath(project);
        if (storage == null && project != null) {
            storage = project.getProjectFilePath();
        }
        if (storage == null) {
            storage = PathManager.getOptionsPath() + "/dummy";
        }
        String string = new File(new File(storage).getParentFile(), "dataSources").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getStorageRoot"));
        }
        return string;
    }

    public void clear() {
        this.clearLayouts();
        FileUtil.delete((File)new File(FileUtil.toSystemDependentName((String)this.myStorageRoot)));
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.getInstance().findFileByPath("/")});
    }

    public static class App
    extends DbSrcStorage {
        public App(@NotNull FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$App", "<init>"));
            }
            super(null, fs);
        }

        public App() {
            super(null);
        }
    }

    public static class FsAccess {
        public static final FsAccess INSTANCE = new FsAccess();

        protected NewVirtualFileSystem fs(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "fs"));
            }
            return path.zip != null ? JarFileSystem.getInstance() : LocalFileSystem.getInstance();
        }

        @Nullable
        public VirtualFile findFileByPath(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "findFileByPath"));
            }
            if (FsAccess.nonExistentZip(path)) {
                return null;
            }
            return this.fs(path).findFileByPath(path.toPath());
        }

        public void markDirty(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "markDirty"));
            }
            VirtualFile file = this.findFileByPath(path);
            if (file == null) {
                return;
            }
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
        }

        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "refreshAndFindFileByPath"));
            }
            if (FsAccess.nonExistentZip(path)) {
                return null;
            }
            return this.fs(path).refreshAndFindFileByPath(path.toPath());
        }

        @NotNull
        public String[] list(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "list"));
            }
            if (FsAccess.nonExistentZip(path)) {
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "list"));
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            String[] stringArray = this.fs(path).list(this.createStubFile(path));
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "list"));
            }
            return stringArray;
        }

        @Nullable
        public FileAttributes getAttributes(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getAttributes"));
            }
            if (FsAccess.nonExistentZip(path)) {
                return null;
            }
            return this.fs(path).getAttributes(this.createStubFile(path));
        }

        @NotNull
        public byte[] getContents(@NotNull BiPath path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getContents"));
            }
            if (FsAccess.nonExistentZip(path)) {
                if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getContents"));
                }
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] byArray = this.fs(path).contentsToByteArray(this.createStubFile(path));
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getContents"));
            }
            return byArray;
        }

        @NotNull
        public InputStream getInputStream(@NotNull BiPath path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getInputStream"));
            }
            InputStream inputStream = this.fs(path).getInputStream(this.createStubFile(path));
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getInputStream"));
            }
            return inputStream;
        }

        @NotNull
        private VirtualFile createStubFile(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "createStubFile"));
            }
            VirtualFile file = this.findFileByPath(path);
            VirtualFile virtualFile = file == null ? FsAccess.createStubFile(path.toPath()) : file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "createStubFile"));
            }
            return virtualFile;
        }

        private static boolean nonExistentZip(@NotNull BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "nonExistentZip"));
            }
            return path.zip != null && LocalFileSystem.getInstance().getAttributes(FsAccess.createStubFile(path.local)) == null;
        }

        @NotNull
        private static VirtualFile createStubFile(final @NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "createStubFile"));
            }
            StubVirtualFile stubVirtualFile = new StubVirtualFile(){

                @NotNull
                public String getPath() {
                    String string = path;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess$1", "getPath"));
                    }
                    return string;
                }

                @Nullable
                public VirtualFile getParent() {
                    return NullVirtualFile.INSTANCE;
                }
            };
            if (stubVirtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "createStubFile"));
            }
            return stubVirtualFile;
        }
    }

    public static class BiPath {
        @NotNull
        public final String local;
        @Nullable
        public final String zip;

        public BiPath(@NotNull String local, @Nullable String zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$BiPath", "<init>"));
            }
            this.local = local;
            this.zip = zip;
        }

        public String toPath() {
            return this.zip == null ? this.local : this.local + "!/" + this.zip;
        }
    }

    private static class LazyData {
        public static final boolean STORAGE_ENABLED;

        private LazyData() {
        }

        static {
            ApplicationManager.getApplication().getComponent(RegistryState.class);
            STORAGE_ENABLED = Registry.is((String)"database.src_storage.enabled", (boolean)true);
        }
    }
}

