/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import org.jetbrains.annotations.NotNull;

public interface AutoValueDescriptor
extends ColumnDescriptor {
    public boolean isAutogenerated();

    public boolean hasDefault();

    public static class DelegateDescriptor<T extends ColumnDescriptor>
    implements AutoValueDescriptor {
        private final T myDelegate;
        private final boolean myAutogenerated;
        private final boolean myHasDefault;

        public DelegateDescriptor(@NotNull T delegate, boolean autogenerated, boolean hasDefault) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/datagrid/AutoValueDescriptor$DelegateDescriptor", "<init>"));
            }
            this.myDelegate = delegate;
            this.myAutogenerated = autogenerated;
            this.myHasDefault = hasDefault;
        }

        @Override
        public int getScale() {
            return this.myDelegate.getScale();
        }

        @Override
        public int getSize() {
            return this.myDelegate.getSize();
        }

        @Override
        public int getType() {
            return this.myDelegate.getType();
        }

        @Override
        public String getName() {
            return this.myDelegate.getName();
        }

        @Override
        public String getTypeName() {
            return this.myDelegate.getTypeName();
        }

        @Override
        public String getJavaClassName() {
            return this.myDelegate.getJavaClassName();
        }

        @Override
        public boolean isAutogenerated() {
            return this.myAutogenerated;
        }

        @Override
        public boolean hasDefault() {
            return this.myHasDefault;
        }

        @NotNull
        public T getDelegate() {
            T t = this.myDelegate;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/AutoValueDescriptor$DelegateDescriptor", "getDelegate"));
            }
            return t;
        }

        public String toString() {
            return this.myDelegate.toString();
        }
    }
}

