/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvLexer {
    public static final int MAX_CHARACTERS = 0x500000;
    private CsvRecordFormat myCsvFormat;
    private long myCharacters;
    private long myLine;
    private long myLineCharacters;
    private TokenType myType;
    private long myStart;
    private long myEnd;
    private long myOffset;
    private long myTokenLine;
    private String myText;
    private State myState = State.RECORD_START;

    public void setCsvFormat(@NotNull CsvRecordFormat csvFormat) {
        if (csvFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "csvFormat", "com/intellij/database/datagrid/CsvLexer", "setCsvFormat"));
        }
        this.myCsvFormat = csvFormat;
    }

    public void advance(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "advance"));
        }
        if (!CsvLexer.isReady(reader)) {
            this.setNullToken();
            return;
        }
        this.myState.nextToken(this, reader);
        while (CsvLexer.isReady(reader) && this.myType == null) {
            this.nextState();
            this.myState.nextToken(this, reader);
        }
        this.nextState();
    }

    public long getTokenLine() {
        return this.myTokenLine;
    }

    @Nullable
    public TokenType getType() {
        return this.myType;
    }

    public long getStart() {
        return this.myStart;
    }

    public long getEnd() {
        return this.myEnd;
    }

    public long getOffset() {
        return this.myOffset;
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    public boolean hasToken() {
        return this.myType != null;
    }

    public long getLine() {
        return this.myLine;
    }

    public long getCharacters() {
        return this.myCharacters;
    }

    public long getLineCharacters() {
        return this.myLineCharacters;
    }

    public void valueOrQuoted(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "valueOrQuoted"));
        }
        CsvRecordFormat.Quotes quotes = this.findQuotes(this.myCsvFormat, reader);
        if (quotes == null) {
            this.value(reader, this.myCsvFormat);
            return;
        }
        this.quotedValue(quotes, this.myCsvFormat, reader);
    }

    protected void nextState() throws IOException {
        this.setState(this.myState.nextState(this.myType));
    }

    private void setState(@Nullable State state) {
        this.myState = state;
    }

    private void setToken(@Nullable TokenType type, @Nullable String text, long start, long end, long line, long offset) {
        this.myType = type;
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
        this.myTokenLine = line;
        this.myOffset = offset;
    }

    private void setNullToken() {
        this.setToken(null, null, -1L, -1L, -1L, -1L);
    }

    private void getSymbolToken(@NotNull Reader reader, @NotNull String symbol, @NotNull TokenType type) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "getSymbolToken"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/database/datagrid/CsvLexer", "getSymbolToken"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/CsvLexer", "getSymbolToken"));
        }
        this.token((line, offset, l) -> {
            void character;
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/database/datagrid/CsvLexer", "lambda$getSymbolToken$0"));
            }
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "lambda$getSymbolToken$0"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/CsvLexer", "lambda$getSymbolToken$0"));
            }
            if (StringUtil.isEmpty((String)symbol)) {
                this.setNullToken();
                return;
            }
            String prefix = CsvLexer.readAhead(reader, symbol.length());
            if (!StringUtil.equals((CharSequence)prefix, (CharSequence)symbol)) {
                this.setNullToken();
                return;
            }
            this.setToken(type, (String)ObjectUtils.assertNotNull((Object)this.read(reader, symbol.length())), (long)character, this.myCharacters, line, offset);
        }, reader);
    }

    @Nullable
    private CsvRecordFormat.Quotes findQuotes(@NotNull CsvRecordFormat format, @NotNull Reader reader) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer", "findQuotes"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "findQuotes"));
        }
        for (CsvRecordFormat.Quotes quote : format.quotes) {
            String text = CsvLexer.readAhead(reader, quote.leftQuote.length());
            if (!StringUtil.equals((CharSequence)text, (CharSequence)quote.leftQuote)) continue;
            this.read(reader, quote.leftQuote.length());
            return quote;
        }
        return null;
    }

    private void quotedValue(@NotNull CsvRecordFormat.Quotes quotes, @NotNull CsvRecordFormat format, @NotNull Reader reader) throws IOException {
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvLexer", "quotedValue"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer", "quotedValue"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "quotedValue"));
        }
        this.token((line, offset, l) -> {
            void character;
            if (quotes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvLexer", "lambda$quotedValue$1"));
            }
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "lambda$quotedValue$1"));
            }
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer", "lambda$quotedValue$1"));
            }
            StringBuilder sb = new StringBuilder();
            Pattern pattern = Pattern.compile(Pattern.quote(quotes.rightQuoteEscaped));
            boolean maxChars = false;
            while (CsvLexer.isReady(reader) && !CsvLexer.isEndWithQuote(sb, quotes, reader, pattern)) {
                String text = this.read(reader, 1);
                if (sb.length() < 0x500000) {
                    sb.append(text);
                    continue;
                }
                maxChars = true;
                break;
            }
            if (maxChars) {
                this.readForQuote(quotes, sb, reader, pattern);
            }
            boolean quote = !maxChars && CsvLexer.isEndWithQuote(sb, quotes, reader, pattern);
            String text = quote ? sb.delete(Math.max(sb.length() - quotes.rightQuote.length(), 0), sb.length()).toString() : sb.toString();
            long end = quote ? this.myCharacters - (long)quotes.rightQuote.length() : this.myCharacters;
            String withQuotes = StringUtil.replace((String)text, (String)quotes.rightQuoteEscaped, (String)quotes.rightQuote);
            this.trimAndSet(withQuotes, format, TokenType.QUOTED_VALUE, line, offset, (long)character, end);
        }, reader);
    }

    private void readForQuote(@NotNull CsvRecordFormat.Quotes quotes, @NotNull StringBuilder old, @NotNull Reader reader, @NotNull Pattern pattern) throws IOException {
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvLexer", "readForQuote"));
        }
        if (old == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "old", "com/intellij/database/datagrid/CsvLexer", "readForQuote"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "readForQuote"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/datagrid/CsvLexer", "readForQuote"));
        }
        String begin = CsvLexer.getStartString(quotes, old);
        StringBuilder sb = new StringBuilder(begin);
        while (CsvLexer.isReady(reader) && !CsvLexer.isEndWithQuote(sb, quotes, reader, pattern)) {
            sb.append(this.read(reader, 1));
            if (sb.length() < 0x500000) continue;
            String startStr = CsvLexer.getStartString(quotes, sb);
            sb = new StringBuilder(startStr);
        }
    }

    private void value(@NotNull Reader reader, @NotNull CsvRecordFormat format) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "value"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer", "value"));
        }
        this.token((line, offset, l) -> {
            void character;
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "lambda$value$2"));
            }
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer", "lambda$value$2"));
            }
            StringBuilder value = new StringBuilder();
            while (CsvLexer.isReady(reader)) {
                boolean isRecordSeparator = CsvLexer.lookAhead(reader, this.myCsvFormat.recordSeparator);
                boolean isValueSeparator = !isRecordSeparator && CsvLexer.lookAhead(reader, this.myCsvFormat.valueSeparator);
                boolean isSuffix = this.isSuffix(reader);
                if (isRecordSeparator || isValueSeparator || isSuffix) break;
                String text = this.read(reader);
                if (value.length() >= 0x500000) continue;
                value.append(text);
            }
            this.trimAndSet(value.toString(), format, TokenType.VALUE, line, offset, (long)character, this.myCharacters);
        }, reader);
    }

    private void separator(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "separator"));
        }
        this.token((line, offset, l) -> {
            void character;
            TokenType type;
            int count;
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "lambda$separator$3"));
            }
            boolean isRecordSeparator = CsvLexer.lookAhead(reader, this.myCsvFormat.recordSeparator);
            boolean isValueSeparator = !isRecordSeparator && CsvLexer.lookAhead(reader, this.myCsvFormat.valueSeparator);
            boolean isSuffix = this.isSuffix(reader);
            int n = isSuffix ? this.myCsvFormat.suffix.length() : (count = isRecordSeparator ? this.myCsvFormat.recordSeparator.length() : this.myCsvFormat.valueSeparator.length());
            TokenType tokenType = isSuffix ? TokenType.SUFFIX : (type = isRecordSeparator ? TokenType.RECORD_SEPARATOR : TokenType.VALUE_SEPARATOR);
            if (!(isRecordSeparator || isValueSeparator || isSuffix)) {
                this.setNullToken();
                return;
            }
            this.setToken(type, (String)ObjectUtils.assertNotNull((Object)this.read(reader, count)), (long)character, this.myCharacters, line, offset);
        }, reader);
    }

    private void token(@NotNull MyComputable computable, @NotNull Reader reader) throws IOException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/datagrid/CsvLexer", "token"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "token"));
        }
        if (!CsvLexer.isReady(reader)) {
            this.setNullToken();
        }
        long character = this.myCharacters;
        long offset = this.myLineCharacters;
        long line = this.myLine;
        computable.compute(line, offset, character);
    }

    @Nullable
    private String read(@NotNull Reader reader, int count) throws IOException {
        String read;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "read"));
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < count && (read = this.read(reader)) != null; ++i2) {
            sb.append(read);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Nullable
    private String read(@NotNull Reader reader) throws IOException {
        boolean isDoubleSeparator;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "read"));
        }
        char[] buffer = new char[1];
        int symbols = reader.read(buffer);
        if (symbols == -1) {
            return null;
        }
        boolean bl = isDoubleSeparator = buffer[0] == '\n' && StringUtil.equals((CharSequence)CsvLexer.readAhead(reader, 1), (CharSequence)"\r") || buffer[0] == '\r' && StringUtil.equals((CharSequence)CsvLexer.readAhead(reader, 1), (CharSequence)"\n");
        if (isDoubleSeparator) {
            symbols = reader.read(buffer);
        }
        String result = StringUtil.convertLineSeparators((String)String.valueOf(buffer, 0, symbols));
        ++this.myCharacters;
        if (StringUtil.isLineBreak((char)buffer[0])) {
            this.myLineCharacters = 0L;
            ++this.myLine;
        } else {
            ++this.myLineCharacters;
        }
        return result;
    }

    static boolean isReady(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "isReady"));
        }
        return CsvLexer.readAhead(reader, 1) != null;
    }

    @NotNull
    private static String getStartString(@NotNull CsvRecordFormat.Quotes quotes, @NotNull StringBuilder sb) {
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvLexer", "getStartString"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/datagrid/CsvLexer", "getStartString"));
        }
        int start = Math.max(0, sb.length() - Math.max(quotes.rightQuote.length(), quotes.rightQuoteEscaped.length()));
        String string = sb.substring(start, sb.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer", "getStartString"));
        }
        return string;
    }

    @Nullable
    public static String readAhead(@NotNull Reader reader, int count) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "readAhead"));
        }
        char[] buffer = new char[count];
        reader.mark(count);
        int symbols = reader.read(buffer);
        if (symbols == -1) {
            return null;
        }
        String result = String.valueOf(buffer, 0, symbols);
        reader.reset();
        return StringUtil.convertLineSeparators((String)result);
    }

    /*
     * WARNING - void declaration
     */
    private void trimAndSet(@NotNull String text, @NotNull CsvRecordFormat format, @NotNull TokenType type, long line, long offset, long l, long l2) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/CsvLexer", "trimAndSet"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer", "trimAndSet"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/CsvLexer", "trimAndSet"));
        }
        if (!format.trimWhitespace) {
            void end;
            void start;
            this.setToken(type, text, (long)start, (long)end, line, offset);
            return;
        }
        String withoutLeading = StringUtil.trimLeading((String)text);
        int diff = text.length() - withoutLeading.length();
        String withoutTrailing = StringUtil.trimTrailing((String)withoutLeading);
        this.setToken(type, withoutTrailing, (long)(start += (long)diff), (long)(end -= (long)(withoutLeading.length() - withoutTrailing.length())), line, offset += (long)diff);
    }

    private boolean isSuffix(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "isSuffix"));
        }
        if (this.myCsvFormat.suffix.isEmpty()) {
            return false;
        }
        String suffix = this.myCsvFormat.suffix + this.myCsvFormat.recordSeparator;
        String s = CsvLexer.readAhead(reader, suffix.length());
        return s != null && StringUtil.startsWith((CharSequence)suffix, (CharSequence)s);
    }

    private static boolean lookAhead(@NotNull Reader reader, @NotNull String value) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "lookAhead"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/datagrid/CsvLexer", "lookAhead"));
        }
        String read = CsvLexer.readAhead(reader, value.length());
        return StringUtil.equals((CharSequence)read, (CharSequence)value);
    }

    private static boolean isEndWithQuote(@NotNull StringBuilder sb, @NotNull CsvRecordFormat.Quotes quotes, @NotNull Reader reader, @NotNull Pattern pattern) throws IOException {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/datagrid/CsvLexer", "isEndWithQuote"));
        }
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvLexer", "isEndWithQuote"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "isEndWithQuote"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/datagrid/CsvLexer", "isEndWithQuote"));
        }
        if (!StringUtil.endsWith((CharSequence)sb, (CharSequence)quotes.rightQuote)) {
            return false;
        }
        if (quotes.rightQuote.length() >= quotes.rightQuoteEscaped.length()) {
            return true;
        }
        if (StringUtil.endsWith((CharSequence)sb, (CharSequence)quotes.rightQuoteEscaped)) {
            return CsvLexer.isNotEscapedQuote(sb, quotes, reader, pattern);
        }
        String read = sb + StringUtil.notNullize((String)CsvLexer.readAhead(reader, quotes.rightQuoteEscaped.length() - quotes.rightQuote.length()));
        return !StringUtil.endsWith((CharSequence)read, (CharSequence)quotes.rightQuoteEscaped);
    }

    private static boolean isNotEscapedQuote(@NotNull StringBuilder sb, @NotNull CsvRecordFormat.Quotes quotes, @NotNull Reader reader, @NotNull Pattern pattern) throws IOException {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/datagrid/CsvLexer", "isNotEscapedQuote"));
        }
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvLexer", "isNotEscapedQuote"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer", "isNotEscapedQuote"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/datagrid/CsvLexer", "isNotEscapedQuote"));
        }
        Matcher matcher = pattern.matcher(sb);
        int end = -1;
        while (matcher.find()) {
            end = matcher.end();
        }
        if (end == -1) {
            return true;
        }
        int length = quotes.rightQuoteEscaped.length();
        int symbolsToRead = (length - sb.length() + end) % length;
        String text = sb + StringUtil.notNullize((String)CsvLexer.readAhead(reader, symbolsToRead));
        return symbolsToRead != 0 && !CsvLexer.isReady(reader) || !StringUtil.endsWith((CharSequence)text, (CharSequence)quotes.rightQuoteEscaped);
    }

    @NotNull
    private static String getElementText(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/CsvLexer", "getElementText"));
        }
        String s = StringUtil.toLowerCase((String)type.toString());
        String string = StringUtil.join((String[])s.split("_"), (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer", "getElementText"));
        }
        return string;
    }

    private static enum State {
        RECORD_START{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/CsvLexer$State$1", "nextToken"));
                }
                if (reader == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer$State$1", "nextToken"));
                }
                lexer.getSymbolToken(reader, ((CsvLexer)lexer).myCsvFormat.prefix, TokenType.PREFIX);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = VALUE_START;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$State$1", "nextState"));
                }
                return state;
            }
        }
        ,
        RECORD_END{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/CsvLexer$State$2", "nextToken"));
                }
                if (reader == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer$State$2", "nextToken"));
                }
                lexer.getSymbolToken(reader, ((CsvLexer)lexer).myCsvFormat.suffix, TokenType.SUFFIX);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = type == null || type == TokenType.RECORD_SEPARATOR ? VALUE_START : VALUE_END;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$State$2", "nextState"));
                }
                return state;
            }
        }
        ,
        VALUE_START{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/CsvLexer$State$3", "nextToken"));
                }
                if (reader == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer$State$3", "nextToken"));
                }
                lexer.valueOrQuoted(reader);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = VALUE_END;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$State$3", "nextState"));
                }
                return state;
            }
        }
        ,
        VALUE_END{

            @Override
            void nextToken(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
                if (lexer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/CsvLexer$State$4", "nextToken"));
                }
                if (reader == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvLexer$State$4", "nextToken"));
                }
                lexer.separator(reader);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) throws IOException {
                State state = type == null ? RECORD_END : (type == TokenType.SUFFIX ? VALUE_END : (type == TokenType.RECORD_SEPARATOR ? RECORD_START : VALUE_START));
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$State$4", "nextState"));
                }
                return state;
            }
        };


        abstract void nextToken(@NotNull CsvLexer var1, @NotNull Reader var2) throws IOException;

        @NotNull
        abstract State nextState(@Nullable TokenType var1) throws IOException;
    }

    public static class TokenType {
        private static final IElementType RECORD_SEPARATOR_TYPE = new IElementType("RECORD_SEPARATOR", null);
        private static final IElementType VALUE_SEPARATOR_TYPE = new IElementType("VALUE_SEPARATOR", null);
        private static final IElementType VALUE_TYPE = new IElementType("VALUE", null);
        private static final IElementType QUOTED_VALUE_TYPE = new IElementType("QUOTED_VALUE", null);
        private static final IElementType SUFFIX_TYPE = new IElementType("SUFFIX", null);
        private static final IElementType PREFIX_TYPE = new IElementType("PREFIX", null);
        public static final TokenType RECORD_SEPARATOR = new TokenType(RECORD_SEPARATOR_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer$TokenType$1", "getDebugName"));
                }
                String string = super.getDebugName(format) + " (" + format.recordSeparator + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$1", "getDebugName"));
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/CsvLexer$TokenType$1", "getTokenRepresentation"));
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$1", "getTokenRepresentation"));
                }
                return string;
            }
        };
        public static final TokenType VALUE_SEPARATOR = new TokenType(VALUE_SEPARATOR_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer$TokenType$2", "getDebugName"));
                }
                String string = super.getDebugName(format) + " (" + format.valueSeparator + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$2", "getDebugName"));
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/CsvLexer$TokenType$2", "getTokenRepresentation"));
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$2", "getTokenRepresentation"));
                }
                return string;
            }
        };
        public static final TokenType VALUE = new TokenType(VALUE_TYPE){

            @Override
            @NotNull
            protected String wrap(@NotNull String s) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/datagrid/CsvLexer$TokenType$3", "wrap"));
                }
                String string = "\"" + s + "\"";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$3", "wrap"));
                }
                return string;
            }
        };
        public static final TokenType QUOTED_VALUE = new TokenType(QUOTED_VALUE_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer$TokenType$4", "getDebugName"));
                }
                if ("value" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$4", "getDebugName"));
                }
                return "value";
            }

            @Override
            @NotNull
            protected String wrap(@NotNull String s) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/datagrid/CsvLexer$TokenType$4", "wrap"));
                }
                String string = s;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$4", "wrap"));
                }
                return string;
            }
        };
        public static final TokenType PREFIX = new TokenType(PREFIX_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer$TokenType$5", "getDebugName"));
                }
                String string = super.getDebugName(format) + " (" + format.prefix + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$5", "getDebugName"));
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/CsvLexer$TokenType$5", "getTokenRepresentation"));
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$5", "getTokenRepresentation"));
                }
                return string;
            }
        };
        public static final TokenType SUFFIX = new TokenType(SUFFIX_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer$TokenType$6", "getDebugName"));
                }
                String string = super.getDebugName(format) + " (" + format.suffix + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$6", "getDebugName"));
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/CsvLexer$TokenType$6", "getTokenRepresentation"));
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType$6", "getTokenRepresentation"));
                }
                return string;
            }
        };
        protected final String myName;
        private final IElementType myElementType;

        private TokenType(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/CsvLexer$TokenType", "<init>"));
            }
            this.myElementType = type;
            this.myName = CsvLexer.getElementText(type);
        }

        @NotNull
        public String getDebugName(@NotNull CsvRecordFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvLexer$TokenType", "getDebugName"));
            }
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType", "getDebugName"));
            }
            return string;
        }

        @NotNull
        String getTokenRepresentation(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/CsvLexer$TokenType", "getTokenRepresentation"));
            }
            String string = this.wrap(StringUtil.escapeStringCharacters((String)text));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType", "getTokenRepresentation"));
            }
            return string;
        }

        @NotNull
        protected String wrap(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/datagrid/CsvLexer$TokenType", "wrap"));
            }
            String string = "(" + s + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType", "wrap"));
            }
            return string;
        }

        @NotNull
        public IElementType getElementType() {
            IElementType iElementType = this.myElementType;
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvLexer$TokenType", "getElementType"));
            }
            return iElementType;
        }

        public String toString() {
            return this.myElementType.toString();
        }
    }

    private static interface MyComputable {
        public void compute(long var1, long var3, long var5) throws IOException;
    }
}

