/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchSessionColorLayer
implements ColorLayer {
    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getCellBackground"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getCellBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getCellBackground"));
        }
        GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession = grid.getSearchSession();
        if (searchSession != null && searchSession.isMatchedCell(row, column)) {
            TextAttributes searchMatchAttributes = grid.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
            Color searchMatchBackground = searchMatchAttributes.getBackgroundColor();
            return searchMatchBackground != null ? searchMatchBackground : DbUIUtil.softHighlightOf(color);
        }
        return color;
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getRowHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getRowHeaderBackground"));
        }
        return color;
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getColumnHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SearchSessionColorLayer", "getColumnHeaderBackground"));
        }
        return color;
    }

    @Override
    public int getPriority() {
        return 4;
    }
}

