/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionColorLayer
implements ColorLayer {
    private final TableResultView myView;

    public SelectionColorLayer(@NotNull TableResultView view2) {
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/datagrid/color/SelectionColorLayer", "<init>"));
        }
        this.myView = view2;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/SelectionColorLayer", "getCellBackground"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/SelectionColorLayer", "getCellBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getCellBackground"));
        }
        return grid.getSelectionModel().isSelectedRow(row) ? this.getSelectedCellColor(grid, color) : (Color)ObjectUtils.chooseNotNull((Object)color, (Object)this.myView.getBackground());
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/SelectionColorLayer", "getRowHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getRowHeaderBackground"));
        }
        return grid.getSelectionModel().isSelectedRow(row) ? SelectionColorLayer.getSelectedRowColor(grid, color) : this.getHeaderColor(color);
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/SelectionColorLayer", "getColumnHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getColumnHeaderBackground"));
        }
        return grid.getSelectionModel().isSelectedColumn(column) ? SelectionColorLayer.getSelectedColumnColor(grid, color) : this.getHeaderColor(color);
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @NotNull
    private Color getHeaderColor(@Nullable Color color) {
        Color color2 = color == null ? DbUIUtil.softHighlightOf(this.myView.getBackground()) : color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/SelectionColorLayer", "getHeaderColor"));
        }
        return color2;
    }

    @NotNull
    private Color getSelectedCellColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getSelectedCellColor"));
        }
        Color color2 = color == null ? (Color)ObjectUtils.chooseNotNull((Object)grid.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW), (Object)this.myView.getBackground()) : DbUIUtil.softHighlightOf(color);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/SelectionColorLayer", "getSelectedCellColor"));
        }
        return color2;
    }

    @NotNull
    private static Color getSelectedRowColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getSelectedRowColor"));
        }
        Color color2 = color == null ? SelectionColorLayer.getCurrentColor(grid) : DbUIUtil.softHighlightOf(color);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/SelectionColorLayer", "getSelectedRowColor"));
        }
        return color2;
    }

    @NotNull
    private static Color getSelectedColumnColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getSelectedColumnColor"));
        }
        Color color2 = color == null ? SelectionColorLayer.getCurrentColor(grid) : color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/SelectionColorLayer", "getSelectedColumnColor"));
        }
        return color2;
    }

    @NotNull
    private static Color getCurrentColor(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/SelectionColorLayer", "getCurrentColor"));
        }
        Color rowColor = grid.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW);
        Color selectedColumnBackground = (Color)ObjectUtils.chooseNotNull((Object)rowColor, (Object)UIUtil.getDecoratedRowColor());
        JBColor jBColor = new JBColor(selectedColumnBackground, selectedColumnBackground);
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/SelectionColorLayer", "getCurrentColor"));
        }
        return jBColor;
    }
}

