/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ObjectToTextConverter;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportInfo {
    private final CsvFormat myFormat;
    private final DeTable myTable;
    private final String myProducerName;
    private final ImportType myType;
    private final ImportAction.InputType myInputType;
    private final HandleErrorTask.ErrorTaskInfo myErrorTaskInfo;
    private final boolean myLockTable;
    private final List<? extends ColumnDescriptor> myProducers;
    private final Cache myCache;
    private final DatabaseEditorContext myContext;
    private final boolean myInsertAsNull;
    private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
    private List<AutoValueDescriptor> myConsumers;

    private ImportInfo(@Nullable CsvFormat format, @NotNull DeTable table, @NotNull List<AutoValueDescriptor> consumers, @NotNull List<? extends ColumnDescriptor> producers, @NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map, @NotNull String producerName, @NotNull ImportType importType, @NotNull DatabaseEditorContext context, @NotNull ImportAction.InputType inputType, @NotNull HandleErrorTask.ErrorTaskInfo errorTaskInfo, boolean lockTable, boolean insertAsNull) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (consumers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumers", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (producers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producers", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (producerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerName", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (importType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (inputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputType", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (errorTaskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTaskInfo", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        this.myFormat = format;
        this.myTable = table;
        this.myProducers = producers;
        this.myProducerName = producerName;
        this.myType = importType;
        this.myInputType = inputType;
        this.myErrorTaskInfo = errorTaskInfo;
        this.myLockTable = lockTable;
        this.myConsumers = consumers;
        this.myConsumerToProducer = map;
        this.myContext = context;
        this.myInsertAsNull = insertAsNull;
        this.myCache = new Cache();
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumers() {
        List<AutoValueDescriptor> list = this.myConsumers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getConsumers"));
        }
        return list;
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumersForInsert() {
        List list = ContainerUtil.filter(this.myConsumers, consumer -> this.myConsumerToProducer.get(consumer) != null || consumer.isAutogenerated() || consumer.hasDefault());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getConsumersForInsert"));
        }
        return list;
    }

    @NotNull
    public ImportAction.InputType getInputType() {
        ImportAction.InputType inputType = this.myInputType;
        if (inputType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getInputType"));
        }
        return inputType;
    }

    public boolean isInsertAsNull() {
        return this.myInsertAsNull;
    }

    @Nullable
    public CsvFormat getFormat() {
        return this.myFormat;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTable.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getTableName"));
        }
        return string;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getContext"));
        }
        return databaseEditorContext;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = this.myTable;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getTable"));
        }
        return deTable;
    }

    @NotNull
    public ImportType getType() {
        ImportType importType = this.myType;
        if (importType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getType"));
        }
        return importType;
    }

    @NotNull
    public HandleErrorTask.ErrorTaskInfo getErrorTaskInfo() {
        HandleErrorTask.ErrorTaskInfo errorTaskInfo = this.myErrorTaskInfo;
        if (errorTaskInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getErrorTaskInfo"));
        }
        return errorTaskInfo;
    }

    public boolean shouldLockTable() {
        return this.myLockTable;
    }

    @NotNull
    public String getProducerName() {
        String string = this.myProducerName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getProducerName"));
        }
        return string;
    }

    @NotNull
    public Cache cache() {
        Cache cache = this.myCache;
        if (cache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "cache"));
        }
        return cache;
    }

    public void setConsumers(@NotNull List<ColumnDescriptor> consumers) {
        if (consumers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumers", "com/intellij/database/dbimport/ImportInfo", "setConsumers"));
        }
        ArrayList newConsumers = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < consumers.size(); ++i2) {
            AutoValueDescriptor oldOne = this.myConsumers.get(i2);
            newConsumers.add(ImportUtil.createDescriptor(consumers.get(i2), oldOne.isAutogenerated(), oldOne.hasDefault()));
        }
        this.myConsumers = newConsumers;
        LinkedHashMap newMap = ContainerUtilRt.newLinkedHashMap();
        Iterator<Map.Entry<AutoValueDescriptor, ColumnDescriptor>> iterator = this.myConsumerToProducer.entrySet().iterator();
        for (AutoValueDescriptor consumer : this.myConsumers) {
            if (!iterator.hasNext()) break;
            AutoValueDescriptor existingConsumer = iterator.next().getKey();
            ColumnDescriptor producer = this.myConsumerToProducer.get(existingConsumer);
            newMap.put(consumer, producer);
        }
        this.myConsumerToProducer = newMap;
    }

    @NotNull
    private Collection<AutoValueDescriptor> mappedConsumers() {
        List list = ContainerUtil.filter(this.myConsumers, consumer -> this.myConsumerToProducer.get(consumer) != null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "mappedConsumers"));
        }
        return list;
    }

    public static class Builder {
        private CsvFormat myFormat;
        private DeTable myTable;
        private String myProducerName;
        private ImportType myImportType;
        private ImportAction.InputType myInputType;
        private HandleErrorTask.ErrorTaskInfo myErrorTaskInfo;
        private boolean myLockTable;
        private List<? extends ColumnDescriptor> myProducers;
        private DatabaseEditorContext myContext;
        private boolean myInsertAsNull;
        private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
        private List<AutoValueDescriptor> myConsumers;
        private List<DataConsumer.Row> myRows;
        private List<? extends ColumnDescriptor> myVisibleProducers;

        @NotNull
        public Builder rows(@NotNull List<DataConsumer.Row> rows) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dbimport/ImportInfo$Builder", "rows"));
            }
            this.myRows = rows;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "rows"));
            }
            return builder;
        }

        @NotNull
        public Builder csvFormat(@Nullable CsvFormat format) {
            this.myFormat = format;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "csvFormat"));
            }
            return builder;
        }

        @NotNull
        public Builder consumer(@NotNull DeTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportInfo$Builder", "consumer"));
            }
            this.myTable = table;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "consumer"));
            }
            return builder;
        }

        @NotNull
        public Builder producerName(@NotNull String producerName) {
            if (producerName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerName", "com/intellij/database/dbimport/ImportInfo$Builder", "producerName"));
            }
            this.myProducerName = producerName;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "producerName"));
            }
            return builder;
        }

        @NotNull
        public Builder importType(@NotNull ImportType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dbimport/ImportInfo$Builder", "importType"));
            }
            this.myImportType = type;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "importType"));
            }
            return builder;
        }

        @NotNull
        public Builder inputType(@NotNull ImportAction.InputType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dbimport/ImportInfo$Builder", "inputType"));
            }
            this.myInputType = type;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "inputType"));
            }
            return builder;
        }

        @NotNull
        public Builder errorTaskInfo(@NotNull HandleErrorTask.ErrorTaskInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportInfo$Builder", "errorTaskInfo"));
            }
            this.myErrorTaskInfo = info;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "errorTaskInfo"));
            }
            return builder;
        }

        @NotNull
        public Builder lockTable(boolean lockTable) {
            this.myLockTable = lockTable;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "lockTable"));
            }
            return builder;
        }

        @NotNull
        public Builder producers(@NotNull List<? extends ColumnDescriptor> producers) {
            if (producers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producers", "com/intellij/database/dbimport/ImportInfo$Builder", "producers"));
            }
            this.myProducers = producers;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "producers"));
            }
            return builder;
        }

        @NotNull
        public Builder visibleProducers(@NotNull List<? extends ColumnDescriptor> visibleProducers) {
            if (visibleProducers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleProducers", "com/intellij/database/dbimport/ImportInfo$Builder", "visibleProducers"));
            }
            this.myVisibleProducers = visibleProducers;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "visibleProducers"));
            }
            return builder;
        }

        @NotNull
        public Builder editorContext(@NotNull DatabaseEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportInfo$Builder", "editorContext"));
            }
            this.myContext = context;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "editorContext"));
            }
            return builder;
        }

        @NotNull
        public Builder insertAsNull(boolean insertAsNull) {
            this.myInsertAsNull = insertAsNull;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "insertAsNull"));
            }
            return builder;
        }

        @NotNull
        public Builder mapping(@NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dbimport/ImportInfo$Builder", "mapping"));
            }
            this.myConsumerToProducer = map;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "mapping"));
            }
            return builder;
        }

        @NotNull
        public Builder consumers(@NotNull List<AutoValueDescriptor> descriptors) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ImportInfo$Builder", "consumers"));
            }
            this.myConsumers = descriptors;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "consumers"));
            }
            return builder;
        }

        @NotNull
        public ImportInfo build() {
            ImportInfo importInfo = new ImportInfo(this.myFormat, this.myTable, this.myConsumers, this.myProducers, this.myConsumerToProducer, this.myProducerName, this.myImportType, this.myContext, this.myInputType, this.myErrorTaskInfo, this.myLockTable, this.myInsertAsNull);
            if (importInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Builder", "build"));
            }
            return importInfo;
        }

        public DatabaseEditorContext getContext() {
            return this.myContext;
        }

        public ImportAction.InputType getInputType() {
            return this.myInputType;
        }

        public ImportType getImportType() {
            return this.myImportType;
        }

        public CsvFormat getFormat() {
            return this.myFormat;
        }

        public LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> getMapping() {
            return this.myConsumerToProducer;
        }

        public List<AutoValueDescriptor> getConsumers() {
            return this.myConsumers;
        }

        public List<? extends ColumnDescriptor> getProducers() {
            return this.myProducers;
        }

        public List<? extends ColumnDescriptor> getVisibleProducers() {
            return this.myVisibleProducers;
        }

        public DeTable getTable() {
            return this.myTable;
        }

        public String getProducerName() {
            return this.myProducerName;
        }

        public List<DataConsumer.Row> getRows() {
            return this.myRows;
        }
    }

    public static class ConversionException
    extends Exception {
        private static final String ERROR_MASK = "conversion failed: \"%s\" to %s";
        private final int myIndex;

        private ConversionException(@NotNull Object value, @NotNull String typeName, int index) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dbimport/ImportInfo$ConversionException", "<init>"));
            }
            if (typeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/dbimport/ImportInfo$ConversionException", "<init>"));
            }
            super(String.format(ERROR_MASK, value, StringUtil.toLowerCase((String)typeName)));
            this.myIndex = index;
        }

        public int getIndex() {
            return this.myIndex;
        }
    }

    public class Cache {
        private final Map<ColumnDescriptor, Integer> myCachedMapping = ContainerUtil.newHashMap();
        private final Map<ColumnDescriptor, Function<Object, Object>> myConverters = ContainerUtil.newHashMap();
        private final ObjectToTextConverter myToTextConverter;

        Cache() {
            this.myToTextConverter = new ObjectToTextConverter(ImportInfo.this.myInputType.getDialect());
        }

        @NotNull
        public Object[] convertLine(@NotNull Object[] objects) throws ConversionException {
            if (objects == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/dbimport/ImportInfo$Cache", "convertLine"));
            }
            Collection consumers = ImportInfo.this.mappedConsumers();
            Object[] convertedLine = new Object[objects.length];
            for (AutoValueDescriptor consumer : consumers) {
                Object converted;
                int index = this.getProducerIndex(consumer);
                Object o = index == -1 ? null : ObjectFormatter.unwrap(objects[index]);
                ColumnDescriptor producer = (ColumnDescriptor)ImportInfo.this.myProducers.get(index);
                Function<Object, Object> converter = this.getConverter(o, consumer, producer);
                Object object = converted = converter == null ? null : converter.fun(o);
                if (!ImportInfo.this.myInsertAsNull && o != null && converted == null) {
                    Object text = this.myToTextConverter.convert(o, producer);
                    throw new ConversionException(text == null ? o : text, consumer.getTypeName(), index);
                }
                convertedLine[index] = DbImplUtil.prepareValue(converted);
            }
            if (convertedLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Cache", "convertLine"));
            }
            return convertedLine;
        }

        @Nullable
        private Function<Object, Object> getConverter(@Nullable Object o, @NotNull ColumnDescriptor consumer, @NotNull ColumnDescriptor producer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportInfo$Cache", "getConverter"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dbimport/ImportInfo$Cache", "getConverter"));
            }
            if (this.myConverters.containsKey(consumer)) {
                return this.myConverters.get(consumer);
            }
            Function<Object, Object> converter = this.getNoCached(o, consumer, producer);
            this.myConverters.put(consumer, converter);
            return converter;
        }

        @NotNull
        public List<ColumnInfo> getColumnInfos() {
            Collection descriptors = ImportInfo.this.mappedConsumers();
            ArrayList infos = ContainerUtil.newArrayList();
            for (AutoValueDescriptor descriptor : descriptors) {
                int index = this.getProducerIndex(descriptor);
                infos.add(new ColumnInfo(descriptor.getJavaClassName(), descriptor.getTypeName(), descriptor.getType(), index));
            }
            ArrayList arrayList = infos;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$Cache", "getColumnInfos"));
            }
            return arrayList;
        }

        @Nullable
        private Function<Object, Object> getNoCached(@Nullable Object o, @NotNull ColumnDescriptor consumer, @NotNull ColumnDescriptor producer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportInfo$Cache", "getNoCached"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dbimport/ImportInfo$Cache", "getNoCached"));
            }
            DbDataSource source = ImportInfo.this.myContext.getDataSource();
            return DataTypeConversion.getConverter(ImportInfo.this.myInputType.getDialect(), ImportInfo.this.myContext.getDialect(), ImportInfo.this.myInputType.getProducerSystem(), (DatabaseSystem)source, producer, consumer, o);
        }

        private int getProducerIndex(@NotNull AutoValueDescriptor consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportInfo$Cache", "getProducerIndex"));
            }
            if (this.myCachedMapping.containsKey(consumer)) {
                return this.myCachedMapping.get(consumer);
            }
            ColumnDescriptor producer = (ColumnDescriptor)ImportInfo.this.myConsumerToProducer.get(consumer);
            int result = producer == null ? -1 : ContainerUtil.indexOf((List)ImportInfo.this.myProducers, current -> StringUtil.equals((CharSequence)producer.getName(), (CharSequence)current.getName()));
            this.myCachedMapping.put(consumer, result);
            return result;
        }
    }
}

