/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReaderTask
implements Runnable {
    private static final String IO_ERROR = "Import failed. Can't access file.";
    private final LinkedTransferQueue<Result> myTransferQueue;
    private final Input myInput;
    private final AtomicReference<String> myError;
    private volatile boolean myStopped;

    ReaderTask(@NotNull Input input, @NotNull LinkedTransferQueue<Result> transferQueue) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (transferQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferQueue", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        this.myTransferQueue = transferQueue;
        this.myInput = input;
        this.myError = new AtomicReference();
    }

    void stop() {
        this.myStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (Input input = this.myInput;){
            Result records;
            while ((records = input.read()) != null) {
                this.send(records);
            }
        }
        catch (InterruptedException e) {
            this.onStop();
        }
        catch (IOException e) {
            this.onError(IO_ERROR);
        }
        catch (Exception e) {
            this.onError(e.getMessage());
        }
        finally {
            this.poisonQueue();
        }
    }

    private void poisonQueue() {
        if (this.myStopped) {
            return;
        }
        this.send(Result.POISON);
        this.myStopped = true;
    }

    private void send(@NotNull Result parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/ReaderTask", "send"));
        }
        try {
            this.myTransferQueue.transfer(parameters);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.onStop();
        }
    }

    private void onStop() {
        if (this.myStopped) {
            return;
        }
        this.myTransferQueue.clear();
        this.myTransferQueue.offer(Result.POISON);
        this.myStopped = true;
    }

    private void onError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/ReaderTask", "onError"));
        }
        this.myError.set(message);
    }

    @Nullable
    public String getError() {
        return this.myError.get();
    }

    public static class ImporterImpl
    implements Importer {
        private final BatchRecords myRecords;
        private final List<ErrorRecord> myErrorRecords;

        public ImporterImpl(@NotNull BatchRecords records, @NotNull List<ErrorRecord> errorRecords) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "<init>"));
            }
            if (errorRecords == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorRecords", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "<init>"));
            }
            this.myRecords = records;
            this.myErrorRecords = errorRecords;
        }

        @Override
        public void insert(@NotNull ImportManager manager, @NotNull ImportInfo info, @NotNull RemoteBatchPreparedStatement statement, @NotNull ImportDatabaseModifier.IndicatorUpdater updater, @NotNull ImportErrorHandler handler) throws RemoteException, SQLException {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "insert"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "insert"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "insert"));
            }
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "insert"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ReaderTask$ImporterImpl", "insert"));
            }
            int lastCount = this.myRecords.getLinesCount() % manager.getLinesPerStatement();
            String lastSql = manager.getInsertStatement(info, Math.max(lastCount, 1));
            ArrayList errorRecords = ContainerUtil.newArrayList(this.myErrorRecords);
            if (!this.myRecords.isEmpty()) {
                errorRecords.addAll(statement.addBatch(this.myRecords, lastSql));
            }
            handler.handle(errorRecords);
            updater.update(this.myRecords, this.myRecords.getLinesCount() + this.myErrorRecords.size());
        }
    }

    public static class ResultImpl
    implements Result {
        private final BatchRecords myRecords;
        private final List<ErrorRecord> myErrors;

        public ResultImpl(@NotNull BatchRecords records) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/ReaderTask$ResultImpl", "<init>"));
            }
            this(records, ContainerUtil.newArrayList());
        }

        public ResultImpl(@NotNull BatchRecords records, @NotNull List<ErrorRecord> errors) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/ReaderTask$ResultImpl", "<init>"));
            }
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/database/dbimport/ReaderTask$ResultImpl", "<init>"));
            }
            this.myRecords = records;
            this.myErrors = errors;
        }

        @Override
        @NotNull
        public Importer prepare(@NotNull ImportInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ReaderTask$ResultImpl", "prepare"));
            }
            ImportInfo.Cache cache = info.cache();
            List records = this.myRecords.getRecords();
            BatchRecords.Builder builder = this.myRecords.builder();
            for (int i2 = 0; i2 < records.size(); ++i2) {
                Object[] line = (Object[])records.get(i2);
                try {
                    builder.record(cache.convertLine(line), i2);
                    continue;
                }
                catch (ImportInfo.ConversionException e) {
                    this.myErrors.add(this.myRecords.getErrorRecord((Exception)e, i2));
                }
            }
            ImporterImpl importerImpl = new ImporterImpl(builder.size(this.myRecords.getBatchSize()).build(), this.myErrors);
            if (importerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ReaderTask$ResultImpl", "prepare"));
            }
            return importerImpl;
        }
    }

    public static interface Importer {
        public static final Importer INACTIVE = new Importer(){

            @Override
            public void insert(@NotNull ImportManager manager, @NotNull ImportInfo info, @NotNull RemoteBatchPreparedStatement statement, @NotNull ImportDatabaseModifier.IndicatorUpdater updater, @NotNull ImportErrorHandler handler) throws RemoteException, SQLException {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/ReaderTask$Importer$1", "insert"));
                }
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ReaderTask$Importer$1", "insert"));
                }
                if (statement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/ReaderTask$Importer$1", "insert"));
                }
                if (updater == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ReaderTask$Importer$1", "insert"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ReaderTask$Importer$1", "insert"));
                }
            }
        };

        public void insert(@NotNull ImportManager var1, @NotNull ImportInfo var2, @NotNull RemoteBatchPreparedStatement var3, @NotNull ImportDatabaseModifier.IndicatorUpdater var4, @NotNull ImportErrorHandler var5) throws RemoteException, SQLException;
    }

    public static interface Result {
        public static final Result POISON = new Result(){

            @Override
            @NotNull
            public Importer prepare(@NotNull ImportInfo info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ReaderTask$Result$1", "prepare"));
                }
                Importer importer = Importer.INACTIVE;
                if (importer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ReaderTask$Result$1", "prepare"));
                }
                return importer;
            }
        };

        @NotNull
        public Importer prepare(@NotNull ImportInfo var1);
    }

    public static interface Input
    extends AutoCloseable {
        @Nullable
        public Result read() throws Exception;

        public void calculateSize(@NotNull Consumer<Double> var1);

        @NotNull
        public ImportDatabaseModifier.IndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator var1, @NotNull DoubleAdder var2, @NotNull ImportInfo var3);
    }
}

