/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.csv.CharsetComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportPanel
extends JBLoadingPanel {
    private static final int INSET = 3;
    private final TabbedPaneWrapper myPane;
    private final List<ImportComponent<?, ?>> myComponents;
    private final ImportInfo.Builder myBuilder;
    private final ImportAction.ImportEditorContext myContext;
    private final GraphObservable<?> myObservable;
    private final ErrorNotificationWrapperPanel myErrorNotificationPanel;

    public ImportPanel(@NotNull List<ImportComponent<?, ?>> components, @NotNull ImportAction.ImportEditorContext context) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/dbimport/ui/ImportPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/ImportPanel", "<init>"));
        }
        super((LayoutManager)new BorderLayout(), context.getDisposable());
        this.myComponents = components;
        this.myBuilder = context.getBuilder();
        this.myContext = context;
        this.myErrorNotificationPanel = new ErrorNotificationWrapperPanel();
        this.myObservable = this.createObservable(components);
        this.myObservable.addListener((Consumer<Throwable>)((Consumer)t -> {
            this.reportError((Throwable)t);
            this.revalidate();
            this.repaint();
        }));
        this.startLoading();
        this.myPane = new TabbedPaneWrapper(context.getDisposable());
    }

    @NotNull
    public CompletionStage<?> init() {
        CompletionStage<Object> completionStage = this.myObservable.init().whenComplete((o, e) -> {
            this.reportError(AsyncUtil.unwrap(e));
            this.fillPanel();
            this.stopLoading();
            this.requestFocusOnEditor();
        });
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "init"));
        }
        return completionStage;
    }

    public void reportError(@Nullable String s) {
        if (s != null) {
            this.myErrorNotificationPanel.reportError(s);
        }
    }

    private void reportError(@Nullable Throwable t) {
        Optional.ofNullable(t).ifPresent(t1 -> {
            ErrorHandler handler = new ErrorHandler();
            handler.addError(null, (Throwable)t1);
            this.reportError(handler.getSummary());
        });
    }

    private void requestFocusOnEditor() {
        IdeFocusManager instance = IdeFocusManager.getInstance((Project)this.myContext.getProject());
        instance.doWhenFocusSettlesDown(() -> {
            ImportDatabaseTableEditor<?> editor = this.getTableEditorComponent().getEditor();
            if (editor != null) {
                instance.requestFocus((Component)editor.getPreferredFocusedComponent(), true);
            }
        });
    }

    @NotNull
    public ImportInfo getImportInfo() {
        for (ImportComponent<?, ?> component : this.myComponents) {
            component.build(this.myBuilder);
        }
        ImportInfo importInfo = this.myBuilder.build();
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "getImportInfo"));
        }
        return importInfo;
    }

    @Nullable
    public ValidationInfo validationInfo() {
        for (ImportComponent<?, ?> component : this.myComponents) {
            ValidationInfo info = component.validate();
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private void fillPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.fillTabbedPane();
        JComponent paneComponent = this.myPane.getComponent();
        paneComponent.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)0, (int)0, (int)0));
        JComponent editorComponent = this.getTableEditorComponent().getComponent();
        editorComponent.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)3, (int)0));
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setFirstComponent(editorComponent);
        splitter.setSecondComponent(paneComponent);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)splitter, "Center");
        right.add((Component)this.createSettingsPanel(), "South");
        mainPanel.add((Component)right, "Center");
        CsvFormatComponent component = this.getFormatComponent();
        if (component != null) {
            mainPanel.add((Component)component.getComponent(), "West");
        }
        this.add(mainPanel, "Center");
        this.add(this.myErrorNotificationPanel, "South");
    }

    private void fillTabbedPane() {
        int i2 = 0;
        DataPreviewComponent<?> previewComponent = this.getPreviewComponent();
        if (previewComponent != null) {
            this.myPane.insertTab("Data Preview", null, previewComponent.getComponent(), null, i2++);
        }
        this.myPane.insertTab("DDL Preview", null, this.getDdlComponent().getComponent(), null, i2);
    }

    @NotNull
    public DdlPreviewComponent getDdlComponent() {
        DdlPreviewComponent ddlPreviewComponent = (DdlPreviewComponent)ObjectUtils.assertNotNull((Object)this.getComponent(DdlPreviewComponent.class));
        if (ddlPreviewComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "getDdlComponent"));
        }
        return ddlPreviewComponent;
    }

    @NotNull
    public TableEditorComponent<?> getTableEditorComponent() {
        TableEditorComponent tableEditorComponent = (TableEditorComponent)ObjectUtils.assertNotNull((Object)this.getComponent(TableEditorComponent.class));
        if (tableEditorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "getTableEditorComponent"));
        }
        return tableEditorComponent;
    }

    @NotNull
    protected ImportSettingsComponent getSettingsComponent() {
        ImportSettingsComponent importSettingsComponent = (ImportSettingsComponent)ObjectUtils.assertNotNull((Object)this.getComponent(ImportSettingsComponent.class));
        if (importSettingsComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "getSettingsComponent"));
        }
        return importSettingsComponent;
    }

    @Nullable
    protected DataPreviewComponent<?> getPreviewComponent() {
        return this.getComponent(DataPreviewComponent.class);
    }

    @Nullable
    protected CsvFormatComponent getFormatComponent() {
        return this.getComponent(CsvFormatComponent.class);
    }

    @Nullable
    protected CharsetComponent getCharsetComponent() {
        return this.getComponent(CharsetComponent.class);
    }

    @NotNull
    private JComponent createSettingsPanel() {
        JPanel result = new JPanel((LayoutManager)new VerticalStackLayout());
        ImportSettingsComponent settingsComponent = this.getSettingsComponent();
        CharsetComponent charsetComponent = this.getCharsetComponent();
        if (charsetComponent == null) {
            JComponent jComponent = settingsComponent.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "createSettingsPanel"));
            }
            return jComponent;
        }
        ImportSettingsComponent.addStrut(result);
        result.add(charsetComponent.getComponent());
        ImportSettingsComponent.addStrut(result);
        ImportSettingsComponent.addStrut(result);
        result.add(settingsComponent.getComponent());
        JPanel jPanel = result;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "createSettingsPanel"));
        }
        return jPanel;
    }

    @NotNull
    private GraphObservable createObservable(@NotNull List<ImportComponent<?, ?>> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/dbimport/ui/ImportPanel", "createObservable"));
        }
        CsvFormatComponent root2 = this.getFormatComponent() != null ? this.getFormatComponent() : (this.getPreviewComponent() != null ? this.getPreviewComponent() : this.getTableEditorComponent());
        GraphObservable<Object> graphObservable = new GraphObservable.Builder().add(components).root((GraphObservable.GraphObserver)ObjectUtils.assertNotNull((Object)root2)).initializer(null).build();
        if (graphObservable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportPanel", "createObservable"));
        }
        return graphObservable;
    }

    @Nullable
    private <T extends ImportComponent<?, ?>> T getComponent(Class<T> filterBy) {
        return (T)((ImportComponent)JBIterable.from(this.myComponents).filter(filterBy).first());
    }
}

