/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettingsComponent
implements ImportComponent<Object, Object> {
    protected static final int GAP = JBUI.scale((int)5);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss");
    private static final String HANDLE_ERROR_TEXT = "Write errors to file: ";
    private static final String INSERT_AS_NULL = "Insert inconvertible values as null";
    private static final String DISABLE_STATE_TEXT = String.format("Disable %s and triggers, lock table (may be faster)", StringUtil.pluralize((String)"index"));
    protected final ImportAction.ImportEditorContext myContext;
    protected final JCheckBox myHandleErrorCheckBox;
    protected final TextFieldWithBrowseButton myErrorOutput;
    private final JCheckBox myModalityStateCheckBox;
    private final JCheckBox myInsertAsNullCheckBox;
    private final String myTableName;
    private final JPanel myPanel;

    public ImportSettingsComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "<init>"));
        }
        this.myContext = context;
        this.myPanel = new JPanel((LayoutManager)new VerticalStackLayout());
        this.myHandleErrorCheckBox = new JBCheckBox(HANDLE_ERROR_TEXT);
        this.myModalityStateCheckBox = new JBCheckBox(DISABLE_STATE_TEXT);
        this.myInsertAsNullCheckBox = new JBCheckBox(INSERT_AS_NULL);
        this.myErrorOutput = new TextFieldWithBrowseButton();
        this.myTableName = this.myContext.getTableName();
        this.myModalityStateCheckBox.setVisible(this.myContext.getBuilder().getImportType().isTableCreated() && this.myContext.getManager().isSupportFastMode());
        this.configureComponents();
        this.addComponents();
    }

    @Nullable
    public String getErrorOutputFilePath() {
        return this.myErrorOutput.isEnabled() ? ImportSettingsComponent.sanitize(this.myErrorOutput.getText()) : null;
    }

    protected void addComponents() {
        ImportSettingsComponent.addStrut(this.myPanel);
        JPanel errorOutputPanel = this.createErrorOutputSettingsPanel();
        this.myPanel.add(errorOutputPanel);
        ImportSettingsComponent.addStrut(this.myPanel);
        this.myPanel.add(this.myInsertAsNullCheckBox);
        ImportSettingsComponent.addStrut(this.myPanel);
        this.myPanel.add(this.myModalityStateCheckBox);
    }

    @NotNull
    protected JPanel createErrorOutputSettingsPanel() {
        JPanel errorOutputPanel = new JPanel(new BorderLayout());
        errorOutputPanel.add((Component)this.myHandleErrorCheckBox, "West");
        errorOutputPanel.add((Component)this.myErrorOutput, "Center");
        JPanel jPanel = errorOutputPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "createErrorOutputSettingsPanel"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "build"));
        }
        String path = this.getErrorOutputFilePath();
        builder.errorTaskInfo(new HandleErrorTask.ErrorTaskInfo((ThrowableComputable<Writer, IOException>)((ThrowableComputable)() -> path == null ? null : new FileWriter(path)), path)).insertAsNull(this.myInsertAsNullCheckBox.isSelected()).lockTable(this.myModalityStateCheckBox.isSelected());
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "isVisible"));
        }
        return true;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "addListener"));
        }
    }

    @Override
    @NotNull
    public CompletionStage<Object> notifyChanged(@Nullable Object object) {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "dependsOn"));
        }
        return false;
    }

    public static void addStrut(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "addStrut"));
        }
        panel.add(Box.createVerticalStrut(GAP));
    }

    protected void configureComponents() {
        boolean errors = ImportSettings.getWriteErrors();
        String directory = ImportSettings.getErrorDirectory();
        this.myErrorOutput.setEnabled(errors);
        this.myErrorOutput.setText(this.getDefaultText((String)ObjectUtils.chooseNotNull((Object)directory, (Object)SystemProperties.getUserHome())));
        this.myErrorOutput.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(true, true, false, false, false, false)){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/database/dbimport/ui/ImportSettingsComponent$1", "onFileChosen"));
                }
                if (chosenFile.isDirectory()) {
                    ImportSettingsComponent.this.myErrorOutput.setText(ImportSettingsComponent.this.getDefaultText(chosenFile.getPath()));
                    return;
                }
                ImportSettingsComponent.this.myErrorOutput.setText(chosenFile.getPath());
            }
        });
        this.myHandleErrorCheckBox.setSelected(errors);
        this.myModalityStateCheckBox.setSelected(this.myModalityStateCheckBox.isVisible() && ImportSettings.getImportModality());
        this.myInsertAsNullCheckBox.setSelected(ImportSettings.getInsertAsNull());
        this.myHandleErrorCheckBox.addItemListener(e -> this.myErrorOutput.setEnabled(this.myHandleErrorCheckBox.isSelected()));
    }

    @NotNull
    private String getDefaultText(@NotNull String directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "getDefaultText"));
        }
        String string = directory + File.separator + this.myTableName + "_" + DATE_FORMAT.format(LocalDateTime.now()) + ".txt";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsComponent", "getDefaultText"));
        }
        return string;
    }

    @Nullable
    private static String sanitize(@Nullable String path) {
        if (path == null) {
            return null;
        }
        String parent = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        String extension = FileUtilRt.getExtension((String)fileName);
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)fileName);
        return parent + File.separator + FileUtil.sanitizeFileName((String)nameWithoutExtension) + (StringUtil.isEmpty((String)extension) ? "" : "." + FileUtil.sanitizeFileName((String)extension));
    }
}

