/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.scripting.SqlWords;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class KeywordHelper {
    private Set<String> myReservedKeywords = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);

    public boolean isReservedKeyword(String text) {
        return this.myReservedKeywords.contains(text);
    }

    protected void addKeywords(String ... text) {
        this.myReservedKeywords.addAll(Arrays.asList(text));
    }

    protected void addKeywords(@NotNull Collection<String> words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/database/dialects/KeywordHelper", "addKeywords"));
        }
        this.myReservedKeywords.addAll(words);
    }

    public static class MssqlKeywords
    extends KeywordHelper {
        public MssqlKeywords() {
            this.addKeywords("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITYCOL", "IDENTITY_INSERT", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "MERGE", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PIVOT", "PLAN", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVERT", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SECURITYAUDIT", "SELECT", "SESSION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UNPIVOT", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT");
        }
    }

    public static class SybaseKeywords
    extends KeywordHelper {
        public SybaseKeywords() {
            this.addKeywords("ADD", "ALL", "ALTER", "AND", "ANY", "ARITH_OVERFLOW", "AS", "ASC", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHAR_CONVERT", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COMMIT", "COMPUTE", "CONFIRM", "CONNECT", "CONSTRAINT", "CONTINUE", "CONTROLROW", "CONVERT", "COUNT", "COUNT_BIG", "CREATE", "CURRENT", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DECRYPT", "DEFAULT", "DELETE", "DESC", "DETERMINISTIC", "DISK", "DISTINCT", "DROP", "DUMMY", "DUMP", "ELSE", "ENCRYPT", "END", "ENDTRAN", "ERRLVL", "ERRORDATA", "ERROREXIT", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXP_ROW_SIZE", "EXTERNAL", "FETCH", "FILLFACTOR", "FOR", "FOREIGN", "FROM", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_GAP", "IDENTITY_START", "IF", "IN", "INDEX", "INOUT", "INSENSITIVE", "INSERT", "INSTALL", "INTERSECT", "INTO", "IS", "ISOLATION", "JAR", "JOIN", "KEY", "KILL", "LEVEL", "LIKE", "LINENO", "LOAD", "LOCK", "MATERIALIZED", "MAX", "MAX_ROWS_PER_PAGE", "MIN", "MIRROR", "MIRROREXIT", "MODIFY", "NATIONAL", "NEW", "NOHOLDLOCK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "NUMERIC_TRUNCATION", "OF", "OFF", "OFFSETS", "ON", "ONCE", "ONLINE", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OVER", "PARTITION", "PERM", "PERMANENT", "PLAN", "PREPARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PROCESSEXIT", "PROXY_TABLE", "PUBLIC", "QUIESCE", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES", "REMOVE", "REORG", "REPLACE", "REPLICATION", "RESERVEPAGEGAP", "RETURN", "RETURNS", "REVOKE", "ROLE", "ROLLBACK", "ROWCOUNT", "ROWS", "RULE", "SAVE", "SCHEMA", "SCROLL", "SELECT", "SEMI_SENSITIVE", "SET", "SETUSER", "SHARED", "SHUTDOWN", "SOME", "STATISTICS", "STRINGSIZE", "STRIPE", "SUM", "SYB_IDENTITY", "SYB_RESTREE", "SYB_TERMINATE", "TABLE", "TEMP", "TEMPORARY", "TEXTSIZE", "TO", "TRACEFILE", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UNPARTITION", "UPDATE", "USE", "USER", "USER_OPTION", "USING", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WORK", "WRITETEXT", "XMLEXTRACT", "XMLPARSE", "XMLTEST");
        }
    }

    public static class SqliteKeywords
    extends KeywordHelper {
        public SqliteKeywords() {
            this.addKeywords("ADD", "ALL", "ALTER", "AND", "AS", "AUTOINCREMENT", "BETWEEN", "BY", "CASE", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONSTRAINT", "CREATE", "CROSS", "DEFAULT", "DEFERRABLE", "DELETE", "DISTINCT", "DROP", "ELSE", "ESCAPE", "EXCEPT", "EXISTS", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEFT", "LIMIT", "NATURAL", "NOT", "NOTNULL", "NULL", "ON", "OR", "ORDER", "OUTER", "PRIMARY", "REFERENCES", "REGEXP", "RELEASE", "RIGHT", "ROLLBACK", "SAVEPOINT", "SELECT", "SET", "TABLE", "THEN", "TO", "TRANSACTION", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHERE");
        }
    }

    public static class PostgresKeywords
    extends KeywordHelper {
        public PostgresKeywords() {
            this.addKeywords(SqlWords.POSTGRES_KEY_WORDS);
        }
    }

    public static class OracleKeywords
    extends KeywordHelper {
        public OracleKeywords() {
            this.addKeywords(SqlWords.ORACLE_KEY_WORDS);
        }
    }

    public static class MysqlKeywords
    extends KeywordHelper {
        public MysqlKeywords() {
            this.addKeywords(SqlWords.MYSQL_KEY_WORDS);
        }
    }

    public static class HsqldbKeywords
    extends KeywordHelper {
        public HsqldbKeywords() {
            this.addKeywords("ADMIN", "ALL", "AND", "ANY", "AS", "AT", "AVG", "BETWEEN", "BOTH", "BY", "CALL", "CASE", "CAST", "COALESCE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "DISTINCT", "DROP", "ELSE", "END", "EVERY", "EXCEPT", "EXISTS", "FOR", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "MAX", "MIN", "NATURAL", "NOT", "NULLIF", "ON", "OR", "ORDER", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "SELECT", "SET", "SOME", "STDDEV_POP", "STDDEV_SAMP", "SUM", "TABLE", "THEN", "TO", "TRAILING", "TRIGGER", "UNION", "UNIQUE", "USING", "VALUES", "VAR_POP", "VAR_SAMP", "WHEN", "WHERE", "WITH");
        }
    }

    public static class H2Keywords
    extends KeywordHelper {
        public H2Keywords() {
            this.addKeywords(SqlWords.H2_KEY_WORDS);
        }
    }

    public static class GenericKeywords
    extends KeywordHelper {
        public GenericKeywords() {
            this.addKeywords("ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE");
        }
    }

    public static class DerbyKeywords
    extends KeywordHelper {
        public DerbyKeywords() {
            this.addKeywords("ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "ENDEXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "LIKE", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "NVARCHAR", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "ROW_NUMBER", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "YEAR");
        }
    }

    public static class Db2Keywords
    extends KeywordHelper {
        public Db2Keywords() {
            this.addKeywords(new String[0]);
        }
    }
}

