/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataExtractorProperties {
    private static final String CURRENT = "database.data.extractors.current";
    private static final String HONOR_TRANSPOSED = "database.data.extractors.honor.transposed";
    private static final String SKIP_GENERATED = "database.data.extractors.sql.skip.generated";
    private static final String CREATE_TABLE = "database.data.extractors.sql.create.table";
    private static final String OVERWRITE_EXISTING_FILES = "database.data.extractors.overwrite.existing.files";

    private DataExtractorProperties() {
    }

    @NotNull
    public static DataExtractorFactory getCurrentExtractorFactory(@Nullable Project project) {
        PropertiesComponent storage = project == null ? null : PropertiesComponent.getInstance((Project)project);
        String factoryName = storage != null ? storage.getValue(CURRENT) : null;
        DataExtractorFactory factory = factoryName != null ? DataExtractorFactories.find(factoryName) : null;
        DataExtractorFactory dataExtractorFactory = factory != null ? factory : DataExtractorFactories.getDefault();
        if (dataExtractorFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorProperties", "getCurrentExtractorFactory"));
        }
        return dataExtractorFactory;
    }

    public static void setCurrentExtractorFactory(@NotNull Project project, @NotNull DataExtractorFactory f) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/extractors/DataExtractorProperties", "setCurrentExtractorFactory"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/database/extractors/DataExtractorProperties", "setCurrentExtractorFactory"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(CURRENT, f.getName());
    }

    public static boolean isTranspositionAllowed() {
        return DataExtractorProperties.getAppProperty(HONOR_TRANSPOSED);
    }

    public static boolean isSkipGeneratedColumns() {
        return DataExtractorProperties.getAppProperty(SKIP_GENERATED);
    }

    public static boolean isIncludeCreateTable() {
        return DataExtractorProperties.getAppProperty(CREATE_TABLE);
    }

    public static boolean isOverwriteExistingFiles() {
        return DataExtractorProperties.getAppProperty(OVERWRITE_EXISTING_FILES);
    }

    public static AnAction getTranspositionAllowedAction() {
        return new BooleanPropertyAction("Allow Transposition", HONOR_TRANSPOSED);
    }

    public static AnAction getSkipGeneratedColumnsAction() {
        return new BooleanPropertyAction("Skip Generated Columns (SQL)", SKIP_GENERATED);
    }

    public static AnAction getAddCreateTableAction() {
        return new BooleanPropertyAction("Add Table Definition (SQL)", CREATE_TABLE);
    }

    public static AnAction getOverwriteExistingFilesAction() {
        return new MultipleItemsBooleanPropertyAction("Overwrite Existing Files", OVERWRITE_EXISTING_FILES);
    }

    private static boolean getAppProperty(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/database/extractors/DataExtractorProperties", "getAppProperty"));
        }
        boolean defaultValue = !CREATE_TABLE.equals(property);
        return PropertiesComponent.getInstance().getBoolean(property, defaultValue);
    }

    private static void setAppProperty(@NotNull String property, boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/database/extractors/DataExtractorProperties", "setAppProperty"));
        }
        boolean defaultValue = !CREATE_TABLE.equals(property);
        PropertiesComponent.getInstance().setValue(property, value, defaultValue);
    }

    private static class BooleanPropertyAction
    extends ToggleAction
    implements DumbAware {
        private final String myProperty;

        public BooleanPropertyAction(String displayName, String property) {
            super(displayName);
            this.myProperty = property;
        }

        public boolean isSelected(AnActionEvent e) {
            e.getPresentation().setVisible(this.shouldBeVisible(e));
            return DataExtractorProperties.getAppProperty(this.myProperty);
        }

        boolean shouldBeVisible(AnActionEvent e) {
            DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            Project project = e.getProject();
            return project != null && grid != null;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            DataExtractorProperties.setAppProperty(this.myProperty, state);
        }
    }

    private static class MultipleItemsBooleanPropertyAction
    extends BooleanPropertyAction {
        public MultipleItemsBooleanPropertyAction(String displayName, String property) {
            super(displayName, property);
        }

        @Override
        boolean shouldBeVisible(AnActionEvent e) {
            if (e.getProject() == null) {
                return false;
            }
            Object source = DumpAction.getDumpSource(e);
            return source instanceof JdbcConsole && this.isManyItems(DumpAction.getQueries((JdbcConsole)source, e.getProject())) || source instanceof List && this.isManyItems((List)source);
        }

        boolean isManyItems(@Nullable List list) {
            return list != null && list.size() > 1;
        }
    }
}

