/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.coding.CompositeText;
import com.intellij.coding.SimpleCompositeText;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.OraIntroQueries;
import com.intellij.database.introspection.OraIntrospector;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraModArgument;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModConstraint;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModModule;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSchemaObject;
import com.intellij.database.model.oracle.OraModSourceAware;
import com.intellij.database.model.oracle.OraModSynonym;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTrigger;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TLongHashSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u00ca\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\t\u0010\u001e\u001a\u00020\u0017H\u0086\b\u001a\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002\u001a \u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u0006H\u0002\u001a<\u0010(\u001a\u00020\u00172\u0006\u0010 \u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\u0006H\u0002\u001aB\u00100\u001a\u0002012\u0006\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010\u00062\b\u00104\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00105\u001a\u00020\u00072\b\b\u0002\u00106\u001a\u00020\u00072\b\b\u0002\u00107\u001a\u00020\u0015H\u0002\u001a3\u00108\u001a\u00020\u00172\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060:2\u000e\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0%2\u0006\u0010<\u001a\u00020=H\u0002\u00a2\u0006\u0002\u0010>\u001a\u001e\u0010?\u001a\u00020\u00172\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010C\u001a\u00020DH\u0002\u001a\u0010\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u00020\u0006H\u0003\u001a$\u0010G\u001a\u00020\u0017*\u00020!2\u0006\u0010H\u001a\u00020\u00062\u0006\u0010F\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\u0006H\u0002\u001a\f\u0010J\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\u0016\u0010K\u001a\u0004\u0018\u00010L*\u00020M2\u0006\u0010F\u001a\u00020\u0006H\u0002\u001a\u0016\u0010N\u001a\u0004\u0018\u00010O*\u00020!2\u0006\u0010F\u001a\u00020\u0006H\u0002\u001a\u0016\u0010P\u001a\u0004\u0018\u00010Q*\u00020!2\u0006\u0010F\u001a\u00020\u0006H\u0002\u001a\u0016\u0010R\u001a\u0004\u0018\u00010S*\u00020!2\u0006\u0010T\u001a\u00020\u0006H\u0002\u001a\u0015\u0010U\u001a\u00020=*\u00020\u00152\u0006\u0010V\u001a\u00020=H\u0082\b\u001a \u0010W\u001a\u00020\u0017*\u00020&2\b\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010Z\u001a\u0004\u0018\u00010YH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\n\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000e\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0011j\b\u0012\u0004\u0012\u00020\u0006`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CLUSTER_DECOMPILED_COLUMN_PATTERN", "DataTypeStarSize", "", "", "", "ExplicitUnitDataTypes", "", "INDEX_EXPRESSION_STUB_PATTERN", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SIMPLE_QUOTED_NAME_PATTERN", "SURROGATE_NAME_PATTERN", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "Lkotlin/collections/TreeSet;", "SimpleDataTypes", "delim", "", "applyStoredProgramSources", "", "obj", "Lcom/intellij/database/model/oracle/OraModSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/oracle/OraModView;", "doNoting", "dropUnexistentObjectsInSchema", "schema", "Lcom/intellij/database/model/oracle/OraModSchema;", "identifiers", "Lgnu/trove/TLongHashSet;", "majorFamilyOf", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/model/oracle/OraModSchemaObject;", "code", "makeArgument", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/model/oracle/OraModRoutine;", "argName", "argDirection", "dataTypeSchemaName", "dataTypeSpec", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typeName", "precision", "scale", "unitsCode", "processNames", "items", "", "modelSchemas", "renew", "", "([Ljava/lang/String;Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;Z)V", "processSynonyms", "ss", "", "Lcom/intellij/database/introspection/OraIntroQueries$OneSynonym;", "root", "Lcom/intellij/database/model/oracle/OraModRoot;", "unquoteNameIfPossible", "name", "applySources", "type", "sourceText", "c2s", "findModConstraint", "Lcom/intellij/database/model/oracle/OraModConstraint;", "Lcom/intellij/database/model/oracle/OraTable;", "findModuleByName", "Lcom/intellij/database/model/oracle/OraModModule;", "findTableOrViewByName", "Lcom/intellij/database/model/oracle/OraModLikeTable;", "findTrigger", "Lcom/intellij/database/model/oracle/OraModTrigger;", "triggerName", "isSameForCatalogAndScript", "atBegin", "setCreatedAndModifiedTimestamps", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "database-introspection"})
@JvmName(name="OraIntrospectorFunctions")
public final class OraIntrospectorFunctions {
    private static final TreeSet<String> SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[]{"SYS", "SYSTEM", "CTXSYS"});
    private static final Logger LOG = Logger.getInstance(OraIntrospector.class);
    private static final Set<String> SimpleDataTypes = SetsKt.setOf((Object[])new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"});
    private static final Set<String> ExplicitUnitDataTypes = SetsKt.setOf((Object[])new String[]{"CHAR", "VARCHAR", "VARCHAR2"});
    private static final Map<String, Integer> DataTypeStarSize = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)38), TuplesKt.to((Object)"FLOAT", (Object)126)});
    private static final Pattern SIMPLE_QUOTED_NAME_PATTERN = Pattern.compile("^\\s*\"([^\"]*)\"\\s*$");
    private static final Pattern AUTO_NOT_NULL_CHECK_PATTERN = Pattern.compile("\".+\" IS NOT NULL");
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^SYS_\\w*\\d+\\$*$");
    private static final Pattern CLUSTER_DECOMPILED_COLUMN_PATTERN = Pattern.compile("^\"(([^\"]*?|\"\")+)\"\\s+(.*?)(\\s+SORT)?(\\s*[,)])$");
    private static final Pattern INDEX_EXPRESSION_STUB_PATTERN = Pattern.compile("^SYS_NC\\d+.$");
    public static final char delim = '\uffff';

    /*
     * WARNING - void declaration
     */
    private static final void processNames(String[] items, ModNamingIdentifyingFamily<? extends OraModSchema> modelSchemas, boolean renew) {
        int n = 0;
        int n2 = ((Object[])items).length - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                String item = items[i2];
                try {
                    String objectName;
                    String kindCode;
                    OraModSchema schema;
                    String objectIdStr;
                    String schemaIdStr;
                    String string;
                    boolean bl;
                    boolean bl2 = bl = item.length() >= 23;
                    if (_Assertions.ENABLED && !bl) {
                        string = "The item should be at least 23 characters length";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    String $i$a$1$assert = item;
                    int n3 = 0;
                    int n4 = 2;
                    String string2 = $i$a$1$assert;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = item;
                    n4 = 2;
                    int n5 = 12;
                    String string3 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n4, n5), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = item;
                    n5 = 12;
                    int n6 = 22;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n5, n6), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = item;
                    n6 = 22;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n6), (String)"(this as java.lang.String).substring(startIndex)");
                    int schemaId = Integer.parseInt(schemaIdStr);
                    int objectId = Integer.parseInt(objectIdStr);
                    if ((OraModSchema)modelSchemas.getByObjectId((long)schemaId) == null) {
                        String string8 = "Schema should exist, id:" + schemaId;
                        throw (Throwable)new IllegalStateException(string8.toString());
                    }
                    ModNamingIdentifyingFamily<? extends OraModSchemaObject> family = OraIntrospectorFunctions.majorFamilyOf(schema, kindCode);
                    if (renew) {
                        family.renew(objectId, objectName);
                    } else {
                        OraModSchemaObject majorObject = (OraModSchemaObject)family.createOrGet(objectName);
                        majorObject.setObjectId(objectId);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn(String.format("Failed to handle item '%s': %s: %s", item, e.getClass().getSimpleName(), e.getMessage()));
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
    }

    private static final ModNamingIdentifyingFamily<? extends OraModSchemaObject> majorFamilyOf(OraModSchema schema, String code) {
        switch (code) {
            case "TA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                return namingIdentifyingFamily;
            }
            case "CL": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getClusters();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.clusters");
                return namingIdentifyingFamily;
            }
            case "VI": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                return namingIdentifyingFamily;
            }
            case "SY": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSynonyms();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.synonyms");
                return namingIdentifyingFamily;
            }
            case "SE": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
                return namingIdentifyingFamily;
            }
            case "PR": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "FU": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "PA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getPackages();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.packages");
                return namingIdentifyingFamily;
            }
            case "MA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                return namingIdentifyingFamily;
            }
            case "YB": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getObjectTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.objectTypes");
                return namingIdentifyingFamily;
            }
            case "YC": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getCollectionTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.collectionTypes");
                return namingIdentifyingFamily;
            }
        }
        throw (Throwable)new IllegalArgumentException("Unknown object code: " + code);
    }

    private static final void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraModRoot root2) {
        Set affectedSchemas = new HashSet();
        for (OraIntroQueries.OneSynonym s : ss) {
            OraModSchema schema;
            if ((OraModSchema)root2.getSchemas().get(s.synonym_schema_name) == null) {
                continue;
            }
            OraModSynonym synonym = (OraModSynonym)schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            synonym.setCreatedTimestamp(s.created_timestamp);
            synonym.setModifiedTimestamp(s.modified_timestamp);
            synonym.setTargetSchemaName(s.origin_schema_name);
            synonym.setTargetObjectName(s.origin_object_name);
            affectedSchemas.add(schema);
        }
        for (OraModSchema schema : affectedSchemas) {
            schema.getSynonyms().sort();
        }
    }

    private static final void dropUnexistentObjectsInSchema(OraModSchema schema, TLongHashSet identifiers) {
        NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getClusters();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.clusters");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily2)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getTables();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.tables");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily3)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getMatViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.matViews");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily4)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily5 = schema.getViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.views");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily5)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily6 = schema.getPackages();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.packages");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily6)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily7 = schema.getObjectTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"schema.objectTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily7)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily8 = schema.getCollectionTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"schema.collectionTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily8)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily9 = schema.getRoutines();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"schema.routines");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily9)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily10 = schema.getSynonyms();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily10, (String)"schema.synonyms");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily10)), identifiers);
        for (OraModCluster cluster : schema.getClusters()) {
            SingletonFamily singletonFamily = cluster.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"cluster.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        for (OraModLikeTable table : schema.getTables()) {
            NamingIdentifyingFamily namingIdentifyingFamily11 = table.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily11, (String)"table.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily11)), identifiers);
            NamingIdentifyingFamily namingIdentifyingFamily12 = table.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily12, (String)"table.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily12)), identifiers);
        }
        for (OraModLikeTable table : schema.getMatViews()) {
        }
        for (OraModView view2 : schema.getViews()) {
            NamingIdentifyingFamily namingIdentifyingFamily13 = view2.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily13, (String)"view.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily13)), identifiers);
        }
        for (OraModPackage pack : schema.getPackages()) {
            SingletonFamily singletonFamily = pack.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"pack.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        for (OraModObjectType ot : schema.getObjectTypes()) {
            SingletonFamily singletonFamily = ot.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"ot.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        $receiver.setCreatedTimestamp(createdTimestamp);
        $receiver.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final OraModLikeTable findTableOrViewByName(@NotNull OraModSchema $receiver, String name) {
        OraModLikeTable oraModLikeTable;
        OraModLikeTable oraModLikeTable2 = (OraModLikeTable)$receiver.getTables().get(name);
        if (oraModLikeTable2 == null) {
            oraModLikeTable2 = oraModLikeTable = (OraModLikeTable)$receiver.getMatViews().get(name);
        }
        if (oraModLikeTable2 == null) {
            oraModLikeTable = (OraModLikeTable)$receiver.getViews().get(name);
        }
        return oraModLikeTable;
    }

    private static final OraModModule findModuleByName(@NotNull OraModSchema $receiver, String name) {
        OraModModule oraModModule = (OraModModule)$receiver.getObjectTypes().get(name);
        if (oraModModule == null) {
            oraModModule = (OraModModule)$receiver.getPackages().get(name);
        }
        return oraModModule;
    }

    private static final OraModConstraint findModConstraint(@NotNull OraTable $receiver, String name) {
        OraModConstraint oraModConstraint;
        OraModConstraint oraModConstraint2 = (OraModConstraint)$receiver.getKeys().get(name);
        if (oraModConstraint2 == null) {
            oraModConstraint2 = oraModConstraint = (OraModConstraint)$receiver.getForeignKeys().get(name);
        }
        if (oraModConstraint2 == null) {
            oraModConstraint = (OraModConstraint)$receiver.getChecks().get(name);
        }
        return oraModConstraint;
    }

    private static final OraModTrigger findTrigger(@NotNull OraModSchema $receiver, String triggerName) {
        OraModTrigger trigger2;
        for (OraModTable table : $receiver.getTables()) {
            trigger2 = (OraModTrigger)table.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (OraModLikeTable view2 : $receiver.getViews()) {
            trigger2 = (OraModTrigger)view2.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (OraModLikeTable view2 : $receiver.getMatViews()) {
            trigger2 = (OraModTrigger)view2.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        return null;
    }

    @Contract(pure=true)
    private static final String unquoteNameIfPossible(String name) {
        Matcher m = SIMPLE_QUOTED_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            String string = m.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(1)");
            return string;
        }
        return name;
    }

    private static final void makeArgument(BasicSchema schema, OraModRoutine routine2, String argName, char argDirection, String dataTypeSchemaName, String dataTypeSpec) {
        OraModArgument argument;
        DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == null) {
            dir = DasArgument.Direction.IN;
        }
        if (Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.RETURN)) {
            BasicModArgument basicModArgument = routine2.createOrGetReturnArgument();
            if (basicModArgument == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModArgument");
            }
            argument = (OraModArgument)basicModArgument;
            argument.setRealName(argName);
        } else if (argName != null) {
            Object e = routine2.getArguments().createOrGet(argName);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"routine.arguments.createOrGet(argName)");
            argument = (OraModArgument)e;
            argument.setArgumentDirection(dir);
        } else {
            return;
        }
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema, dataTypeSchemaName, dataTypeSpec, 0, 0, '\u0000', 56, null);
        argument.setDataType(dataType);
    }

    private static final DataType makeDataType(BasicSchema thisSchema, String typeSchemaName, String typeName, int precision, int scale, char unitsCode) {
        DataType type;
        if (typeName == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)typeName, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of(typeName);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(typeName)");
            type = dataType;
        } else {
            DataType dataType;
            int p;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SimpleDataTypes.contains(typeName) && !customType;
            boolean explicitUnits = ExplicitUnitDataTypes.contains(typeName) && unitsCode == 'C' && !customType;
            switch (unitsCode) {
                case 'B': {
                    LengthUnit lengthUnit = LengthUnit.BYTE;
                    break;
                }
                case 'C': {
                    LengthUnit lengthUnit = LengthUnit.CHAR;
                    break;
                }
                case 'D': {
                    LengthUnit lengthUnit = LengthUnit.DIGIT;
                    break;
                }
                default: {
                    LengthUnit lengthUnit = units = null;
                }
            }
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) ? null : typeSchemaName) : null;
            Integer starSize = DataTypeStarSize.get(typeName);
            int n = p = starSize != null && Intrinsics.areEqual((Object)precision, (Object)starSize) ? 0x7FFFFFFE : precision;
            if (customType) {
                DataType dataType2 = DataTypeFactory.of(explicitSchemaName, typeName, -1, 0, null, null, false, true);
                dataType = dataType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataTypeFactory.of(expli\u2026 null, null, false, true)");
            } else {
                DataType dataType3 = simple ? DataTypeFactory.of(null, typeName, -1, -1, units, null, false, false) : DataTypeFactory.of(null, typeName, p, scale, units, null, explicitUnits, false);
                dataType = dataType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"if (simple)\n          Da\u2026ll, explicitUnits, false)");
            }
            type = dataType;
        }
        return type;
    }

    static /* bridge */ /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, int n, int n2, char c, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = -1;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            c = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, n, n2, c);
    }

    private static final void applySources(@NotNull OraModSchema $receiver, String type, String name, String sourceText) {
        OraModSourceAware oraModSourceAware;
        CharSequence charSequence = sourceText;
        if (charSequence.length() == 0) {
            return;
        }
        switch (type) {
            case "TYPE": {
                Object e = $receiver.getObjectTypes().createOrGet(name);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.objectTypes.createOrGet(name)");
                oraModSourceAware = (OraModSourceAware)e;
                break;
            }
            case "TYPE BODY": {
                Object e = ((OraModObjectType)$receiver.getObjectTypes().createOrGet(name)).getBodies().createOrGet();
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.objectTypes.createO\u2026ame).bodies.createOrGet()");
                oraModSourceAware = (OraModSourceAware)e;
                break;
            }
            case "PACKAGE": {
                Object e = $receiver.getPackages().createOrGet(name);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.packages.createOrGet(name)");
                oraModSourceAware = (OraModSourceAware)e;
                break;
            }
            case "PACKAGE BODY": {
                Object e = ((OraModPackage)$receiver.getPackages().createOrGet(name)).getBodies().createOrGet();
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.packages.createOrGe\u2026ame).bodies.createOrGet()");
                oraModSourceAware = (OraModSourceAware)e;
                break;
            }
            case "PROCEDURE": 
            case "FUNCTION": {
                Object e = $receiver.getRoutines().createOrGet(name);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.routines.createOrGet(name)");
                oraModSourceAware = (OraModSourceAware)e;
                break;
            }
            default: {
                return;
            }
        }
        OraModSourceAware sourceAware = oraModSourceAware;
        OraIntrospectorFunctions.applyStoredProgramSources(sourceAware, sourceText);
    }

    private static final void applyStoredProgramSources(OraModSourceAware obj, String text) {
        CharSequence charSequence;
        if (text != null && (charSequence = (CharSequence)text).length() > 0) {
            obj.setSourceText(new SimpleCompositeText("CREATE ", CompositeText.Kind.FIXED_TEXT, text, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            obj.setSourceText(null);
        }
        obj.setObfuscated(false);
    }

    private static final void applyViewSources(OraModView view2, String text) {
        CharSequence charSequence;
        if (text != null && (charSequence = (CharSequence)text).length() > 0) {
            view2.setSourceText(new SimpleCompositeText("CREATE VIEW " + OraIntrospectorFunctions.c2s(view2.getName()) + " AS ", CompositeText.Kind.FIXED_TEXT, text, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            view2.setSourceText(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String c2s(@NotNull String $receiver) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = $receiver.length();
        boolean ok = true;
        for (int p = 0; p < n; ++p) {
            void $receiver$iv;
            c = $receiver.charAt(p);
            boolean atBegin$iv = p == 0;
            boolean bl = ok = Character.isUpperCase((char)$receiver$iv) || $receiver$iv >= 48 && $receiver$iv <= 57 && !atBegin$iv || $receiver$iv == 95 || $receiver$iv == 35 || $receiver$iv == 36;
            if (!ok) break;
        }
        if (ok) {
            return $receiver;
        }
        c = '\"';
        String string = StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    private static final boolean isSameForCatalogAndScript(char $receiver, boolean atBegin) {
        return Character.isUpperCase($receiver) || $receiver >= '0' && $receiver <= '9' && !atBegin || $receiver == '_' || $receiver == '#' || $receiver == '$';
    }

    public static final void doNoting() {
    }

    public static final /* synthetic */ void access$processNames(@NotNull String[] items, @NotNull ModNamingIdentifyingFamily modelSchemas, boolean renew) {
        OraIntrospectorFunctions.processNames(items, modelSchemas, renew);
    }

    public static final /* synthetic */ void access$processSynonyms(@NotNull List ss, @NotNull OraModRoot root2) {
        OraIntrospectorFunctions.processSynonyms(ss, root2);
    }

    public static final /* synthetic */ void access$dropUnexistentObjectsInSchema(@NotNull OraModSchema schema, @NotNull TLongHashSet identifiers) {
        OraIntrospectorFunctions.dropUnexistentObjectsInSchema(schema, identifiers);
    }

    @NotNull
    public static final /* synthetic */ TreeSet access$getSYSTEM_SCHEMAS$p() {
        return SYSTEM_SCHEMAS;
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typeName, int precision, int scale, char unitsCode) {
        return OraIntrospectorFunctions.makeDataType(thisSchema, typeSchemaName, typeName, precision, scale, unitsCode);
    }

    public static final /* synthetic */ Pattern access$getCLUSTER_DECOMPILED_COLUMN_PATTERN$p() {
        return CLUSTER_DECOMPILED_COLUMN_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getSURROGATE_NAME_PATTERN$p() {
        return SURROGATE_NAME_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getINDEX_EXPRESSION_STUB_PATTERN$p() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ String access$unquoteNameIfPossible(@NotNull String name) {
        return OraIntrospectorFunctions.unquoteNameIfPossible(name);
    }

    public static final /* synthetic */ Pattern access$getAUTO_NOT_NULL_CHECK_PATTERN$p() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @Nullable
    public static final /* synthetic */ OraModConstraint access$findModConstraint(@NotNull OraTable $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModConstraint($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModLikeTable access$findTableOrViewByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findTableOrViewByName($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModModule access$findModuleByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModuleByName($receiver, name);
    }

    public static final /* synthetic */ void access$makeArgument(@NotNull BasicSchema schema, @NotNull OraModRoutine routine2, @Nullable String argName, char argDirection, @Nullable String dataTypeSchemaName, @NotNull String dataTypeSpec) {
        OraIntrospectorFunctions.makeArgument(schema, routine2, argName, argDirection, dataTypeSchemaName, dataTypeSpec);
    }

    public static final /* synthetic */ void access$applyViewSources(@NotNull OraModView view2, @Nullable String text) {
        OraIntrospectorFunctions.applyViewSources(view2, text);
    }

    public static final /* synthetic */ void access$applySources(@NotNull OraModSchema $receiver, @NotNull String type, @NotNull String name, @NotNull String sourceText) {
        OraIntrospectorFunctions.applySources($receiver, type, name, sourceText);
    }

    @Nullable
    public static final /* synthetic */ OraModTrigger access$findTrigger(@NotNull OraModSchema $receiver, @NotNull String triggerName) {
        return OraIntrospectorFunctions.findTrigger($receiver, triggerName);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

