/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicColumniation
extends BasicMinorObject,
DasTableChild {
    @Nullable
    default public BasicLikeTable getTable() {
        return (BasicLikeTable)((Object)this.getMajorObject());
    }

    @Nullable
    default public String getTableName() {
        BasicLikeTable table = this.getTable();
        return table != null ? table.getName() : null;
    }

    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getColNames"));
        }
        return list;
    }

    @NotNull
    default public List<? extends BasicColumn> getCols() {
        List<String> names = this.getColNames();
        if (names.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getCols"));
            }
            return list;
        }
        BasicLikeTable table = this.getTable();
        if (table == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getCols"));
            }
            return list;
        }
        List<? extends BasicColumn> list = table.getColumns().get(names);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getCols"));
        }
        return list;
    }

    default public boolean areColNames(@NotNull List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/model/basic/BasicColumniation", "areColNames"));
        }
        List<String> myNames = this.getColNames();
        int n = myNames.size();
        if (names.size() != n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            if (StringUtil.equals((CharSequence)myNames.get(i2), (CharSequence)names.get(i2))) continue;
            return false;
        }
        return true;
    }

    default public boolean dependsOnColumn(@NotNull String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/model/basic/BasicColumniation", "dependsOnColumn"));
        }
        return this.getColNames().contains(columnName);
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        String string = BasicColumniation.calculateDisplayOrderByColumns(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "calculateDisplayOrder"));
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrderByColumns(@NotNull BasicColumniation element) {
        String d;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/model/basic/BasicColumniation", "calculateDisplayOrderByColumns"));
        }
        List<? extends BasicColumn> cols3 = element.getCols();
        int n = cols3.size();
        switch (n) {
            case 0: {
                d = "\uffff";
                break;
            }
            case 1: {
                BasicElement c1 = cols3.get(0);
                String o = c1 != null ? c1.getDisplayOrder() : "";
                d = o + '!' + element.getName();
                break;
            }
            default: {
                String name = element.getName();
                StringBuilder b = new StringBuilder(n * 8 + name.length());
                for (BasicColumn basicColumn : cols3) {
                    String o2 = basicColumn != null ? basicColumn.getDisplayOrder() : "";
                    b.append(o2).append('!');
                }
                b.append(name);
                d = b.toString();
            }
        }
        String string = d;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "calculateDisplayOrderByColumns"));
        }
        return string;
    }
}

