/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.oracle.OraModArgument;
import com.intellij.database.model.oracle.OraModCheck;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModClusterColumn;
import com.intellij.database.model.oracle.OraModClusterIndex;
import com.intellij.database.model.oracle.OraModCollectionType;
import com.intellij.database.model.oracle.OraModForeignKey;
import com.intellij.database.model.oracle.OraModIndex;
import com.intellij.database.model.oracle.OraModKey;
import com.intellij.database.model.oracle.OraModMatView;
import com.intellij.database.model.oracle.OraModMatViewColumn;
import com.intellij.database.model.oracle.OraModMatViewTrigger;
import com.intellij.database.model.oracle.OraModModel;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModObjectTypeAttribute;
import com.intellij.database.model.oracle.OraModObjectTypeBody;
import com.intellij.database.model.oracle.OraModObjectTypeRoutine;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModPackageBody;
import com.intellij.database.model.oracle.OraModPackageRoutine;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSequence;
import com.intellij.database.model.oracle.OraModSingleRoutine;
import com.intellij.database.model.oracle.OraModSynonym;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.model.oracle.OraModTableTrigger;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraModViewColumn;
import com.intellij.database.model.oracle.OraModViewTrigger;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OracleImplModel
extends BaseModel
implements OraModModel {
    private final Root myRoot = new Root();

    OracleImplModel() {
    }

    @Override
    @NotNull
    public OraRoot getRoot() {
        Root root2 = this.myRoot;
        if (root2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel", "getRoot"));
        }
        return root2;
    }

    final class Synonym
    extends BaseModel.BaseRegularElement
    implements OraModSynonym {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myTargetSchemaName;
        @NotNull
        private ObjectKind myTargetObjectKind;
        @Nullable
        private String myTargetObjectName;
        private boolean myInvalid;

        private Synonym(BaseModel.BaseFamily<? extends Synonym> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Synonym", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myTargetSchemaName = null;
            this.myTargetObjectKind = ObjectKind.NONE;
            this.myTargetObjectName = null;
            this.myInvalid = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Synonym", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Synonym> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Synonym", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Synonym", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Synonym", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Synonym", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getTargetSchemaName() {
            return this.myTargetSchemaName;
        }

        @Override
        public void setTargetSchemaName(@Nullable String targetSchemaName) {
            if (BaseModel.eq(this.myTargetSchemaName, targetSchemaName)) {
                return;
            }
            this.modifying();
            this.myTargetSchemaName = targetSchemaName;
        }

        @Override
        @NotNull
        public ObjectKind getTargetObjectKind() {
            ObjectKind objectKind = this.myTargetObjectKind;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Synonym", "getTargetObjectKind"));
            }
            return objectKind;
        }

        @Override
        public void setTargetObjectKind(@NotNull ObjectKind targetObjectKind) {
            if (targetObjectKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetObjectKind", "com/intellij/database/model/impl/OracleImplModel$Synonym", "setTargetObjectKind"));
            }
            if (this.myTargetObjectKind.equals(targetObjectKind)) {
                return;
            }
            this.modifying();
            this.myTargetObjectKind = targetObjectKind;
        }

        @Override
        @Nullable
        public String getTargetObjectName() {
            return this.myTargetObjectName;
        }

        @Override
        public void setTargetObjectName(@Nullable String targetObjectName) {
            if (BaseModel.eq(this.myTargetObjectName, targetObjectName)) {
                return;
            }
            this.modifying();
            this.myTargetObjectName = targetObjectName;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }
    }

    final class ViewTrigger
    extends BaseModel.BaseRegularElement
    implements OraModViewTrigger {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private Set<TrigEvent> myEvents;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private List<String> myColNames;

        private ViewTrigger(BaseModel.BaseFamily<? extends ViewTrigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myEvents = Collections.emptySet();
            this.myTurn = null;
            this.myColNames = Collections.emptyList();
        }

        @Override
        @NotNull
        public View getView() {
            View view2 = (View)this.myParentFamily.owner;
            if (view2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "getView"));
            }
            return view2;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ViewTrigger> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvents() {
            Set<TrigEvent> set = this.myEvents;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "getEvents"));
            }
            return set;
        }

        @Override
        public void setEvents(@Nullable Set<TrigEvent> events) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = events != null ? ImmutableSet.copyOf(events) : Collections.emptySet();
            if (x.isEmpty() && this.myEvents.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvents = x;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewTrigger", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }
    }

    final class MatViewTrigger
    extends BaseModel.BaseRegularElement
    implements OraModMatViewTrigger {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private Set<TrigEvent> myEvents;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private List<String> myColNames;

        private MatViewTrigger(BaseModel.BaseFamily<? extends MatViewTrigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myEvents = Collections.emptySet();
            this.myTurn = null;
            this.myColNames = Collections.emptyList();
        }

        @Override
        @NotNull
        public MatView getMatView() {
            MatView matView = (MatView)this.myParentFamily.owner;
            if (matView == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "getMatView"));
            }
            return matView;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<MatViewTrigger> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvents() {
            Set<TrigEvent> set = this.myEvents;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "getEvents"));
            }
            return set;
        }

        @Override
        public void setEvents(@Nullable Set<TrigEvent> events) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = events != null ? ImmutableSet.copyOf(events) : Collections.emptySet();
            if (x.isEmpty() && this.myEvents.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvents = x;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewTrigger", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }
    }

    final class TableTrigger
    extends BaseModel.BaseRegularElement
    implements OraModTableTrigger {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private Set<TrigEvent> myEvents;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private List<String> myColNames;
        @Nullable
        private String myCondition;

        private TableTrigger(BaseModel.BaseFamily<? extends TableTrigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myEvents = Collections.emptySet();
            this.myTurn = null;
            this.myColNames = Collections.emptyList();
            this.myCondition = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<TableTrigger> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvents() {
            Set<TrigEvent> set = this.myEvents;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "getEvents"));
            }
            return set;
        }

        @Override
        public void setEvents(@Nullable Set<TrigEvent> events) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = events != null ? ImmutableSet.copyOf(events) : Collections.emptySet();
            if (x.isEmpty() && this.myEvents.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvents = x;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableTrigger", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        @Override
        public void setCondition(@Nullable String condition) {
            if (BaseModel.eq(this.myCondition, condition)) {
                return;
            }
            this.modifying();
            this.myCondition = condition;
        }
    }

    final class Argument
    extends BaseModel.BaseRegularElement
    implements OraModArgument {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasArgument.Direction myArgumentDirection;
        @NotNull
        private DataType myDataType;
        @Nullable
        private String myDefaultExpression;

        private Argument(BaseModel.BaseFamily<? extends Argument> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Argument", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myArgumentDirection = DasArgument.Direction.IN;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public OraModRoutine getRoutine() {
            OraModRoutine oraModRoutine = (OraModRoutine)((Object)this.myParentFamily.owner);
            if (oraModRoutine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Argument", "getRoutine"));
            }
            return oraModRoutine;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Argument> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Argument", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Argument", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Argument", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Argument", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasArgument.Direction getArgumentDirection() {
            DasArgument.Direction direction = this.myArgumentDirection;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Argument", "getArgumentDirection"));
            }
            return direction;
        }

        @Override
        public void setArgumentDirection(@NotNull DasArgument.Direction argumentDirection) {
            if (argumentDirection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentDirection", "com/intellij/database/model/impl/OracleImplModel$Argument", "setArgumentDirection"));
            }
            if (this.myArgumentDirection.equals((Object)argumentDirection)) {
                return;
            }
            this.modifying();
            this.myArgumentDirection = argumentDirection;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Argument", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/OracleImplModel$Argument", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class PackageRoutine
    extends BaseModel.BaseRegularElement
    implements OraModPackageRoutine {
        private final Arguments myArguments;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasRoutine.Kind myRoutineKind;
        private boolean myDeterministic;

        private PackageRoutine(BaseModel.BaseFamily<? extends PackageRoutine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRoutineKind = DasRoutine.Kind.NONE;
            this.myDeterministic = false;
        }

        @Override
        @NotNull
        public Package getPackage() {
            Package package_ = (Package)this.myParentFamily.owner;
            if (package_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "getPackage"));
            }
            return package_;
        }

        @Override
        @NotNull
        public ModNamingFamily<PackageRoutine> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasRoutine.Kind getRoutineKind() {
            DasRoutine.Kind kind = this.myRoutineKind;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "getRoutineKind"));
            }
            return kind;
        }

        @Override
        public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
            if (routineKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine", "setRoutineKind"));
            }
            if (this.myRoutineKind.equals((Object)routineKind)) {
                return;
            }
            this.modifying();
            this.myRoutineKind = routineKind;
        }

        @Override
        public boolean isDeterministic() {
            return this.myDeterministic;
        }

        @Override
        public void setDeterministic(boolean deterministic) {
            if (this.myDeterministic == deterministic) {
                return;
            }
            this.modifying();
            this.myDeterministic = deterministic;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(PackageRoutine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$PackageRoutine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class ObjectTypeRoutine
    extends BaseModel.BaseRegularElement
    implements OraModObjectTypeRoutine {
        private final Arguments myArguments;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasRoutine.Kind myRoutineKind;
        private boolean myDeterministic;

        private ObjectTypeRoutine(BaseModel.BaseFamily<? extends ObjectTypeRoutine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRoutineKind = DasRoutine.Kind.NONE;
            this.myDeterministic = false;
        }

        @Override
        @NotNull
        public ObjectType getObjectType() {
            ObjectType objectType = (ObjectType)this.myParentFamily.owner;
            if (objectType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "getObjectType"));
            }
            return objectType;
        }

        @Override
        @NotNull
        public ModNamingFamily<ObjectTypeRoutine> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasRoutine.Kind getRoutineKind() {
            DasRoutine.Kind kind = this.myRoutineKind;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "getRoutineKind"));
            }
            return kind;
        }

        @Override
        public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
            if (routineKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine", "setRoutineKind"));
            }
            if (this.myRoutineKind.equals((Object)routineKind)) {
                return;
            }
            this.modifying();
            this.myRoutineKind = routineKind;
        }

        @Override
        public boolean isDeterministic() {
            return this.myDeterministic;
        }

        @Override
        public void setDeterministic(boolean deterministic) {
            if (this.myDeterministic == deterministic) {
                return;
            }
            this.modifying();
            this.myDeterministic = deterministic;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(ObjectTypeRoutine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeRoutine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class SingleRoutine
    extends BaseModel.BaseRegularElement
    implements OraModSingleRoutine {
        private final Arguments myArguments;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasRoutine.Kind myRoutineKind;
        private boolean myDeterministic;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;

        private SingleRoutine(BaseModel.BaseFamily<? extends SingleRoutine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRoutineKind = DasRoutine.Kind.NONE;
            this.myDeterministic = false;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<SingleRoutine> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasRoutine.Kind getRoutineKind() {
            DasRoutine.Kind kind = this.myRoutineKind;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "getRoutineKind"));
            }
            return kind;
        }

        @Override
        public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
            if (routineKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "setRoutineKind"));
            }
            if (this.myRoutineKind.equals((Object)routineKind)) {
                return;
            }
            this.modifying();
            this.myRoutineKind = routineKind;
        }

        @Override
        public boolean isDeterministic() {
            return this.myDeterministic;
        }

        @Override
        public void setDeterministic(boolean deterministic) {
            if (this.myDeterministic == deterministic) {
                return;
            }
            this.modifying();
            this.myDeterministic = deterministic;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(SingleRoutine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$SingleRoutine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class CollectionType
    extends BaseModel.BaseRegularElement
    implements OraModCollectionType {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private DataType myElementType;
        private int myUpperBound;
        private boolean myArray;

        private CollectionType(BaseModel.BaseFamily<? extends CollectionType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myElementType = ModelConsts.NO_DATA_TYPE;
            this.myUpperBound = 0;
            this.myArray = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<CollectionType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public DataType getElementType() {
            DataType dataType = this.myElementType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "getElementType"));
            }
            return dataType;
        }

        @Override
        public void setElementType(@NotNull DataType elementType) {
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/database/model/impl/OracleImplModel$CollectionType", "setElementType"));
            }
            if (this.myElementType.equals(elementType)) {
                return;
            }
            this.modifying();
            this.myElementType = elementType;
        }

        @Override
        public int getUpperBound() {
            return this.myUpperBound;
        }

        @Override
        public void setUpperBound(int upperBound) {
            if (this.myUpperBound == upperBound) {
                return;
            }
            this.modifying();
            this.myUpperBound = upperBound;
        }

        @Override
        public boolean isArray() {
            return this.myArray;
        }

        @Override
        public void setArray(boolean array) {
            if (this.myArray == array) {
                return;
            }
            this.modifying();
            this.myArray = array;
        }
    }

    final class PackageBody
    extends BaseModel.BaseRegularElement
    implements OraModPackageBody {
        private long myObjectId;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myComment;

        private PackageBody(BaseModel.BaseFamily<? extends PackageBody> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$PackageBody", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myComment = null;
        }

        @Override
        @NotNull
        public Package getPackage() {
            Package package_ = (Package)this.myParentFamily.owner;
            if (package_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageBody", "getPackage"));
            }
            return package_;
        }

        @Override
        @NotNull
        public ModSingletonFamily<PackageBody> getParentFamily() {
            ModSingletonFamily modSingletonFamily = (ModSingletonFamily)((Object)this.myParentFamily);
            if (modSingletonFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageBody", "getParentFamily"));
            }
            return modSingletonFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$PackageBody", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$PackageBody", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }
    }

    final class Package
    extends BaseModel.BaseRegularElement
    implements OraModPackage {
        private final Bodies myBodies;
        private final Routines myRoutines;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;

        private Package(BaseModel.BaseFamily<? extends Package> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Package", "<init>"));
            }
            super(parentFamily);
            this.myBodies = new Bodies(this);
            this.myRoutines = new Routines(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Package", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Package> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Package", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Bodies getBodies() {
            Bodies bodies = this.myBodies;
            if (bodies == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Package", "getBodies"));
            }
            return bodies;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Package", "getRoutines"));
            }
            return routines;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Package", "familyOf"));
            }
            if (kind == ObjectKind.BODY) {
                return this.myBodies;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Package", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Package", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Package", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        private final class Routines
        extends BaseModel.BaseNamingFamily<PackageRoutine> {
            private Routines(Package owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Package$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected PackageRoutine instantiate() {
                return new PackageRoutine(this);
            }
        }

        private final class Bodies
        extends BaseModel.BaseSingletonFamily<PackageBody> {
            private Bodies(Package owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Package$Bodies", "<init>"));
                }
                super(owner);
            }

            @Override
            protected PackageBody instantiate() {
                return new PackageBody(this);
            }
        }
    }

    final class ObjectTypeAttribute
    extends BaseModel.BaseRegularElement
    implements OraModObjectTypeAttribute {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private ObjectTypeAttribute(BaseModel.BaseFamily<? extends ObjectTypeAttribute> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public ObjectType getObjectType() {
            ObjectType objectType = (ObjectType)this.myParentFamily.owner;
            if (objectType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "getObjectType"));
            }
            return objectType;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ObjectTypeAttribute> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeAttribute", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class ObjectTypeBody
    extends BaseModel.BaseRegularElement
    implements OraModObjectTypeBody {
        private long myObjectId;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myComment;

        private ObjectTypeBody(BaseModel.BaseFamily<? extends ObjectTypeBody> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeBody", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myComment = null;
        }

        @Override
        @NotNull
        public ObjectType getObjectType() {
            ObjectType objectType = (ObjectType)this.myParentFamily.owner;
            if (objectType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeBody", "getObjectType"));
            }
            return objectType;
        }

        @Override
        @NotNull
        public ModSingletonFamily<ObjectTypeBody> getParentFamily() {
            ModSingletonFamily modSingletonFamily = (ModSingletonFamily)((Object)this.myParentFamily);
            if (modSingletonFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeBody", "getParentFamily"));
            }
            return modSingletonFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeBody", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectTypeBody", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }
    }

    final class ObjectType
    extends BaseModel.BaseRegularElement
    implements OraModObjectType {
        private final Bodies myBodies;
        private final Attributes myAttributes;
        private final Routines myRoutines;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String mySuperSchemaName;
        @Nullable
        private String mySuperObjectName;
        private boolean myIncomplete;
        private boolean myFinal;
        private boolean myInstantiable;

        private ObjectType(BaseModel.BaseFamily<? extends ObjectType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "<init>"));
            }
            super(parentFamily);
            this.myBodies = new Bodies(this);
            this.myAttributes = new Attributes(this);
            this.myRoutines = new Routines(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.mySuperSchemaName = null;
            this.mySuperObjectName = null;
            this.myIncomplete = false;
            this.myFinal = false;
            this.myInstantiable = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ObjectType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Bodies getBodies() {
            Bodies bodies = this.myBodies;
            if (bodies == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getBodies"));
            }
            return bodies;
        }

        @Override
        @NotNull
        public Attributes getAttributes() {
            Attributes attributes = this.myAttributes;
            if (attributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getAttributes"));
            }
            return attributes;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getRoutines"));
            }
            return routines;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "familyOf"));
            }
            if (kind == ObjectKind.BODY) {
                return this.myBodies;
            }
            if (kind == ObjectKind.OBJECT_ATTRIBUTE) {
                return this.myAttributes;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ObjectType", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getSuperSchemaName() {
            return this.mySuperSchemaName;
        }

        @Override
        public void setSuperSchemaName(@Nullable String superSchemaName) {
            if (BaseModel.eq(this.mySuperSchemaName, superSchemaName)) {
                return;
            }
            this.modifying();
            this.mySuperSchemaName = superSchemaName;
        }

        @Override
        @Nullable
        public String getSuperObjectName() {
            return this.mySuperObjectName;
        }

        @Override
        public void setSuperObjectName(@Nullable String superObjectName) {
            if (BaseModel.eq(this.mySuperObjectName, superObjectName)) {
                return;
            }
            this.modifying();
            this.mySuperObjectName = superObjectName;
        }

        @Override
        public boolean isIncomplete() {
            return this.myIncomplete;
        }

        @Override
        public void setIncomplete(boolean incomplete) {
            if (this.myIncomplete == incomplete) {
                return;
            }
            this.modifying();
            this.myIncomplete = incomplete;
        }

        @Override
        public boolean isFinal() {
            return this.myFinal;
        }

        @Override
        public void setFinal(boolean finnal) {
            if (this.myFinal == finnal) {
                return;
            }
            this.modifying();
            this.myFinal = finnal;
        }

        @Override
        public boolean isInstantiable() {
            return this.myInstantiable;
        }

        @Override
        public void setInstantiable(boolean instantiable) {
            if (this.myInstantiable == instantiable) {
                return;
            }
            this.modifying();
            this.myInstantiable = instantiable;
        }

        private final class Routines
        extends BaseModel.BaseNamingFamily<ObjectTypeRoutine> {
            private Routines(ObjectType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$ObjectType$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ObjectTypeRoutine instantiate() {
                return new ObjectTypeRoutine(this);
            }
        }

        private final class Attributes
        extends BaseModel.BasePositioningNamingFamily<ObjectTypeAttribute> {
            private Attributes(ObjectType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$ObjectType$Attributes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ObjectTypeAttribute instantiate() {
                return new ObjectTypeAttribute(this);
            }
        }

        private final class Bodies
        extends BaseModel.BaseSingletonFamily<ObjectTypeBody> {
            private Bodies(ObjectType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$ObjectType$Bodies", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ObjectTypeBody instantiate() {
                return new ObjectTypeBody(this);
            }
        }
    }

    final class Check
    extends BaseModel.BaseRegularElement
    implements OraModCheck {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myPredicate;

        private Check(BaseModel.BaseFamily<? extends Check> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Check", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPredicate = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Check", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Check> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Check", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Check", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Check", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Check", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Check", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getPredicate() {
            return this.myPredicate;
        }

        @Override
        public void setPredicate(@Nullable String predicate) {
            if (BaseModel.eq(this.myPredicate, predicate)) {
                return;
            }
            this.modifying();
            this.myPredicate = predicate;
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularElement
    implements OraModForeignKey {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private CascadeRule myOnDelete;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myOnDelete = CascadeRule.no_action;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ForeignKey> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public CascadeRule getOnDelete() {
            CascadeRule cascadeRule = this.myOnDelete;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "getOnDelete"));
            }
            return cascadeRule;
        }

        @Override
        public void setOnDelete(@NotNull CascadeRule onDelete) {
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/model/impl/OracleImplModel$ForeignKey", "setOnDelete"));
            }
            if (this.myOnDelete.equals((Object)onDelete)) {
                return;
            }
            this.modifying();
            this.myOnDelete = onDelete;
        }
    }

    final class Key
    extends BaseModel.BaseRegularElement
    implements OraModKey {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myUnderlyingIndexName;
        private boolean myPrimary;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myUnderlyingIndexName = null;
            this.myPrimary = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Key", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Key> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Key", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Key", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Key", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getUnderlyingIndexName() {
            return this.myUnderlyingIndexName;
        }

        @Override
        public void setUnderlyingIndexName(@Nullable String underlyingIndexName) {
            if (BaseModel.eq(this.myUnderlyingIndexName, underlyingIndexName)) {
                return;
            }
            this.modifying();
            this.myUnderlyingIndexName = underlyingIndexName;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }
    }

    final class Index
    extends BaseModel.BaseRegularElement
    implements OraModIndex {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myTablespaceName;
        @NotNull
        private List<String> myColNames;
        @NotNull
        private Set<String> myReverseColNames;
        private boolean myUnique;
        private boolean myClustering;
        private boolean myFunctionBased;
        private boolean myBitmap;

        private Index(BaseModel.BaseFamily<? extends Index> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Index", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myTablespaceName = null;
            this.myColNames = Collections.emptyList();
            this.myReverseColNames = Collections.emptySet();
            this.myUnique = false;
            this.myClustering = false;
            this.myFunctionBased = false;
            this.myBitmap = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Index", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Index> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Index", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Index", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Index", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Index", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getTablespaceName() {
            return this.myTablespaceName;
        }

        @Override
        public void setTablespaceName(@Nullable String tablespaceName) {
            if (BaseModel.eq(this.myTablespaceName, tablespaceName)) {
                return;
            }
            this.modifying();
            this.myTablespaceName = tablespaceName;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Index", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @NotNull
        public Set<String> getReverseColNames() {
            Set<String> set = this.myReverseColNames;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Index", "getReverseColNames"));
            }
            return set;
        }

        @Override
        public void setReverseColNames(@Nullable Set<String> reverseColNames) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = reverseColNames != null ? ImmutableSet.copyOf(reverseColNames) : Collections.emptySet();
            if (x.isEmpty() && this.myReverseColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myReverseColNames = x;
        }

        @Override
        public boolean isUnique() {
            return this.myUnique;
        }

        @Override
        public void setUnique(boolean unique) {
            if (this.myUnique == unique) {
                return;
            }
            this.modifying();
            this.myUnique = unique;
        }

        @Override
        public boolean isClustering() {
            return this.myClustering;
        }

        @Override
        public void setClustering(boolean clustering) {
            if (this.myClustering == clustering) {
                return;
            }
            this.modifying();
            this.myClustering = clustering;
        }

        @Override
        public boolean isFunctionBased() {
            return this.myFunctionBased;
        }

        @Override
        public void setFunctionBased(boolean functionBased) {
            if (this.myFunctionBased == functionBased) {
                return;
            }
            this.modifying();
            this.myFunctionBased = functionBased;
        }

        @Override
        public boolean isBitmap() {
            return this.myBitmap;
        }

        @Override
        public void setBitmap(boolean bitmap) {
            if (this.myBitmap == bitmap) {
                return;
            }
            this.modifying();
            this.myBitmap = bitmap;
        }
    }

    final class MatViewColumn
    extends BaseModel.BaseRegularElement
    implements OraModMatViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private MatViewColumn(BaseModel.BaseFamily<? extends MatViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public MatView getMatView() {
            MatView matView = (MatView)this.myParentFamily.owner;
            if (matView == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "getMatView"));
            }
            return matView;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<MatViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/OracleImplModel$MatViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class MatView
    extends BaseModel.BaseRegularElement
    implements OraModMatView {
        private final Columns myColumns;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String myRowTypeSchemaName;
        @Nullable
        private String myRowTypeObjectName;
        private boolean mySystem;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myTablespaceName;

        private MatView(BaseModel.BaseFamily<? extends MatView> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$MatView", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRowTypeSchemaName = null;
            this.myRowTypeObjectName = null;
            this.mySystem = false;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myTablespaceName = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatView", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<MatView> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatView", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatView", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatView", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$MatView", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatView", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$MatView", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getRowTypeSchemaName() {
            return this.myRowTypeSchemaName;
        }

        @Override
        public void setRowTypeSchemaName(@Nullable String rowTypeSchemaName) {
            if (BaseModel.eq(this.myRowTypeSchemaName, rowTypeSchemaName)) {
                return;
            }
            this.modifying();
            this.myRowTypeSchemaName = rowTypeSchemaName;
        }

        @Override
        @Nullable
        public String getRowTypeObjectName() {
            return this.myRowTypeObjectName;
        }

        @Override
        public void setRowTypeObjectName(@Nullable String rowTypeObjectName) {
            if (BaseModel.eq(this.myRowTypeObjectName, rowTypeObjectName)) {
                return;
            }
            this.modifying();
            this.myRowTypeObjectName = rowTypeObjectName;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$MatView", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getTablespaceName() {
            return this.myTablespaceName;
        }

        @Override
        public void setTablespaceName(@Nullable String tablespaceName) {
            if (BaseModel.eq(this.myTablespaceName, tablespaceName)) {
                return;
            }
            this.modifying();
            this.myTablespaceName = tablespaceName;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<MatViewTrigger> {
            private Triggers(MatView owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$MatView$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected MatViewTrigger instantiate() {
                return new MatViewTrigger(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<MatViewColumn> {
            private Columns(MatView owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$MatView$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected MatViewColumn instantiate() {
                return new MatViewColumn(this);
            }
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularElement
    implements OraModViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public View getView() {
            View view2 = (View)this.myParentFamily.owner;
            if (view2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "getView"));
            }
            return view2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/OracleImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class View
    extends BaseModel.BaseRegularElement
    implements OraModView {
        private final Columns myColumns;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String myRowTypeSchemaName;
        @Nullable
        private String myRowTypeObjectName;
        private boolean mySystem;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private boolean myObfuscated;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        private boolean myModifiable;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRowTypeSchemaName = null;
            this.myRowTypeObjectName = null;
            this.mySystem = false;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myObfuscated = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myModifiable = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<View> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$View", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$View", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$View", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$View", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$View", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getRowTypeSchemaName() {
            return this.myRowTypeSchemaName;
        }

        @Override
        public void setRowTypeSchemaName(@Nullable String rowTypeSchemaName) {
            if (BaseModel.eq(this.myRowTypeSchemaName, rowTypeSchemaName)) {
                return;
            }
            this.modifying();
            this.myRowTypeSchemaName = rowTypeSchemaName;
        }

        @Override
        @Nullable
        public String getRowTypeObjectName() {
            return this.myRowTypeObjectName;
        }

        @Override
        public void setRowTypeObjectName(@Nullable String rowTypeObjectName) {
            if (BaseModel.eq(this.myRowTypeObjectName, rowTypeObjectName)) {
                return;
            }
            this.modifying();
            this.myRowTypeObjectName = rowTypeObjectName;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$View", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public boolean isObfuscated() {
            return this.myObfuscated;
        }

        @Override
        public void setObfuscated(boolean obfuscated) {
            if (this.myObfuscated == obfuscated) {
                return;
            }
            this.modifying();
            this.myObfuscated = obfuscated;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public boolean isModifiable() {
            return this.myModifiable;
        }

        @Override
        public void setModifiable(boolean modifiable) {
            if (this.myModifiable == modifiable) {
                return;
            }
            this.modifying();
            this.myModifiable = modifiable;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<ViewTrigger> {
            private Triggers(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$View$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewTrigger instantiate() {
                return new ViewTrigger(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularElement
    implements OraModTableColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        @Nullable
        private String myDefaultExpression;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/OracleImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Table
    extends BaseModel.BaseRegularElement
    implements OraModTable {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private final Checks myChecks;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String myRowTypeSchemaName;
        @Nullable
        private String myRowTypeObjectName;
        private boolean mySystem;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myTablespaceName;
        private boolean myTemporary;
        private boolean myTemporaryPreserve;
        @NotNull
        private TableOrganization myOrganization;
        @Nullable
        private String myClusterName;
        @NotNull
        private List<String> myClusterColNames;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myChecks = new Checks(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRowTypeSchemaName = null;
            this.myRowTypeObjectName = null;
            this.mySystem = false;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myTablespaceName = null;
            this.myTemporary = false;
            this.myTemporaryPreserve = false;
            this.myOrganization = TableOrganization.DEFAULT;
            this.myClusterName = null;
            this.myClusterColNames = Collections.emptyList();
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Table> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getChecks"));
            }
            return checks;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Table", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getRowTypeSchemaName() {
            return this.myRowTypeSchemaName;
        }

        @Override
        public void setRowTypeSchemaName(@Nullable String rowTypeSchemaName) {
            if (BaseModel.eq(this.myRowTypeSchemaName, rowTypeSchemaName)) {
                return;
            }
            this.modifying();
            this.myRowTypeSchemaName = rowTypeSchemaName;
        }

        @Override
        @Nullable
        public String getRowTypeObjectName() {
            return this.myRowTypeObjectName;
        }

        @Override
        public void setRowTypeObjectName(@Nullable String rowTypeObjectName) {
            if (BaseModel.eq(this.myRowTypeObjectName, rowTypeObjectName)) {
                return;
            }
            this.modifying();
            this.myRowTypeObjectName = rowTypeObjectName;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getTablespaceName() {
            return this.myTablespaceName;
        }

        @Override
        public void setTablespaceName(@Nullable String tablespaceName) {
            if (BaseModel.eq(this.myTablespaceName, tablespaceName)) {
                return;
            }
            this.modifying();
            this.myTablespaceName = tablespaceName;
        }

        @Override
        public boolean isTemporary() {
            return this.myTemporary;
        }

        @Override
        public void setTemporary(boolean temporary) {
            if (this.myTemporary == temporary) {
                return;
            }
            this.modifying();
            this.myTemporary = temporary;
        }

        @Override
        public boolean isTemporaryPreserve() {
            return this.myTemporaryPreserve;
        }

        @Override
        public void setTemporaryPreserve(boolean temporaryPreserve) {
            if (this.myTemporaryPreserve == temporaryPreserve) {
                return;
            }
            this.modifying();
            this.myTemporaryPreserve = temporaryPreserve;
        }

        @Override
        @NotNull
        public TableOrganization getOrganization() {
            TableOrganization tableOrganization = this.myOrganization;
            if (tableOrganization == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getOrganization"));
            }
            return tableOrganization;
        }

        @Override
        public void setOrganization(@NotNull TableOrganization organization) {
            if (organization == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "organization", "com/intellij/database/model/impl/OracleImplModel$Table", "setOrganization"));
            }
            if (this.myOrganization.equals((Object)organization)) {
                return;
            }
            this.modifying();
            this.myOrganization = organization;
        }

        @Override
        @Nullable
        public String getClusterName() {
            return this.myClusterName;
        }

        @Override
        public void setClusterName(@Nullable String clusterName) {
            if (BaseModel.eq(this.myClusterName, clusterName)) {
                return;
            }
            this.modifying();
            this.myClusterName = clusterName;
        }

        @Override
        @NotNull
        public List<String> getClusterColNames() {
            List<String> list = this.myClusterColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Table", "getClusterColNames"));
            }
            return list;
        }

        @Override
        public void setClusterColNames(@Nullable List<String> clusterColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = clusterColNames != null ? ImmutableList.copyOf(clusterColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myClusterColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myClusterColNames = x;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<TableTrigger> {
            private Triggers(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Table$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableTrigger instantiate() {
                return new TableTrigger(this);
            }
        }

        private final class Checks
        extends BaseModel.BaseNamingIdentifyingFamily<Check> {
            private Checks(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Table$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingIdentifyingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingIdentifyingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BaseNamingIdentifyingFamily<Index> {
            private Indices(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Table$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class ClusterIndex
    extends BaseModel.BaseRegularElement
    implements OraModClusterIndex {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myTablespaceName;
        @NotNull
        private List<String> myColNames;

        private ClusterIndex(BaseModel.BaseFamily<? extends ClusterIndex> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myTablespaceName = null;
            this.myColNames = Collections.emptyList();
        }

        @Override
        @NotNull
        public Cluster getCluster() {
            Cluster cluster = (Cluster)this.myParentFamily.owner;
            if (cluster == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "getCluster"));
            }
            return cluster;
        }

        @Override
        @NotNull
        public ModSingletonFamily<ClusterIndex> getParentFamily() {
            ModSingletonFamily modSingletonFamily = (ModSingletonFamily)((Object)this.myParentFamily);
            if (modSingletonFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "getParentFamily"));
            }
            return modSingletonFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getTablespaceName() {
            return this.myTablespaceName;
        }

        @Override
        public void setTablespaceName(@Nullable String tablespaceName) {
            if (BaseModel.eq(this.myTablespaceName, tablespaceName)) {
                return;
            }
            this.modifying();
            this.myTablespaceName = tablespaceName;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterIndex", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }
    }

    final class ClusterColumn
    extends BaseModel.BaseRegularElement
    implements OraModClusterColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean mySorted;

        private ClusterColumn(BaseModel.BaseFamily<? extends ClusterColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.mySorted = false;
        }

        @Override
        @NotNull
        public Cluster getCluster() {
            Cluster cluster = (Cluster)this.myParentFamily.owner;
            if (cluster == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "getCluster"));
            }
            return cluster;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ClusterColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/OracleImplModel$ClusterColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isSorted() {
            return this.mySorted;
        }

        @Override
        public void setSorted(boolean sorted) {
            if (this.mySorted == sorted) {
                return;
            }
            this.modifying();
            this.mySorted = sorted;
        }
    }

    final class Cluster
    extends BaseModel.BaseRegularElement
    implements OraModCluster {
        private final Columns myColumns;
        private final Indices myIndices;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private String myTablespaceName;
        @Nullable
        private ClusterType myClusterType;
        private boolean mySingleTable;
        private int myBlockSize;
        @Nullable
        private String myHashExpression;
        private int myHashCardinality;

        private Cluster(BaseModel.BaseFamily<? extends Cluster> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Cluster", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myTablespaceName = null;
            this.myClusterType = null;
            this.mySingleTable = false;
            this.myBlockSize = 0;
            this.myHashExpression = null;
            this.myHashCardinality = 0;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Cluster", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Cluster> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Cluster", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Cluster", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Cluster", "getIndices"));
            }
            return indices;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Cluster", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Cluster", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Cluster", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public String getTablespaceName() {
            return this.myTablespaceName;
        }

        @Override
        public void setTablespaceName(@Nullable String tablespaceName) {
            if (BaseModel.eq(this.myTablespaceName, tablespaceName)) {
                return;
            }
            this.modifying();
            this.myTablespaceName = tablespaceName;
        }

        @Override
        @Nullable
        public ClusterType getClusterType() {
            return this.myClusterType;
        }

        @Override
        public void setClusterType(@Nullable ClusterType clusterType) {
            if (BaseModel.eq(this.myClusterType, clusterType)) {
                return;
            }
            this.modifying();
            this.myClusterType = clusterType;
        }

        @Override
        public boolean isSingleTable() {
            return this.mySingleTable;
        }

        @Override
        public void setSingleTable(boolean singleTable) {
            if (this.mySingleTable == singleTable) {
                return;
            }
            this.modifying();
            this.mySingleTable = singleTable;
        }

        @Override
        public int getBlockSize() {
            return this.myBlockSize;
        }

        @Override
        public void setBlockSize(int blockSize) {
            if (this.myBlockSize == blockSize) {
                return;
            }
            this.modifying();
            this.myBlockSize = blockSize;
        }

        @Override
        @Nullable
        public String getHashExpression() {
            return this.myHashExpression;
        }

        @Override
        public void setHashExpression(@Nullable String hashExpression) {
            if (BaseModel.eq(this.myHashExpression, hashExpression)) {
                return;
            }
            this.modifying();
            this.myHashExpression = hashExpression;
        }

        @Override
        public int getHashCardinality() {
            return this.myHashCardinality;
        }

        @Override
        public void setHashCardinality(int hashCardinality) {
            if (this.myHashCardinality == hashCardinality) {
                return;
            }
            this.modifying();
            this.myHashCardinality = hashCardinality;
        }

        private final class Indices
        extends BaseModel.BaseSingletonFamily<ClusterIndex> {
            private Indices(Cluster owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Cluster$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ClusterIndex instantiate() {
                return new ClusterIndex(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ClusterColumn> {
            private Columns(Cluster owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Cluster$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ClusterColumn instantiate() {
                return new ClusterColumn(this);
            }
        }
    }

    final class Sequence
    extends BaseModel.BaseRegularElement
    implements OraModSequence {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        @Nullable
        private SequenceIdentity mySequenceIdentity;
        private boolean myOrdered;
        private boolean myCycled;
        private int myCacheSize;

        private Sequence(BaseModel.BaseFamily<? extends Sequence> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Sequence", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.mySequenceIdentity = null;
            this.myOrdered = false;
            this.myCycled = false;
            this.myCacheSize = 0;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Sequence", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Sequence> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Sequence", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Sequence", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Sequence", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Sequence", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        @Nullable
        public SequenceIdentity getSequenceIdentity() {
            return this.mySequenceIdentity;
        }

        @Override
        public void setSequenceIdentity(@Nullable SequenceIdentity sequenceIdentity) {
            if (BaseModel.eq(this.mySequenceIdentity, sequenceIdentity)) {
                return;
            }
            this.modifying();
            this.mySequenceIdentity = sequenceIdentity;
        }

        @Override
        public boolean isOrdered() {
            return this.myOrdered;
        }

        @Override
        public void setOrdered(boolean ordered) {
            if (this.myOrdered == ordered) {
                return;
            }
            this.modifying();
            this.myOrdered = ordered;
        }

        @Override
        public boolean isCycled() {
            return this.myCycled;
        }

        @Override
        public void setCycled(boolean cycled) {
            if (this.myCycled == cycled) {
                return;
            }
            this.modifying();
            this.myCycled = cycled;
        }

        @Override
        public int getCacheSize() {
            return this.myCacheSize;
        }

        @Override
        public void setCacheSize(int cacheSize) {
            if (this.myCacheSize == cacheSize) {
                return;
            }
            this.modifying();
            this.myCacheSize = cacheSize;
        }
    }

    final class Schema
    extends BaseModel.BaseRegularElement
    implements OraModSchema {
        private final Sequences mySequences;
        private final Clusters myClusters;
        private final Tables myTables;
        private final Views myViews;
        private final MatViews myMatViews;
        private final Packages myPackages;
        private final ObjectTypes myObjectTypes;
        private final CollectionTypes myCollectionTypes;
        private final Routines myRoutines;
        private final Synonyms mySynonyms;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        @Nullable
        private Date myCreatedTimestamp;
        @Nullable
        private Date myModifiedTimestamp;
        private long myCommentsHash;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/OracleImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.mySequences = new Sequences(this);
            this.myClusters = new Clusters(this);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myMatViews = new MatViews(this);
            this.myPackages = new Packages(this);
            this.myObjectTypes = new ObjectTypes(this);
            this.myCollectionTypes = new CollectionTypes(this);
            this.myRoutines = new Routines(this);
            this.mySynonyms = new Synonyms(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myCreatedTimestamp = null;
            this.myModifiedTimestamp = null;
            this.myCommentsHash = 0L;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root2 = (Root)this.myParentFamily.owner;
            if (root2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getRoot"));
            }
            return root2;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Schema> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Sequences getSequences() {
            Sequences sequences = this.mySequences;
            if (sequences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getSequences"));
            }
            return sequences;
        }

        @Override
        @NotNull
        public Clusters getClusters() {
            Clusters clusters = this.myClusters;
            if (clusters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getClusters"));
            }
            return clusters;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @NotNull
        public MatViews getMatViews() {
            MatViews matViews = this.myMatViews;
            if (matViews == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getMatViews"));
            }
            return matViews;
        }

        @Override
        @NotNull
        public Packages getPackages() {
            Packages packages = this.myPackages;
            if (packages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getPackages"));
            }
            return packages;
        }

        @Override
        @NotNull
        public ObjectTypes getObjectTypes() {
            ObjectTypes objectTypes = this.myObjectTypes;
            if (objectTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getObjectTypes"));
            }
            return objectTypes;
        }

        @Override
        @NotNull
        public CollectionTypes getCollectionTypes() {
            CollectionTypes collectionTypes = this.myCollectionTypes;
            if (collectionTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getCollectionTypes"));
            }
            return collectionTypes;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getRoutines"));
            }
            return routines;
        }

        @Override
        @NotNull
        public Synonyms getSynonyms() {
            Synonyms synonyms = this.mySynonyms;
            if (synonyms == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getSynonyms"));
            }
            return synonyms;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.SEQUENCE) {
                return this.mySequences;
            }
            if (kind == ObjectKind.CLUSTER) {
                return this.myClusters;
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            if (kind == ObjectKind.MAT_VIEW) {
                return this.myMatViews;
            }
            if (kind == ObjectKind.PACKAGE) {
                return this.myPackages;
            }
            if (kind == ObjectKind.OBJECT_TYPE) {
                return this.myObjectTypes;
            }
            if (kind == ObjectKind.COLLECTION_TYPE) {
                return this.myCollectionTypes;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            if (kind == ObjectKind.SYNONYM) {
                return this.mySynonyms;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Schema", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/OracleImplModel$Schema", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        @Nullable
        public Date getCreatedTimestamp() {
            return this.myCreatedTimestamp;
        }

        @Override
        public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
            if (BaseModel.eq(this.myCreatedTimestamp, createdTimestamp)) {
                return;
            }
            this.modifying();
            this.myCreatedTimestamp = createdTimestamp;
        }

        @Override
        @Nullable
        public Date getModifiedTimestamp() {
            return this.myModifiedTimestamp;
        }

        @Override
        public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
            if (BaseModel.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
                return;
            }
            this.modifying();
            this.myModifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public long getCommentsHash() {
            return this.myCommentsHash;
        }

        @Override
        public void setCommentsHash(long commentsHash) {
            if (this.myCommentsHash == commentsHash) {
                return;
            }
            this.modifying();
            this.myCommentsHash = commentsHash;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Synonyms
        extends BaseModel.BaseNamingIdentifyingFamily<Synonym> {
            private Synonyms(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Synonyms", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Synonym instantiate() {
                return new Synonym(this);
            }
        }

        private final class Routines
        extends BaseModel.BaseNamingIdentifyingFamily<SingleRoutine> {
            private Routines(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected SingleRoutine instantiate() {
                return new SingleRoutine(this);
            }
        }

        private final class CollectionTypes
        extends BaseModel.BaseNamingIdentifyingFamily<CollectionType> {
            private CollectionTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$CollectionTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected CollectionType instantiate() {
                return new CollectionType(this);
            }
        }

        private final class ObjectTypes
        extends BaseModel.BaseNamingIdentifyingFamily<ObjectType> {
            private ObjectTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$ObjectTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ObjectType instantiate() {
                return new ObjectType(this);
            }
        }

        private final class Packages
        extends BaseModel.BaseNamingIdentifyingFamily<Package> {
            private Packages(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Packages", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Package instantiate() {
                return new Package(this);
            }
        }

        private final class MatViews
        extends BaseModel.BaseNamingIdentifyingFamily<MatView> {
            private MatViews(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$MatViews", "<init>"));
                }
                super(owner);
            }

            @Override
            protected MatView instantiate() {
                return new MatView(this);
            }
        }

        private final class Views
        extends BaseModel.BaseNamingIdentifyingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingIdentifyingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }

        private final class Clusters
        extends BaseModel.BaseNamingIdentifyingFamily<Cluster> {
            private Clusters(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Clusters", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Cluster instantiate() {
                return new Cluster(this);
            }
        }

        private final class Sequences
        extends BaseModel.BaseNamingIdentifyingFamily<Sequence> {
            private Sequences(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Schema$Sequences", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Sequence instantiate() {
                return new Sequence(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements OraModRoot {
        private final Schemas mySchemas = new Schemas(this);

        private Root() {
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas2 = this.mySchemas;
            if (schemas2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/OracleImplModel$Root", "getSchemas"));
            }
            return schemas2;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/OracleImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        private final class Schemas
        extends BaseModel.BaseNamingIdentifyingFamily<Schema> {
            private Schemas(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/OracleImplModel$Root$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }
}

