/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraModClusterColumn;
import com.intellij.database.model.oracle.OraModClusterIndex;
import com.intellij.database.model.oracle.OraModMajorObject;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModStoredSchemaObject;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModCluster
extends OraCluster,
OraModMajorObject,
OraModStoredSchemaObject {
    @Override
    @NotNull
    public OraModSchema getSchema();

    @Override
    @NotNull
    default public OraModSchema getDbParent() {
        OraModSchema oraModSchema = this.getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModCluster", "getDbParent"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModCluster> getParentFamily();

    @NotNull
    public ModPositioningNamingFamily<? extends OraModClusterColumn> getColumns();

    @NotNull
    public ModSingletonFamily<? extends OraModClusterIndex> getIndices();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModCluster", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModCluster", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setTablespaceName(@Nullable String var1);

    public void setClusterType(@Nullable ClusterType var1);

    public void setSingleTable(boolean var1);

    public void setBlockSize(int var1);

    public void setHashExpression(@Nullable String var1);

    public void setHashCardinality(int var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModCluster", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String tablespaceName = properties.get("TablespaceName");
        String clusterType = properties.get("ClusterType");
        String singleTable = properties.get("SingleTable");
        String blockSize = properties.get("BlockSize");
        String hashExpression = properties.get("HashExpression");
        String hashCardinality = properties.get("HashCardinality");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (tablespaceName != null) {
            this.setTablespaceName(PropertyConverter.importString(tablespaceName));
        }
        if (clusterType != null) {
            this.setClusterType(PropertyConverter.importClusterType(clusterType));
        }
        if (singleTable != null) {
            this.setSingleTable(PropertyConverter.importBoolean(singleTable));
        }
        if (blockSize != null) {
            this.setBlockSize(PropertyConverter.importInt(blockSize));
        }
        if (hashExpression != null) {
            this.setHashExpression(PropertyConverter.importString(hashExpression));
        }
        if (hashCardinality != null) {
            this.setHashCardinality(PropertyConverter.importInt(hashCardinality));
        }
    }
}

