/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraObjectType;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSynonym;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraSchema
extends BasicSchema,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSchema", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public OraRoot getRoot();

    @Override
    @Nullable
    default public OraRoot getDbParent() {
        return this.getRoot();
    }

    @Override
    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraSequence> getSequences();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraCluster> getClusters();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraTable> getTables();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraView> getViews();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraMatView> getMatViews();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraPackage> getPackages();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraObjectType> getObjectTypes();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraCollectionType> getCollectionTypes();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraSingleRoutine> getRoutines();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraSynonym> getSynonyms();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SEQUENCE, ObjectKind.CLUSTER, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.PACKAGE, ObjectKind.OBJECT_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.ROUTINE, ObjectKind.SYNONYM);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSchema", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSequences(), this.getClusters(), this.getTables(), this.getViews(), this.getMatViews(), this.getPackages(), this.getObjectTypes(), this.getCollectionTypes(), this.getRoutines(), this.getSynonyms());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getSequences()).append(this.getClusters()).append(this.getTables()).append(this.getViews()).append(this.getMatViews()).append(this.getPackages()).append(this.getObjectTypes()).append(this.getCollectionTypes()).append(this.getRoutines()).append(this.getSynonyms());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSchema", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    default public long getCommentsHash() {
        return 0L;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean visible;
        boolean current;
        long commentsHash;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Date introspectionTimestamp;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraSchema", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((commentsHash = this.getCommentsHash()) != 0L) {
            consumer.accept("CommentsHash", PropertyConverter.export(commentsHash));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "Comment", "IntrospectionTimestamp", "CreatedTimestamp", "ModifiedTimestamp", "CommentsHash", "Current", "Visible");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSchema", "getPropertyNames"));
        }
        return list;
    }
}

