/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"ancestors", "", "Lcom/intellij/database/model/postgres/PostgresTable;", "getAncestors", "(Lcom/intellij/database/model/postgres/PostgresTable;)Ljava/util/List;", "callRoutine", "Lcom/intellij/database/model/postgres/PostgresRoutine;", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "getCallRoutine", "(Lcom/intellij/database/model/postgres/PostgresTrigger;)Lcom/intellij/database/model/postgres/PostgresRoutine;", "callRoutineName", "", "getCallRoutineName", "(Lcom/intellij/database/model/postgres/PostgresTrigger;)Ljava/lang/String;", "successors", "", "getSuccessors", "(Lcom/intellij/database/model/postgres/PostgresTable;)Ljava/util/Set;", "database-model-api"})
@JvmName(name="PostgresModelFun")
public final class PostgresModelFun {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PostgresTable> getAncestors(@NotNull PostgresTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Long> ancestorIds = $receiver.getAncestorIds();
        if (ancestorIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return CollectionsKt.emptyList();
        }
        PostgresSchema schema = postgresSchema;
        Iterable $receiver$iv = ancestorIds;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            NamingIdentifyingFamily<? extends PostgresTable> namingIdentifyingFamily = schema.getTables();
            void v2 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"id");
            PostgresTable postgresTable = (PostgresTable)namingIdentifyingFamily.getByObjectId(v2.longValue());
            collection.add(postgresTable);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PostgresTable> getSuccessors(@NotNull PostgresTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Long> successorIds = $receiver.getSuccessorIds();
        if (successorIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return SetsKt.emptySet();
        }
        PostgresSchema schema = postgresSchema;
        Iterable $receiver$iv = successorIds;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            NamingIdentifyingFamily<? extends PostgresTable> namingIdentifyingFamily = schema.getTables();
            void v2 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"id");
            PostgresTable postgresTable = (PostgresTable)namingIdentifyingFamily.getByObjectId(v2.longValue());
            collection.add(postgresTable);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public static final PostgresRoutine getCallRoutine(@NotNull PostgresTrigger $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long id = $receiver.getCallRoutineId();
        if (id == 0L) {
            return null;
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return null;
        }
        PostgresSchema schema = postgresSchema;
        return (PostgresRoutine)schema.getRoutines().getByObjectId(id);
    }

    @Nullable
    public static final String getCallRoutineName(@NotNull PostgresTrigger $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long id = $receiver.getCallRoutineId();
        if (id == 0L) {
            return null;
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return null;
        }
        PostgresSchema schema = postgresSchema;
        PostgresRoutine postgresRoutine = (PostgresRoutine)schema.getRoutines().getByObjectId(id);
        return postgresRoutine != null ? postgresRoutine.getName() : null;
    }
}

