/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sybase.SybaseIndex;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseModIndex
extends SybaseIndex,
BasicModNamedElement,
BasicModIndex,
BasicModArrangedElement {
    @Override
    @NotNull
    public SybaseModTable getTable();

    @Override
    @NotNull
    default public SybaseModTable getDbParent() {
        SybaseModTable sybaseModTable = this.getTable();
        if (sybaseModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModIndex", "getDbParent"));
        }
        return sybaseModTable;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SybaseModIndex> getParentFamily();

    @Override
    @NotNull
    default public SybaseModSchema getSchema() {
        SybaseModSchema sybaseModSchema = this.getTable().getSchema();
        if (sybaseModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModIndex", "getSchema"));
        }
        return sybaseModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModIndex", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModIndex", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setReverseColNames(@NotNull Set<String> var1);

    public void setClustering(boolean var1);

    @Override
    public void setUnique(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sybase/SybaseModIndex", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String reverseColNames = properties.get("ReverseColNames");
        String clustering = properties.get("Clustering");
        String unique = properties.get("Unique");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (reverseColNames != null) {
            this.setReverseColNames(PropertyConverter.importSetOfString(reverseColNames));
        }
        if (clustering != null) {
            this.setClustering(PropertyConverter.importBoolean(clustering));
        }
        if (unique != null) {
            this.setUnique(PropertyConverter.importBoolean(unique));
        }
    }
}

