/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dataSource.srcStorage.DbSrcMapping;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbFindUsagesOptionsProvider;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbFindUsagesHandlerFactory", "canFindUsages"));
        }
        return element instanceof DbElement;
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement psiElement, boolean forHighlightUsages) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/database/psi/DbFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (!(psiElement instanceof DbElement)) {
            return null;
        }
        return new FindUsagesHandler(psiElement){

            @NotNull
            public PsiElement[] getSecondaryElements() {
                DbElement dbElement = (DbElement)this.getPsiElement();
                if (DbSrcStorage.isEnabled()) {
                    List src = ContainerUtil.newSmartList();
                    DbSrcMapping.getInstance().processSources(dbElement, (Consumer<PsiElement>)((Consumer)src::add));
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)src);
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbFindUsagesHandlerFactory$1", "getSecondaryElements"));
                    }
                    return psiElementArray;
                }
                PsiElement psi = (PsiElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), PsiElement.class);
                if (psi != null && psi.isValid()) {
                    PsiElement[] psiElementArray = new PsiElement[]{psi};
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbFindUsagesHandlerFactory$1", "getSecondaryElements"));
                    }
                    return psiElementArray;
                }
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbFindUsagesHandlerFactory$1", "getSecondaryElements"));
                }
                return PsiElement.EMPTY_ARRAY;
            }

            protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/database/psi/DbFindUsagesHandlerFactory$1", "isSearchForTextOccurrencesAvailable"));
                }
                return true;
            }

            @NotNull
            public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
                FindUsagesOptions findUsagesOptions = DbFindUsagesOptionsProvider.getInstance(this.getProject()).getFindUsagesOptions();
                if (findUsagesOptions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbFindUsagesHandlerFactory$1", "getFindUsagesOptions"));
                }
                return findUsagesOptions;
            }
        };
    }
}

