/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GridTextCellEditorBase
extends GridCellEditor.Adapter
implements DataProvider {
    protected final DataGrid myGrid;
    protected final DataConsumer.Column myColumn;
    protected final GridCellEditorTextField myTextField;
    protected Object myValue;
    protected String myInitialText;

    protected GridTextCellEditorBase(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object value, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase", "<init>"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase", "<init>"));
        }
        this.myGrid = grid;
        this.myColumn = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column);
        this.myValue = value;
        this.myInitialText = this.getInitialText();
        TextCompletionProvider provider = GridCellEditorsUtil.createCompletionProvider(grid, column);
        this.myTextField = new MyGridCellEditorTextField(grid.getContentLanguage(column), initiator, this.myInitialText, this.getInitialBytes(), provider);
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase", "getComponent"));
        }
        return gridCellEditorTextField;
    }

    @Override
    @Nullable
    public Object getValue() {
        boolean valueChanged = this.isValueEditable() && (this.myInitialText == null || !this.myInitialText.equals(this.myTextField.getText()));
        return valueChanged ? this.myTextField.getText() : this.myValue;
    }

    @Override
    public boolean isMaximizationAllowed() {
        return true;
    }

    @Nullable
    protected String getInitialText() {
        if (this.myValue == null || this.myValue instanceof ReservedCellValue) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this.myGrid);
        return this.myGrid.getObjectFormatter().objectToString(this.myValue, this.myColumn, dialect, true);
    }

    @Nullable
    protected byte[] getInitialBytes() {
        return null;
    }

    protected abstract boolean isValueEditable();

    private class MyGridCellEditorTextField
    extends GridCellEditorTextField {
        public MyGridCellEditorTextField(Language language, EventObject initiator, String initialText, @Nullable byte[] initialBytes, TextCompletionProvider provider) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase$MyGridCellEditorTextField", "<init>"));
            }
            super(DataGridUtil.getProject(GridTextCellEditorBase.this.myGrid), GridTextCellEditorBase.this.myGrid, language, initialText, initialBytes, true, initiator, provider);
            this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    GridTextCellEditorBase.this.fireEditing(MyGridCellEditorTextField.this.getDocument().getText());
                }
            });
        }

        @Override
        public Object getData(String dataId) {
            Object fromCellEditor = GridTextCellEditorBase.this.getData(dataId);
            return fromCellEditor != null ? fromCellEditor : super.getData(dataId);
        }

        @Override
        protected boolean isEditable() {
            return super.isEditable() && GridTextCellEditorBase.this.isValueEditable();
        }
    }
}

