/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.oracle;

import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.TruncateTableOperation;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleTruncateTableOperation
extends TruncateTableOperation {
    public OracleTruncateTableOperation() {
        super(PURGE_MATERIALIZED_VIEW_LOG, DROP_STORAGE, USE_DELETE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/oracle/OracleTruncateTableOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/oracle/OracleTruncateTableOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/oracle/OracleTruncateTableOperation", "generate"));
        }
        Iterable values = (Iterable)OPTION_VALUES.get(data);
        if (OracleTruncateTableOperation.findOption(values, USE_DELETE) == Boolean.TRUE) {
            DdlBuilder ddlBuilder = super.generate(builder, object, data, context);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/oracle/OracleTruncateTableOperation", "generate"));
            }
            return ddlBuilder;
        }
        Boolean purgeMVL = (Boolean)OracleTruncateTableOperation.findOption(values, PURGE_MATERIALIZED_VIEW_LOG);
        Boolean dropStorage = (Boolean)OracleTruncateTableOperation.findOption(values, DROP_STORAGE);
        builder.keywords("TRUNCATE", "TABLE").space().qualifiedRef(object);
        if (purgeMVL != null) {
            builder.newLine().tab().keywords(purgeMVL != false ? "PURGE" : "PRESERVE", "MATERIALIZED", "VIEW", "LOG");
        }
        if (dropStorage != null) {
            builder.newLine().tab().keywords(dropStorage != false ? "DROP" : "REUSE", "STORAGE");
        }
        DdlBuilder ddlBuilder = builder.newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/oracle/OracleTruncateTableOperation", "generate"));
        }
        return ddlBuilder;
    }
}

