/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.psi.BasicDbPsiManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SidePanelItem<Represented, RepConfigurable extends Configurable> {
    private static final String ELEMENT = "element";
    private Place myPlace;
    @NotNull
    private final Represented myRepresented;
    private RepConfigurable myConfigurable;
    private JComponent myComponent;
    private JComponent myResetComponent;
    private Boolean myModifiedCache;
    protected DatabaseConfigEditorImpl myEditor;
    private DataSourceProblem myDataSourceProblem;

    public SidePanelItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull Represented represented) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/SidePanelItem", "<init>"));
        }
        if (represented == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "represented", "com/intellij/database/view/ui/SidePanelItem", "<init>"));
        }
        this.myEditor = editor;
        this.myRepresented = represented;
    }

    private static Place createPlaceFor(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/SidePanelItem", "createPlaceFor"));
        }
        return SidePanelItem.setItem(new Place(), item);
    }

    @NotNull
    public static Place setItem(@NotNull Place place, @Nullable SidePanelItem item) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/SidePanelItem", "setItem"));
        }
        Place place2 = place.putPath(ELEMENT, (Object)item);
        if (place2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem", "setItem"));
        }
        return place2;
    }

    @Nullable
    public static SidePanelItem getItem(@Nullable Place place) {
        return place == null ? null : (SidePanelItem)place.getPath(ELEMENT);
    }

    @Nullable
    public static Object getObject(@Nullable SidePanelItem item) {
        return item == null ? null : item.getObject();
    }

    @NotNull
    public JComponent getResetComponent() {
        if (this.myResetComponent == null) {
            this.myResetComponent = new SwingActionLink((Action)new AbstractAction("Reset"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SidePanelItem.this.reset();
                }
            });
        }
        JComponent jComponent = this.myResetComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem", "getResetComponent"));
        }
        return jComponent;
    }

    protected void preReset() {
    }

    protected void reset() {
        if (this.getConfigurable() != null) {
            this.preReset();
            this.getConfigurable().reset();
        }
        this.resetModifiedCache();
    }

    protected boolean isResetEnabled() {
        return this.isModified();
    }

    public void updateResetComponent() {
        if (this.myResetComponent != null) {
            this.myResetComponent.setVisible(this.isResetEnabled());
        }
    }

    @Nullable
    public Place getPlace() {
        return this.myPlace;
    }

    @NotNull
    public Place createPlace() {
        if (this.myPlace == null) {
            this.myPlace = SidePanelItem.createPlaceFor(this);
        }
        Place place = this.myPlace;
        if (place == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem", "createPlace"));
        }
        return place;
    }

    @NotNull
    public Represented getObject() {
        Represented Represented = this.myRepresented;
        if (Represented == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem", "getObject"));
        }
        return Represented;
    }

    @Nullable
    public RepConfigurable getConfigurable() {
        return this.myConfigurable;
    }

    @Nullable
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public RepConfigurable createConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = this.createConfigurableImpl();
            this.myComponent = this.myConfigurable.createComponent();
            this.myConfigurable.reset();
            this.updateResetComponent();
        }
        RepConfigurable RepConfigurable = this.myConfigurable;
        if (RepConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem", "createConfigurable"));
        }
        return RepConfigurable;
    }

    @NotNull
    public abstract RepConfigurable createConfigurableImpl();

    public void removeConfigurable() {
        if (this.myConfigurable == null) {
            return;
        }
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        this.myComponent = null;
    }

    public void resetModifiedCache() {
        this.myModifiedCache = null;
        this.updateResetComponent();
    }

    public boolean isModified() {
        if (this.myConfigurable == null) {
            return false;
        }
        if (this.myModifiedCache == null) {
            this.myModifiedCache = this.myConfigurable.isModified();
        }
        return this.myModifiedCache;
    }

    public abstract boolean accept(@NotNull ItemsVisitor var1);

    public abstract String getName();

    public DataSourceProblem getDataSourceProblem() {
        return this.myDataSourceProblem;
    }

    public void setDataSourceProblem(DataSourceProblem dataSourceProblem) {
        this.myDataSourceProblem = dataSourceProblem;
    }

    public abstract void apply() throws ConfigurationException;

    static class ItemsVisitor
    implements Processor<SidePanelItem> {
        ItemsVisitor() {
        }

        boolean visit(DataSourceItem dataSourceItem) {
            return true;
        }

        boolean visit(DriverItem driverItem) {
            return true;
        }

        boolean visit(ErrorsItem errorItem) {
            return true;
        }

        public boolean process(SidePanelItem item) {
            return item.accept(this);
        }
    }

    static class ErrorsItem
    extends SidePanelItem<DataSourceErrorsConfigurable, DataSourceErrorsConfigurable> {
        public ErrorsItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull DataSourceErrorsConfigurable source) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/SidePanelItem$ErrorsItem", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/SidePanelItem$ErrorsItem", "<init>"));
            }
            super(editor, source);
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/view/ui/SidePanelItem$ErrorsItem", "accept"));
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? "Problems" : ((DataSourceErrorsConfigurable)this.getConfigurable()).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
        }

        @Override
        @NotNull
        public DataSourceErrorsConfigurable createConfigurableImpl() {
            DataSourceErrorsConfigurable dataSourceErrorsConfigurable = (DataSourceErrorsConfigurable)this.getObject();
            if (dataSourceErrorsConfigurable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem$ErrorsItem", "createConfigurableImpl"));
            }
            return dataSourceErrorsConfigurable;
        }

        @Override
        public void removeConfigurable() {
        }
    }

    static class DriverItem
    extends SidePanelItem<DatabaseDriver, DatabaseDriverConfigurable>
    implements DataSourceProblemsProvider {
        public DriverItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull DatabaseDriver source) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/SidePanelItem$DriverItem", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/SidePanelItem$DriverItem", "<init>"));
            }
            super(editor, source);
        }

        @Override
        protected void reset() {
            super.reset();
            if (this.getConfigurable() != null) {
                this.myEditor.updateDriverDependants(((DatabaseDriverConfigurable)((Object)this.getConfigurable())).getTempDriver());
            }
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/view/ui/SidePanelItem$DriverItem", "accept"));
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DatabaseDriver)this.getObject()).getName() : ((DatabaseDriverConfigurable)((Object)this.getConfigurable())).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((DatabaseDriverConfigurable)((Object)this.getConfigurable())).apply();
            } else if (this.isNew()) {
                DatabaseDriverManager.getInstance().updateDriver((DatabaseDriver)this.getObject());
            }
        }

        private boolean isNew() {
            return !DatabaseDriverManager.getInstance().getDrivers().contains(this.getObject());
        }

        @Override
        @NotNull
        public DatabaseDriverConfigurable createConfigurableImpl() {
            DatabaseDriverConfigurable databaseDriverConfigurable = new DatabaseDriverConfigurable(this.myEditor.getSettings().getProject(), (DatabaseDriverImpl)this.getObject(), this.myEditor);
            if (databaseDriverConfigurable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem$DriverItem", "createConfigurableImpl"));
            }
            return databaseDriverConfigurable;
        }

        @Override
        public Set<DataSourceProblem> getErrors() {
            DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)this.getConfigurable());
            return DatabaseConfigValidator.getProblems(configurable == null ? this.getObject() : configurable.getTempDriver(), this.myEditor);
        }
    }

    static class DataSourceItem
    extends SidePanelItem<DbDataSource, AbstractDataSourceConfigurable>
    implements DataSourceProblemsProvider {
        public DataSourceItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull DbDataSource source) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/SidePanelItem$DataSourceItem", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/SidePanelItem$DataSourceItem", "<init>"));
            }
            super(editor, source);
        }

        @Override
        protected void preReset() {
            LocalDataSource localDataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)((DbDataSource)this.getObject()).getDelegate(), LocalDataSource.class));
            if (localDataSource != null) {
                this.myEditor.resurrectDriver(localDataSource.getDatabaseDriver());
            }
        }

        @Nullable
        public LocalDataSource extractActualLocalDataSource() {
            LocalDataSource actual = this.getConfigurable() == null ? null : (LocalDataSource)((Object)ObjectUtils.tryCast(((AbstractDataSourceConfigurable)((Object)this.getConfigurable())).getTempDataSource(), LocalDataSource.class));
            return actual == null ? (LocalDataSource)((Object)ObjectUtils.tryCast((Object)((DbDataSource)this.getObject()).getDelegate(), LocalDataSource.class)) : actual;
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/view/ui/SidePanelItem$DataSourceItem", "accept"));
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DbDataSource)this.getObject()).getName() : ((AbstractDataSourceConfigurable)((Object)this.getConfigurable())).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((AbstractDataSourceConfigurable)((Object)this.getConfigurable())).apply();
            } else if (this.isNew()) {
                ((BasicDbPsiManager)((DbDataSource)this.getObject()).getDbManager()).addDataSource(((DbDataSource)this.getObject()).getDelegate());
            }
            ((DbDataSource)this.getObject()).clearCaches();
        }

        private boolean isNew() {
            DbPsiManager manager = ((DbDataSource)this.getObject()).getDbManager();
            return !manager.getDataSources().contains(this.getObject());
        }

        public boolean isGlobal() {
            DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast(this.getConfigurable(), DataSourceConfigurable.class));
            if (configurable != null) {
                return configurable.getTempDataSource().isGlobal();
            }
            LocalDataSource localDataSource = this.extractActualLocalDataSource();
            return localDataSource != null && localDataSource.isGlobal();
        }

        public boolean isImported() {
            LocalDataSource localDataSource = this.extractActualLocalDataSource();
            return localDataSource != null && localDataSource.isImported();
        }

        @Override
        @NotNull
        public AbstractDataSourceConfigurable createConfigurableImpl() {
            DbPsiManager dbManager = ((DbDataSource)this.getObject()).getDbManager();
            AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)dbManager.createDataSourceEditor((DbDataSource)this.getObject());
            configurable.setController(this.myEditor);
            AbstractDataSourceConfigurable abstractDataSourceConfigurable = configurable;
            if (abstractDataSourceConfigurable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/SidePanelItem$DataSourceItem", "createConfigurableImpl"));
            }
            return abstractDataSourceConfigurable;
        }

        @Override
        public Set<DataSourceProblem> getErrors() {
            AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)this.getConfigurable());
            return DatabaseConfigValidator.getProblems(configurable == null ? ((DbDataSource)this.getObject()).getDelegate() : configurable.getTempDataSource(), this.myEditor);
        }
    }
}

