/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntrospectionScope
implements Serializable {
    protected static final String SPLIT = ":";
    private static final String[] escapeChars = new String[]{"\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", " ", ",", ";", "<", ">", "'", "\"", "|", "\\"};
    private static final String[] escapedChars = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\u0008", "\\u0009", "\\u000A", "\\u000B", "\\u000C", "\\u000D", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F", "\\u0020", "\\u002C", "\\u003B", "\\u003C", "\\u003E", "\\u0027", "\\u0022", "\\u007C", "\\u005C"};
    private static final Set<String> ALL_NAMESPACES_SET = Collections.singleton("*");
    private static final Set<String> EMPTY_NAMESPACES_SET = Collections.emptySet();

    @NotNull
    public abstract Set<String> databases();

    public abstract boolean containsDatabase(@NotNull String var1);

    @NotNull
    public abstract Set<String> schemas(@NotNull String var1);

    @NotNull
    public abstract Set<String> allSchemas();

    public abstract boolean containsSchema(@NotNull String var1, @NotNull String var2);

    public boolean containsSchema(@Nullable Couple<String> couple) {
        return couple != null && this.containsSchema((String)couple.first, (String)couple.second);
    }

    public abstract int weight();

    public abstract boolean isResolved();

    @NotNull
    public abstract IntrospectionScope resolveCurrentDatabase(@NotNull String var1);

    @NotNull
    public abstract IntrospectionScope removeCurrentDatabase();

    @NotNull
    public IntrospectionScope intersect(@NotNull IntrospectionScope that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/dbm/common/IntrospectionScope", "intersect"));
        }
        IntrospectionScope introspectionScope = this.weight() <= that.weight() ? this.intersectWith(that) : that.intersectWith(this);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "intersect"));
        }
        return introspectionScope;
    }

    abstract IntrospectionScope intersectWith(@NotNull IntrospectionScope var1);

    public boolean isEmpty() {
        return this.databases().isEmpty();
    }

    private static boolean contains(@Nullable Collection<String> schemas2, @NotNull String schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScope", "contains"));
        }
        return schemas2 != null && (schemas2.contains(schema) || schemas2.contains("*"));
    }

    @NotNull
    public String exportState() {
        StringBuilder b = new StringBuilder();
        ArrayList databases = ContainerUtil.newArrayList(this.databases());
        Collections.sort(databases);
        for (String database : databases) {
            b.append(IntrospectionScope.escape(database)).append(SPLIT);
            ArrayList schemas2 = ContainerUtil.newArrayList(this.schemas(database));
            Collections.sort(schemas2);
            boolean was = false;
            for (String schema : schemas2) {
                if (was) {
                    b.append(',');
                } else {
                    was = true;
                }
                b.append(IntrospectionScope.escape(schema));
            }
            b.append('|');
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "exportState"));
        }
        return string;
    }

    public String toString() {
        return this.exportState();
    }

    @NotNull
    @Contract(pure=true)
    static IntrospectionScope importState(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/dbm/common/IntrospectionScope", "importState"));
        }
        int n = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String[] bunches = string.split("\\|");
        String database = null;
        ImmutableSet schemas2 = null;
        boolean hasWildcards = false;
        for (String bunch : bunches) {
            String[] pair = bunch.split(SPLIT, 2);
            if (pair.length < 2) continue;
            database = IntrospectionScope.unescape(pair[0]);
            hasWildcards |= IntrospectionScope.isWildcard(database);
            String[] schemasEntries = StringUtil.isEmpty((String)pair[1]) ? ArrayUtil.EMPTY_STRING_ARRAY : pair[1].split(",");
            TreeSet<String> schemasBuf = new TreeSet<String>();
            for (String schemaEntry : schemasEntries) {
                schemasBuf.add(IntrospectionScope.unescape(schemaEntry));
            }
            schemas2 = ImmutableSet.copyOf(schemasBuf);
            hasWildcards |= IntrospectionScope.containsWildcards((Collection<String>)schemas2);
            builder.put((Object)database, (Object)schemas2);
            ++n;
        }
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("Invalid scope string here: " + string);
            }
            case 1: {
                SingleDBScope singleDBScope = new SingleDBScope(database, schemas2, !hasWildcards);
                if (singleDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "importState"));
                }
                return singleDBScope;
            }
        }
        MultiDBScope multiDBScope = new MultiDBScope((ImmutableMap<String, ImmutableSet<String>>)builder.build(), !hasWildcards);
        if (multiDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "importState"));
        }
        return multiDBScope;
    }

    @Contract(pure=true)
    private static String escape(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/dbm/common/IntrospectionScope", "escape"));
        }
        return StringUtil.replace((String)string, (String[])escapeChars, (String[])escapedChars);
    }

    @Contract(pure=true)
    private static String unescape(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/dbm/common/IntrospectionScope", "unescape"));
        }
        return StringUtil.replaceUnicodeEscapeSequences((String)string);
    }

    @Contract(pure=true)
    static boolean isWildcard(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/IntrospectionScope", "isWildcard"));
        }
        return name.equals("@") || name.equals("*");
    }

    @Contract(pure=true)
    static boolean containsWildcards(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/IntrospectionScope", "containsWildcards"));
        }
        return names.contains("@") || names.contains("*");
    }

    @NotNull
    public List<Couple<String>> asList() {
        LinkedList result = ContainerUtil.newLinkedList();
        for (String d : this.databases()) {
            for (String s : this.schemas(d)) {
                result.add(Couple.of((Object)d, (Object)s));
            }
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "asList"));
        }
        return linkedList;
    }

    @NotNull
    public MultiMap<String, String> to(MultiMap<String, String> map) {
        for (String db : this.databases()) {
            Collection scs = map.getModifiable((Object)db);
            scs.addAll(this.schemas(db));
        }
        MultiMap<String, String> multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "to"));
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> applyToContext(@NotNull MultiMap<String, String> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/dbm/common/IntrospectionScope", "applyToContext"));
        }
        MultiMap result = new MultiMap();
        for (String d : context.keySet()) {
            for (String s : context.get((Object)d)) {
                if (!this.containsSchema(d, s)) continue;
                result.putValue((Object)d, (Object)s);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope", "applyToContext"));
        }
        return multiMap;
    }

    static final class EmptyScope
    extends IntrospectionScope {
        EmptyScope() {
        }

        @Override
        @NotNull
        public Set<String> databases() {
            Set set = EMPTY_NAMESPACES_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "databases"));
            }
            return set;
        }

        @Override
        public boolean containsDatabase(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "containsDatabase"));
            }
            return false;
        }

        @Override
        @NotNull
        public Set<String> schemas(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "schemas"));
            }
            Set set = EMPTY_NAMESPACES_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "schemas"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<String> allSchemas() {
            Set set = EMPTY_NAMESPACES_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "allSchemas"));
            }
            return set;
        }

        @Override
        public boolean containsSchema(@NotNull String database, @NotNull String schema) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "containsSchema"));
            }
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "containsSchema"));
            }
            return false;
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        public int weight() {
            return 0;
        }

        @Override
        @NotNull
        public IntrospectionScope resolveCurrentDatabase(@NotNull String currentDatabaseName) {
            if (currentDatabaseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDatabaseName", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "resolveCurrentDatabase"));
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "resolveCurrentDatabase"));
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public IntrospectionScope removeCurrentDatabase() {
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "removeCurrentDatabase"));
            }
            return emptyScope;
        }

        @Override
        IntrospectionScope intersectWith(@NotNull IntrospectionScope that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "intersectWith"));
            }
            return this;
        }

        @Override
        @NotNull
        public String exportState() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$EmptyScope", "exportState"));
            }
            return "";
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "(empty)";
        }
    }

    static final class AllScope
    extends IntrospectionScope {
        AllScope() {
        }

        @Override
        @NotNull
        public Set<String> databases() {
            Set set = ALL_NAMESPACES_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$AllScope", "databases"));
            }
            return set;
        }

        @Override
        public boolean containsDatabase(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$AllScope", "containsDatabase"));
            }
            return true;
        }

        @Override
        @NotNull
        public Set<String> schemas(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$AllScope", "schemas"));
            }
            Set set = database.equals("*") ? ALL_NAMESPACES_SET : EMPTY_NAMESPACES_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$AllScope", "schemas"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<String> allSchemas() {
            Set set = ALL_NAMESPACES_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$AllScope", "allSchemas"));
            }
            return set;
        }

        @Override
        public boolean containsSchema(@NotNull String database, @NotNull String schema) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$AllScope", "containsSchema"));
            }
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScope$AllScope", "containsSchema"));
            }
            return true;
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        public int weight() {
            return Integer.MAX_VALUE;
        }

        @Override
        @NotNull
        public IntrospectionScope resolveCurrentDatabase(@NotNull String currentDatabaseName) {
            if (currentDatabaseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDatabaseName", "com/intellij/dbm/common/IntrospectionScope$AllScope", "resolveCurrentDatabase"));
            }
            AllScope allScope = this;
            if (allScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$AllScope", "resolveCurrentDatabase"));
            }
            return allScope;
        }

        @Override
        @NotNull
        public IntrospectionScope removeCurrentDatabase() {
            AllScope allScope = this;
            if (allScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$AllScope", "removeCurrentDatabase"));
            }
            return allScope;
        }

        @Override
        IntrospectionScope intersectWith(@NotNull IntrospectionScope that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/dbm/common/IntrospectionScope$AllScope", "intersectWith"));
            }
            return that;
        }

        @Override
        @NotNull
        public String exportState() {
            if ("*" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$AllScope", "exportState"));
            }
            return "*";
        }

        @Override
        public String toString() {
            return "*.*";
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    }

    static final class MultiDBScope
    extends IntrospectionScope {
        @NotNull
        private final ImmutableMap<String, ImmutableSet<String>> myDatabasesAndSchemas;
        private final boolean myResolved;

        public MultiDBScope(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas, boolean resolved) {
            if (databasesAndSchemas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "<init>"));
            }
            this.myDatabasesAndSchemas = databasesAndSchemas;
            this.myResolved = resolved;
        }

        @Override
        @NotNull
        public Set<String> databases() {
            ImmutableSet immutableSet = this.myDatabasesAndSchemas.keySet();
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "databases"));
            }
            return immutableSet;
        }

        @Override
        public boolean containsDatabase(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "containsDatabase"));
            }
            return this.myDatabasesAndSchemas.containsKey((Object)database);
        }

        @Override
        @NotNull
        public Set<String> schemas(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "schemas"));
            }
            ImmutableSet schemas2 = (ImmutableSet)this.myDatabasesAndSchemas.get((Object)database);
            Object object = schemas2 != null ? schemas2 : EMPTY_NAMESPACES_SET;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "schemas"));
            }
            return object;
        }

        @Override
        @NotNull
        public Set<String> allSchemas() {
            TreeSet<String> allSchemas = new TreeSet<String>();
            for (Set schemas2 : this.myDatabasesAndSchemas.values()) {
                allSchemas.addAll(schemas2);
            }
            TreeSet<String> treeSet = allSchemas;
            if (treeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "allSchemas"));
            }
            return treeSet;
        }

        @Override
        public boolean containsSchema(@NotNull String database, @NotNull String schema) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "containsSchema"));
            }
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "containsSchema"));
            }
            return IntrospectionScope.contains((Collection)this.myDatabasesAndSchemas.get((Object)database), schema) || IntrospectionScope.contains((Collection)this.myDatabasesAndSchemas.get((Object)"*"), schema);
        }

        @Override
        public boolean isResolved() {
            return this.myResolved;
        }

        @Override
        public int weight() {
            return this.myDatabasesAndSchemas.size();
        }

        @Override
        @NotNull
        public IntrospectionScope resolveCurrentDatabase(@NotNull String currentDatabaseName) {
            if (currentDatabaseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDatabaseName", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "resolveCurrentDatabase"));
            }
            if (this.myResolved) {
                MultiDBScope multiDBScope = this;
                if (multiDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "resolveCurrentDatabase"));
                }
                return multiDBScope;
            }
            ImmutableSet currentDatabaseSchemas1 = (ImmutableSet)this.myDatabasesAndSchemas.get((Object)"@");
            if (currentDatabaseSchemas1 == null) {
                MultiDBScope multiDBScope = this;
                if (multiDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "resolveCurrentDatabase"));
                }
                return multiDBScope;
            }
            ImmutableSet currentDatabaseSchemas2 = (ImmutableSet)this.myDatabasesAndSchemas.get((Object)currentDatabaseName);
            TreeSet currentDatabaseSchemas = new TreeSet(currentDatabaseSchemas2);
            currentDatabaseSchemas.addAll(currentDatabaseSchemas1);
            ImmutableSet currentDatabaseSchemasImmutable = ImmutableSet.copyOf(currentDatabaseSchemas);
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.put((Object)currentDatabaseName, (Object)currentDatabaseSchemasImmutable);
            boolean somethingElse = false;
            for (Map.Entry e : this.myDatabasesAndSchemas.entrySet()) {
                String database = (String)e.getKey();
                ImmutableSet schemas2 = (ImmutableSet)e.getValue();
                if (database.equals("@") || database.equals(currentDatabaseName)) continue;
                b.put((Object)database, (Object)schemas2);
                somethingElse = true;
            }
            IntrospectionScope introspectionScope = somethingElse ? IntrospectionScopes.scopeOf((ImmutableMap<String, ImmutableSet<String>>)b.build()) : IntrospectionScopes.scopeOf(currentDatabaseName, (Collection<String>)currentDatabaseSchemasImmutable);
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "resolveCurrentDatabase"));
            }
            return introspectionScope;
        }

        @Override
        @NotNull
        public IntrospectionScope removeCurrentDatabase() {
            if (this.myResolved) {
                MultiDBScope multiDBScope = this;
                if (multiDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "removeCurrentDatabase"));
                }
                return multiDBScope;
            }
            ImmutableMap.Builder b = ImmutableMap.builder();
            int n = 0;
            String database = null;
            ImmutableSet schemas2 = null;
            for (Map.Entry e : this.myDatabasesAndSchemas.entrySet()) {
                if (((String)e.getKey()).equals("@")) continue;
                database = (String)e.getKey();
                schemas2 = (ImmutableSet)e.getValue();
                b.put((Object)database, (Object)schemas2);
                ++n;
            }
            IntrospectionScope introspectionScope = MultiDBScope.makeResultScope(n, database, schemas2, (ImmutableMap.Builder<String, ImmutableSet<String>>)b);
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "removeCurrentDatabase"));
            }
            return introspectionScope;
        }

        @Override
        IntrospectionScope intersectWith(@NotNull IntrospectionScope that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "intersectWith"));
            }
            if (that instanceof AllScope) {
                return this;
            }
            int n = 0;
            String lastDatabase = null;
            ImmutableSet lastSchemas = null;
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (String database : this.myDatabasesAndSchemas.keySet()) {
                if (!that.containsDatabase(database)) continue;
                TreeSet schemas2 = new TreeSet();
                schemas2.addAll((Collection)this.myDatabasesAndSchemas.get((Object)database));
                schemas2.retainAll(that.schemas(database));
                if (schemas2.isEmpty()) continue;
                ++n;
                lastDatabase = database;
                lastSchemas = ImmutableSet.copyOf(schemas2);
                b.put((Object)lastDatabase, (Object)lastSchemas);
            }
            return MultiDBScope.makeResultScope(n, lastDatabase, lastSchemas, (ImmutableMap.Builder<String, ImmutableSet<String>>)b);
        }

        @NotNull
        private static IntrospectionScope makeResultScope(int n, String database, ImmutableSet<String> schemas2, ImmutableMap.Builder<String, ImmutableSet<String>> b) {
            switch (n) {
                case 0: {
                    IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfNothing();
                    if (introspectionScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "makeResultScope"));
                    }
                    return introspectionScope;
                }
                case 1: {
                    assert (database != null);
                    assert (schemas2 != null);
                    IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(database, schemas2);
                    if (introspectionScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "makeResultScope"));
                    }
                    return introspectionScope;
                }
            }
            IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf((ImmutableMap<String, ImmutableSet<String>>)b.build());
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$MultiDBScope", "makeResultScope"));
            }
            return introspectionScope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiDBScope that = (MultiDBScope)o;
            return this.myDatabasesAndSchemas.equals(that.myDatabasesAndSchemas);
        }

        public int hashCode() {
            return this.myDatabasesAndSchemas.hashCode();
        }
    }

    static final class SingleDBScope
    extends IntrospectionScope {
        @NotNull
        private final String myDatabase;
        @NotNull
        private final ImmutableSet<String> mySchemas;
        private final boolean myResolved;

        SingleDBScope(@NotNull String database, @NotNull ImmutableSet<String> schemas2, boolean resolved) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "<init>"));
            }
            if (schemas2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "<init>"));
            }
            this.myDatabase = database;
            this.mySchemas = schemas2;
            this.myResolved = resolved;
        }

        @Override
        @NotNull
        public Set<String> databases() {
            Set<String> set = Collections.singleton(this.myDatabase);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "databases"));
            }
            return set;
        }

        @Override
        public boolean containsDatabase(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "containsDatabase"));
            }
            return this.myDatabase.equals(database) || this.myDatabase.equals("*");
        }

        @Override
        @NotNull
        public Set<String> schemas(@NotNull String database) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "schemas"));
            }
            ImmutableSet<String> immutableSet = this.myDatabase.equals(database) ? this.mySchemas : EMPTY_NAMESPACES_SET;
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "schemas"));
            }
            return immutableSet;
        }

        @Override
        @NotNull
        public Set<String> allSchemas() {
            ImmutableSet<String> immutableSet = this.mySchemas;
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "allSchemas"));
            }
            return immutableSet;
        }

        @Override
        public boolean containsSchema(@NotNull String database, @NotNull String schema) {
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "containsSchema"));
            }
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "containsSchema"));
            }
            return (this.myDatabase.equals(database) || this.myDatabase.equals("*")) && IntrospectionScope.contains(this.mySchemas, schema);
        }

        @Override
        public boolean isResolved() {
            return this.myResolved;
        }

        @Override
        public int weight() {
            return 1;
        }

        @Override
        @NotNull
        public IntrospectionScope resolveCurrentDatabase(@NotNull String currentDatabaseName) {
            if (currentDatabaseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDatabaseName", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "resolveCurrentDatabase"));
            }
            if (this.myDatabase.equals("@")) {
                assert (!currentDatabaseName.equals("@"));
                assert (!currentDatabaseName.equals("*"));
                SingleDBScope singleDBScope = new SingleDBScope(currentDatabaseName, this.mySchemas, !SingleDBScope.containsWildcards(this.mySchemas));
                if (singleDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "resolveCurrentDatabase"));
                }
                return singleDBScope;
            }
            SingleDBScope singleDBScope = this;
            if (singleDBScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "resolveCurrentDatabase"));
            }
            return singleDBScope;
        }

        @Override
        @NotNull
        public IntrospectionScope removeCurrentDatabase() {
            if (this.myDatabase.equals("@")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfNothing();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "removeCurrentDatabase"));
                }
                return introspectionScope;
            }
            SingleDBScope singleDBScope = this;
            if (singleDBScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "removeCurrentDatabase"));
            }
            return singleDBScope;
        }

        @Override
        @NotNull
        public IntrospectionScope intersectWith(@NotNull IntrospectionScope that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "intersectWith"));
            }
            if (that instanceof AllScope) {
                SingleDBScope singleDBScope = this;
                if (singleDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "intersectWith"));
                }
                return singleDBScope;
            }
            Set<String> thatSchemas = that.schemas(this.myDatabase);
            if (thatSchemas.isEmpty()) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfNothing();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "intersectWith"));
                }
                return introspectionScope;
            }
            if (thatSchemas.containsAll((Collection<?>)this.mySchemas)) {
                SingleDBScope singleDBScope = this;
                if (singleDBScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "intersectWith"));
                }
                return singleDBScope;
            }
            TreeSet<String> schemas2 = new TreeSet<String>((Collection<String>)this.mySchemas);
            schemas2.retainAll(thatSchemas);
            IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(this.myDatabase, (Collection<String>)ImmutableSet.copyOf(schemas2));
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScope$SingleDBScope", "intersectWith"));
            }
            return introspectionScope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleDBScope that = (SingleDBScope)o;
            return this.myDatabase.equals(that.myDatabase) && this.mySchemas.equals(that.mySchemas);
        }

        public int hashCode() {
            return this.myDatabase.hashCode() * 17 + this.mySchemas.hashCode();
        }
    }
}

