/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.h2.H2DdlParsing;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.h2.H2DmlParsing;
import com.intellij.sql.dialects.h2.H2ExpressionParsing;
import com.intellij.sql.dialects.h2.H2GeneratedParser;
import com.intellij.sql.dialects.h2.H2Tokens;
import com.intellij.sql.psi.impl.parser.SqlParser;
import org.jetbrains.annotations.Nullable;

public class H2Parser
extends SqlParser {
    public H2Parser() {
        super(H2Dialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    @Nullable
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        if (GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)H2Tokens.SYSTIMESTAMP)) {
            return SQL_SPECIAL_LITERAL;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return H2GeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return H2GeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return H2DmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = H2ExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return H2DdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if (super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens)) {
            if (definition != null && "true".equals(definition.getDialectAttribute("analytic"))) {
                H2GeneratedParser.analytic_clause(builder, level);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return H2ExpressionParsing.row_element_list(builder, level);
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return H2DmlParsing.paren_content_Q_or_J(builder, level);
    }
}

