/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class OraTypeReferencingExpression
extends SqlExpressionImpl {
    public OraTypeReferencingExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/oracle/psi/OraTypeReferencingExpression", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType sqlType = this.getTypeReference().getSqlType();
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/psi/OraTypeReferencingExpression", "getSqlType"));
        }
        return sqlType;
    }

    @NotNull
    public SqlReferenceExpression getTypeReference() {
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_TYPE_REFERENCE);
        if (sqlReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/psi/OraTypeReferencingExpression", "getTypeReference"));
        }
        return sqlReferenceExpression;
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression typeReference = this.getTypeReference();
        if (typeReference != lastParent && !SqlImplUtil.processQualifier(typeReference, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }
}

