/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SqlEnterHandlerDelegate
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "preprocessEnter"));
        }
        SqlLanguageDialectEx dialectEx = (SqlLanguageDialectEx)((Object)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlDialect((PsiElement)file), SqlLanguageDialectEx.class));
        if (dialectEx == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EnterHandlerDelegate handler = dialectEx.getEnterHandler();
        if (handler == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return handler.preprocessEnter(file, editor, caretOffset, caretAdvance, dataContext, originalHandler);
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "postProcessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "postProcessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/editor/SqlEnterHandlerDelegate", "postProcessEnter"));
        }
        SqlLanguageDialectEx dialectEx = (SqlLanguageDialectEx)((Object)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlDialect((PsiElement)file), SqlLanguageDialectEx.class));
        if (dialectEx == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EnterHandlerDelegate handler = dialectEx.getEnterHandler();
        if (handler == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return handler.postProcessEnter(file, editor, dataContext);
    }
}

