/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;

    public SqlLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public String getName() {
        return "SQL line markers";
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        JBIterable<PsiElement> parents;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/editor/SqlLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null && (parents = SqlImplUtil.sqlParents(element)).filter(SqlStatement.class).take(2).size() == 1) {
            boolean addSeparator = false;
            for (PsiElement parent : parents) {
                if (parent instanceof SqlStatement) {
                    int newLines = (Integer)SyntaxTraverser.psiApiReversed().siblings((Object)parent).skip(1).takeWhile(o -> !(o instanceof SqlStatement)).filter(o -> o instanceof PsiWhiteSpace || o instanceof PsiComment).reduce((Object)0, (result, o) -> {
                        result = result + StringUtil.countNewLines((CharSequence)o.getText());
                        return result;
                    });
                    if (newLines <= 1) break;
                    addSeparator = true;
                    break;
                }
                if (((SyntaxTraverser)SqlImplUtil.sqlTraverser(parent.getParent()).expand(Conditions.is((Object)parent.getParent()))).traverse().get(1) == parent) continue;
                break;
            }
            if (addSeparator) {
                LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                info.separatorColor = this.myColorsManager.getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                info.separatorPlacement = SeparatorPlacement.TOP;
                return info;
            }
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/sql/editor/SqlLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/editor/SqlLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }
}

