/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import org.jetbrains.annotations.NotNull;

public class SqlCollectionTypeElementImpl
extends SqlCompositeElementImpl
implements SqlTypeElement {
    private DataType myDataType;

    public SqlCollectionTypeElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCollectionTypeElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTypeElement((SqlTypeElement)this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myDataType = null;
    }

    @NotNull
    public DataType getDataType() {
        if (this.myDataType == null) {
            this.myDataType = DataTypeFactory.of("TABLE");
            if (this.myDataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCollectionTypeElementImpl", "getDataType"));
            }
            return this.myDataType;
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCollectionTypeElementImpl", "getDataType"));
        }
        return dataType;
    }

    @NotNull
    public SqlType findSqlType() {
        SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)this, SqlTypeElement.class);
        if (type != null) {
            SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(type.findSqlType(), (SqlElement)this, (PsiElement)this).concretize((SqlType)SqlType.COLLECTION);
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCollectionTypeElementImpl", "findSqlType"));
            }
            return sqlTableType;
        }
        SqlType sqlType = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getSqlType(this.getDisplayName());
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCollectionTypeElementImpl", "findSqlType"));
        }
        return sqlType;
    }

    public String getDisplayName() {
        return this.getDataType().getSpecification();
    }
}

