/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.stubs.SqlColumnAliasStub;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.util.IncorrectOperationException;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlColumnAliasDefinitionImpl
extends SqlStubbedDefinitionImpl<SqlColumnAliasStub>
implements SqlColumnAliasDefinition {
    public SqlColumnAliasDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlColumnAliasDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlColumnAliasDefinitionImpl(SqlColumnAliasStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
    }

    public boolean isPlainIdentifier() {
        return this.getNameElement().isPlainIdentifier();
    }

    public boolean isQuotedIdentifier() {
        return this.getNameElement().isQuotedIdentifier();
    }

    public SqlNameElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlColumnAliasDefinitionImpl", "setName"));
        }
        return (SqlNameElement)super.setName(name);
    }

    @NotNull
    public SqlIdentifier getNameElement() {
        SqlColumnAliasStub stub = (SqlColumnAliasStub)this.getStub();
        if (stub != null) {
            SqlReferenceExpression reference = stub.getNameReference(SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
            SqlIdentifier sqlIdentifier = reference.getIdentifier();
            if (sqlIdentifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnAliasDefinitionImpl", "getNameElement"));
            }
            return sqlIdentifier;
        }
        SqlIdentifier sqlIdentifier = (SqlIdentifier)this.findChildByType((IElementType)SqlElementTypes.SQL_IDENTIFIER);
        if (sqlIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnAliasDefinitionImpl", "getNameElement"));
        }
        return sqlIdentifier;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnAliasDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.Col;
    }
}

