/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class SqlFromClauseImpl
extends SqlCompositeElementImpl
implements SqlFromClause {
    public SqlFromClauseImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFromClause((SqlFromClause)this);
    }

    public SqlExpression getFromExpression() {
        return (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        SqlSetAssignment setAssignment;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlFromClauseImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlFromClauseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlFromClauseImpl", "processDeclarations"));
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this, (PsiElement)place, (boolean)true) && !this.isLateral(place)) {
            return true;
        }
        if (this.isInDelete() && (lastParent instanceof SqlJoinExpression || SqlFromClauseImpl.isUsingClause(lastParent)) && lastParent.getTextOffset() > this.getTextOffset()) {
            return true;
        }
        if (lastParent instanceof SqlSetClause && (setAssignment = (SqlSetAssignment)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{SqlSetAssignment.class})) != null && PsiTreeUtil.isContextAncestor((PsiElement)setAssignment.getLValue(), (PsiElement)place, (boolean)false)) {
            return true;
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        return SqlImplUtil.processFromReferences(processor, state, this.getFromExpression(), place, lastParent);
    }

    private static boolean isUsingClause(PsiElement lastParent) {
        if (!(lastParent instanceof SqlClause)) {
            return false;
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.astApi();
        return api.children((Object)lastParent.getNode()).transform(api.TO_TYPE).contains((Object)SqlCommonKeywords.SQL_USING);
    }

    private boolean isInDelete() {
        return this.getParent() instanceof SqlDmlInstruction && this.getParent().getParent() instanceof SqlDeleteStatement;
    }

    private boolean isLateral(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlFromClauseImpl", "isLateral"));
        }
        SqlExplicitTableExpression expr = (SqlExplicitTableExpression)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)this.getFromExpression()).expand(Conditions.or((Condition)DasUtil.byClass(SqlJoinExpression.class), (Condition)DasUtil.byClass(SqlAsExpression.class)))).filter(SqlExplicitTableExpression.class).filter(expression -> {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlFromClauseImpl", "lambda$isLateral$0"));
            }
            return PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)place, (boolean)false);
        }).first();
        return expr != null && SqlFromClauseImpl.isLateral(expr);
    }

    private static boolean isLateral(@NotNull SqlExplicitTableExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/sql/psi/impl/SqlFromClauseImpl", "isLateral"));
        }
        return expr instanceof SqlFunctionCallTableExpressionImpl || expr.getFirstChild().getNode().getElementType() == SqlCommonKeywords.SQL_LATERAL;
    }
}

