/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNamedElementStub<T extends SqlElement>
extends StubBase<T> {
    protected final StringRef myName;
    private Object myNameReference;

    public SqlNamedElementStub(StubElement parent, @NotNull IStubElementType elementType, @Nullable StringRef name) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/SqlNamedElementStub", "<init>"));
        }
        super(parent, elementType);
        this.myName = name;
    }

    @Nullable
    public String getName() {
        return this.myName == null ? null : this.myName.getString();
    }

    @Nullable
    public SqlReferenceExpression getNameReference(@NotNull SqlReferenceElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/stubs/SqlNamedElementStub", "getNameReference"));
        }
        Object cur = this.myNameReference;
        if (!(cur instanceof SqlReferenceExpression)) {
            this.myNameReference = cur = this.createReference(type, this.getName());
        }
        return (SqlReferenceExpression)cur;
    }

    public List<SqlReferenceExpression> getNameReferences(@NotNull SqlReferenceElementType type, @NotNull String separator) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/stubs/SqlNamedElementStub", "getNameReferences"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/sql/psi/stubs/SqlNamedElementStub", "getNameReferences"));
        }
        List<SqlReferenceExpression> cur = this.myNameReference;
        if (!(cur instanceof List)) {
            this.myNameReference = cur = this.createReferences(type, this.getName(), separator);
        }
        return cur;
    }

    private List<SqlReferenceExpression> createReferences(SqlReferenceElementType type, String text, String separator) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptyList();
        }
        List list = ContainerUtil.newSmartList();
        for (String s : StringUtil.split((String)text, (String)separator)) {
            ContainerUtil.addIfNotNull((Collection)list, (Object)this.createReference(type, s));
        }
        return list;
    }

    @Nullable
    protected SqlReferenceExpression createReference(@NotNull SqlReferenceElementType type, @Nullable String text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/stubs/SqlNamedElementStub", "createReference"));
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        SqlElement psi = (SqlElement)this.getPsi();
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)psi);
        return SqlPsiElementFactory.createReferenceFromText(text, language, type, (PsiElement)psi);
    }
}

