/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.smartenter.SqlCallExpressionFixer;
import com.intellij.sql.smartenter.SqlCreateTableFixer;
import com.intellij.sql.smartenter.SqlPlainEnterProcessor;
import com.intellij.sql.smartenter.SqlSemicolonFixer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    public SqlSmartEnterProcessor() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{new SqlCreateTableFixer(), new SqlCallExpressionFixer(), new SqlSemicolonFixer()});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new SqlPlainEnterProcessor()});
    }

    public boolean doNotStepInto(PsiElement element) {
        return element instanceof SqlStatement;
    }

    protected void collectAdditionalElements(@NotNull PsiElement element, final @NotNull List<PsiElement> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/smartenter/SqlSmartEnterProcessor", "collectAdditionalElements"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/smartenter/SqlSmartEnterProcessor", "collectAdditionalElements"));
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        if (statement == null) {
            return;
        }
        result.add((PsiElement)statement);
        statement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement o) {
                if (o instanceof SqlExpression) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)o);
                }
                super.visitElement(o);
            }
        });
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        if (!atCaret.isValid()) {
            return;
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)atCaret, SqlStatement.class);
        super.reformat((PsiElement)(statement == null ? atCaret : statement));
    }

    protected PsiElement restoreElementAtCaret(PsiFile file, PsiElement origElement, RangeMarker marker) {
        return CodeInsightUtilCore.findElementInRange((PsiFile)file, (int)marker.getStartOffset(), (int)marker.getEndOffset(), origElement.getClass(), (Language)SqlImplUtil.getSqlDialectSafe((PsiElement)file));
    }
}

