/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class CustomViewDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CustomViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("CustomViewStyleable", "Mismatched Styleable/Custom View Name", "The convention for custom views is to use a `declare-styleable` whose name matches the custom view class name. The IDE relies on this convention such that for example code completion can be offered for attributes in a custom view in layout XML resource files.\n\n(Similarly, layout parameter classes should use the suffix `_Layout`.)", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(OBTAIN_STYLED_ATTRIBUTES);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod method) {
        if (LintUtils.skipParentheses(node.getContainingElement()) instanceof UExpression) {
            List arguments;
            if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.content.Context", false)) {
                return;
            }
            int size = (arguments = node.getValueArguments()).size();
            int parameterIndex = size == 1 ? 0 : 1;
            UExpression expression2 = (UExpression)arguments.get(parameterIndex);
            if (!UastUtils.startsWithQualified((UExpression)expression2, (String)"R.styleable.")) {
                return;
            }
            List path = UastUtils.asQualifiedPath((UExpression)expression2);
            if (path == null || path.size() < 3) {
                return;
            }
            String styleableName = (String)path.get(2);
            UClass cls = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)false);
            if (cls == null) {
                return;
            }
            String className = cls.getName();
            if (InheritanceUtil.isInheritor((PsiClass)cls, (boolean)false, (String)"android.view.View")) {
                if (!styleableName.equals(className)) {
                    String message = String.format("By convention, the custom view (`%1$s`) and the declare-styleable (`%2$s`) should have the same name (various editor features rely on this convention)", className, styleableName);
                    context.report(ISSUE, (UElement)node, context.getUastLocation((UElement)expression2), message);
                }
            } else if (InheritanceUtil.isInheritor((PsiClass)cls, (boolean)false, (String)"android.view.ViewGroup.LayoutParams")) {
                PsiClass outer = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                if (outer == null) {
                    return;
                }
                String layoutClassName = outer.getName();
                String expectedName = layoutClassName + "_Layout";
                if (!styleableName.equals(expectedName)) {
                    String message = String.format("By convention, the declare-styleable (`%1$s`) for a layout parameter class (`%2$s`) is expected to be the surrounding class (`%3$s`) plus \"`_Layout`\", e.g. `%4$s`. (Various editor features rely on this convention.)", styleableName, className, layoutClassName, expectedName);
                    context.report(ISSUE, (UElement)node, context.getUastLocation((UElement)expression2), message);
                }
            }
        }
    }
}

