/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.tools.klint.checks.PermissionHolder;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

public abstract class PermissionRequirement {
    public static final String ATTR_PROTECTION_LEVEL = "protectionLevel";
    public static final String VALUE_DANGEROUS = "dangerous";
    protected final UAnnotation annotation;
    private int firstApi;
    private int lastApi;
    public static final PermissionRequirement NONE = new PermissionRequirement(null){

        @Override
        public boolean isSatisfied(@NonNull PermissionHolder available) {
            return true;
        }

        @Override
        public boolean appliesTo(@NonNull PermissionHolder available) {
            return false;
        }

        @Override
        public boolean isConditional() {
            return false;
        }

        @Override
        public boolean isRevocable(@NonNull PermissionHolder revocable) {
            return false;
        }

        public String toString() {
            return "None";
        }

        @Override
        protected void addMissingPermissions(@NonNull PermissionHolder available, @NonNull Set<String> result) {
        }

        @Override
        protected void addRevocablePermissions(@NonNull Set<String> result, @NonNull PermissionHolder revocable) {
        }

        @Override
        @Nullable
        public IElementType getOperator() {
            return null;
        }

        @Override
        @NonNull
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }
    };
    static final String[] REVOCABLE_PERMISSION_NAMES = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS", "android.permission.CALL_PHONE", "android.permission.CAMERA", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_CALENDAR", "android.permission.READ_CALL_LOG", "android.permission.READ_CELL_BROADCASTS", "android.permission.READ_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE", "android.permission.READ_PROFILE", "android.permission.READ_SMS", "android.permission.READ_SOCIAL_STREAM", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECORD_AUDIO", "android.permission.SEND_SMS", "android.permission.USE_FINGERPRINT", "android.permission.USE_SIP", "android.permission.WRITE_CALENDAR", "android.permission.WRITE_CALL_LOG", "android.permission.WRITE_CONTACTS", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WRITE_SETTINGS", "android.permission.WRITE_PROFILE", "android.permission.WRITE_SOCIAL_STREAM", "com.android.voicemail.permission.ADD_VOICEMAIL"};

    private PermissionRequirement(@NonNull UAnnotation annotation) {
        this.annotation = annotation;
    }

    @NonNull
    public static PermissionRequirement create(@NonNull UAnnotation annotation) {
        String[] allOf;
        String value2 = PermissionRequirement.getAnnotationStringValue(annotation, "value");
        if (value2 != null && !value2.isEmpty()) {
            return new Single(annotation, value2);
        }
        String[] anyOf = PermissionRequirement.getAnnotationStringValues(annotation, "anyOf");
        if (anyOf != null) {
            if (anyOf.length > 1) {
                return new Many(annotation, JavaTokenType.OROR, anyOf);
            }
            if (anyOf.length == 1) {
                return new Single(annotation, anyOf[0]);
            }
        }
        if ((allOf = PermissionRequirement.getAnnotationStringValues(annotation, "allOf")) != null) {
            if (allOf.length > 1) {
                return new Many(annotation, JavaTokenType.ANDAND, allOf);
            }
            if (allOf.length == 1) {
                return new Single(annotation, allOf[0]);
            }
        }
        return NONE;
    }

    @Nullable
    public static Boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NonNull String name) {
        if (annotation != null) {
            Object o;
            UNamedExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof Boolean) {
                return (Boolean)o;
            }
        }
        return null;
    }

    @Nullable
    public static Long getAnnotationLongValue(@Nullable UAnnotation annotation, @NonNull String name) {
        if (annotation != null) {
            Object o;
            UNamedExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof Number) {
                return ((Number)o).longValue();
            }
        }
        return null;
    }

    @Nullable
    public static Double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NonNull String name) {
        if (annotation != null) {
            Object o;
            UNamedExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof Number) {
                return ((Number)o).doubleValue();
            }
        }
        return null;
    }

    @Nullable
    public static String getAnnotationStringValue(@Nullable UAnnotation annotation, @NonNull String name) {
        if (annotation != null) {
            Object o;
            UNamedExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof String) {
                return (String)o;
            }
        }
        return null;
    }

    @Nullable
    public static String[] getAnnotationStringValues(@Nullable UAnnotation annotation, @NonNull String name) {
        if (annotation != null) {
            UNamedExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue == null) {
                return null;
            }
            if (UastExpressionUtils.isArrayInitializer((UElement)attributeValue.getExpression())) {
                List initializers = ((UCallExpression)attributeValue.getExpression()).getValueArguments();
                ArrayList result = Lists.newArrayListWithCapacity((int)initializers.size());
                ConstantEvaluator constantEvaluator = new ConstantEvaluator(null);
                for (UExpression element : initializers) {
                    Object o = constantEvaluator.evaluate((UElement)element);
                    if (!(o instanceof String)) continue;
                    result.add((String)o);
                }
                if (result.isEmpty()) {
                    return null;
                }
                return result.toArray(new String[0]);
            }
            Object o = ConstantEvaluator.evaluate(null, (UElement)attributeValue.getExpression());
            if (o instanceof String) {
                return new String[]{(String)o};
            }
            if (o instanceof String[]) {
                return (String[])o;
            }
            if (o instanceof Object[]) {
                Object[] array = (Object[])o;
                ArrayList strings = Lists.newArrayListWithCapacity((int)array.length);
                for (Object element : array) {
                    if (!(element instanceof String)) continue;
                    strings.add((String)element);
                }
                return strings.toArray(new String[0]);
            }
        }
        return null;
    }

    protected boolean appliesTo(@NonNull PermissionHolder available) {
        if (this.firstApi == 0) {
            int index;
            this.firstApi = -1;
            String range = PermissionRequirement.getAnnotationStringValue(this.annotation, "apis");
            if (range != null && (index = range.indexOf("..")) != -1) {
                try {
                    this.firstApi = index > 0 ? Integer.parseInt(range.substring(0, index)) : 1;
                    this.lastApi = index + 2 < range.length() ? Integer.parseInt(range.substring(index + 2)) : Integer.MAX_VALUE;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.firstApi != -1) {
            AndroidVersion minSdkVersion = available.getMinSdkVersion();
            if (minSdkVersion.getFeatureLevel() > this.lastApi) {
                return false;
            }
            AndroidVersion targetSdkVersion = available.getTargetSdkVersion();
            if (targetSdkVersion.getFeatureLevel() < this.firstApi) {
                return false;
            }
        }
        return true;
    }

    public boolean isConditional() {
        Boolean o = PermissionRequirement.getAnnotationBooleanValue(this.annotation, "conditional");
        if (o != null) {
            return o;
        }
        return false;
    }

    public boolean isSingle() {
        return true;
    }

    public abstract boolean isSatisfied(@NonNull PermissionHolder var1);

    public String describeMissingPermissions(@NonNull PermissionHolder available) {
        return "";
    }

    public Set<String> getMissingPermissions(@NonNull PermissionHolder available) {
        HashSet result = Sets.newHashSet();
        this.addMissingPermissions(available, result);
        return result;
    }

    protected abstract void addMissingPermissions(@NonNull PermissionHolder var1, @NonNull Set<String> var2);

    public Set<String> getRevocablePermissions(@NonNull PermissionHolder revocable) {
        HashSet result = Sets.newHashSet();
        this.addRevocablePermissions(result, revocable);
        return result;
    }

    protected abstract void addRevocablePermissions(@NonNull Set<String> var1, @NonNull PermissionHolder var2);

    public abstract boolean isRevocable(@NonNull PermissionHolder var1);

    @Nullable
    public abstract IElementType getOperator();

    @NonNull
    public abstract Iterable<PermissionRequirement> getChildren();

    protected static void appendOperator(StringBuilder sb, IElementType operator) {
        sb.append(' ');
        if (operator == JavaTokenType.ANDAND) {
            sb.append("and");
        } else if (operator == JavaTokenType.OROR) {
            sb.append("or");
        } else {
            assert (operator == JavaTokenType.XOR) : operator;
            sb.append("xor");
        }
        sb.append(' ');
    }

    public static boolean isRevocableSystemPermission(@NonNull String name) {
        return Arrays.binarySearch(REVOCABLE_PERMISSION_NAMES, name) >= 0;
    }

    private static class Many
    extends PermissionRequirement {
        public final IElementType operator;
        public final List<PermissionRequirement> permissions;

        public Many(@NonNull UAnnotation annotation, IElementType operator, String[] names) {
            super(annotation);
            assert (operator == JavaTokenType.OROR || operator == JavaTokenType.ANDAND) : operator;
            assert (names.length >= 2);
            this.operator = operator;
            this.permissions = Lists.newArrayListWithExpectedSize((int)names.length);
            for (String name : names) {
                this.permissions.add(new Single(annotation, name));
            }
        }

        @Override
        public boolean isSingle() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.permissions.get(0));
            for (int i = 1; i < this.permissions.size(); ++i) {
                Many.appendOperator(sb, this.operator);
                sb.append(this.permissions.get(i));
            }
            return sb.toString();
        }

        @Override
        public boolean isSatisfied(@NonNull PermissionHolder available) {
            if (this.operator == JavaTokenType.ANDAND) {
                for (PermissionRequirement requirement : this.permissions) {
                    if (requirement.isSatisfied(available) || !requirement.appliesTo(available)) continue;
                    return false;
                }
                return true;
            }
            assert (this.operator == JavaTokenType.OROR) : this.operator;
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isSatisfied(available) && requirement.appliesTo(available)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describeMissingPermissions(@NonNull PermissionHolder available) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                if (first) {
                    first = false;
                } else {
                    Many.appendOperator(sb, this.operator);
                }
                sb.append(requirement.describeMissingPermissions(available));
            }
            return sb.toString();
        }

        @Override
        protected void addMissingPermissions(@NonNull PermissionHolder available, @NonNull Set<String> missing) {
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                requirement.addMissingPermissions(available, missing);
            }
        }

        @Override
        protected void addRevocablePermissions(@NonNull Set<String> result, @NonNull PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                requirement.addRevocablePermissions(result, revocable);
            }
        }

        @Override
        public boolean isRevocable(@NonNull PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isRevocable(revocable)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public IElementType getOperator() {
            return this.operator;
        }

        @Override
        @NonNull
        public Iterable<PermissionRequirement> getChildren() {
            return this.permissions;
        }
    }

    private static class Single
    extends PermissionRequirement {
        public final String name;

        public Single(@NonNull UAnnotation annotation, @NonNull String name) {
            super(annotation);
            this.name = name;
        }

        @Override
        public boolean isRevocable(@NonNull PermissionHolder revocable) {
            return revocable.isRevocable(this.name) || Single.isRevocableSystemPermission(this.name);
        }

        @Override
        @Nullable
        public IElementType getOperator() {
            return null;
        }

        @Override
        @NonNull
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean isSatisfied(@NonNull PermissionHolder available) {
            return available.hasPermission(this.name) || !this.appliesTo(available);
        }

        @Override
        public String describeMissingPermissions(@NonNull PermissionHolder available) {
            return this.isSatisfied(available) ? "" : this.name;
        }

        @Override
        protected void addMissingPermissions(@NonNull PermissionHolder available, @NonNull Set<String> missing) {
            if (!this.isSatisfied(available)) {
                missing.add(this.name);
            }
        }

        @Override
        protected void addRevocablePermissions(@NonNull Set<String> result, @NonNull PermissionHolder revocable) {
            if (this.isRevocable(revocable)) {
                result.add(this.name);
            }
        }
    }
}

