/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestCategory;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestDirectory;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit.testDiscovery.TestBySource;
import com.intellij.execution.junit.testDiscovery.TestsByChanges;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.junit4.JUnit4IdeaTestRunner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opentest4j.MultipleFailuresError;

public abstract class TestObject
extends JavaTestFrameworkRunnableState<JUnitConfiguration> {
    private static final String DEBUG_RT_PATH = "idea.junit_rt.path";
    protected static final Logger LOG = Logger.getInstance(TestObject.class);
    private static final String MESSAGE = ExecutionBundle.message((String)"configuration.not.speficied.message", (Object[])new Object[0]);
    @NonNls
    private static final String JUNIT_TEST_FRAMEWORK_NAME = "JUnit";
    private final JUnitConfiguration myConfiguration;
    protected File myListenersFile;

    public static TestObject fromString(String id, JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/junit/TestObject", "fromString"));
        }
        if ("method".equals(id)) {
            return new TestMethod(configuration, environment);
        }
        if ("class".equals(id)) {
            return new TestClass(configuration, environment);
        }
        if ("package".equals(id)) {
            return new TestPackage(configuration, environment);
        }
        if ("directory".equals(id)) {
            return new TestDirectory(configuration, environment);
        }
        if ("category".equals(id)) {
            return new TestCategory(configuration, environment);
        }
        if ("pattern".equals(id)) {
            return new TestsPattern(configuration, environment);
        }
        if ("source location".equals(id)) {
            return new TestBySource(configuration, environment);
        }
        if ("changes".equals(id)) {
            return new TestsByChanges(configuration, environment);
        }
        LOG.info(MESSAGE + id);
        return null;
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    protected TestObject(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(environment);
        this.myConfiguration = configuration;
    }

    public abstract String suggestActionName();

    public abstract RefactoringElementListener getListener(PsiElement var1, JUnitConfiguration var2);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiClass var2, PsiMethod var3, PsiPackage var4, PsiDirectory var5);

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
    }

    @Nullable
    public SourceScope getSourceScope() {
        return SourceScope.modules((Module[])this.getConfiguration().getModules());
    }

    protected void configureRTClasspath(JavaParameters javaParameters) {
        String path = System.getProperty(DEBUG_RT_PATH);
        javaParameters.getClassPath().add(path != null ? path : PathUtil.getJarPathForClass(JUnitStarter.class));
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        javaParameters.setMainClass("com.intellij.rt.execution.junit.JUnitStarter");
        javaParameters.getProgramParametersList().add("-ideVersion5");
        StringBuilder buf = new StringBuilder();
        this.collectListeners(javaParameters, buf, "com.intellij.junitListener", "\n");
        if (buf.length() > 0) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junit_listeners_", (String)"", (boolean)true);
                javaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        Project project = this.getConfiguration().getProject();
        SourceScope sourceScope = this.getSourceScope();
        GlobalSearchScope globalSearchScope = TestObject.getScopeForJUnit(((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule(), sourceScope, project);
        if (JUnitUtil.isJUnit5((GlobalSearchScope)globalSearchScope, (Project)project)) {
            javaParameters.getProgramParametersList().add("-junit5");
            File junit4Rt = new File(PathUtil.getJarPathForClass(JUnit4IdeaTestRunner.class));
            String junit5Name = junit4Rt.getName().replace("junit", "junit5");
            javaParameters.getClassPath().add(new File(junit4Rt.getParent(), junit5Name));
            PathsList classPath = javaParameters.getClassPath();
            File lib = new File(PathUtil.getJarPathForClass(MultipleFailuresError.class)).getParentFile();
            File[] files = lib.listFiles();
            if (files != null) {
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                for (File file : files) {
                    String fileName = file.getName();
                    if (fileName.startsWith("junit-platform-launcher-") && !TestObject.hasPackageWithDirectories(psiFacade, "org.junit.platform.launcher", globalSearchScope) || fileName.startsWith("junit-platform-") && !TestObject.hasPackageWithDirectories(psiFacade, "org.junit.platform", globalSearchScope) || fileName.startsWith("junit-jupiter-engine-") && !TestObject.hasPackageWithDirectories(psiFacade, "org.junit.jupiter.engine", globalSearchScope) && TestObject.hasPackageWithDirectories(psiFacade, "org.junit.jupiter.api", globalSearchScope)) {
                        classPath.add(file.getAbsolutePath());
                        continue;
                    }
                    if (!fileName.startsWith("junit-vintage-engine-") || TestObject.hasPackageWithDirectories(psiFacade, "org.junit.vintage", globalSearchScope)) continue;
                    try {
                        JUnitUtil.getTestCaseClass((SourceScope)sourceScope);
                        classPath.add(file.getAbsolutePath());
                    }
                    catch (JUnitUtil.NoJUnitException noJUnitException) {
                        // empty catch block
                    }
                }
            }
        }
        return javaParameters;
    }

    private static boolean hasPackageWithDirectories(JavaPsiFacade psiFacade, String packageQName, GlobalSearchScope globalSearchScope) {
        PsiPackage aPackage = psiFacade.findPackage(packageQName);
        return aPackage != null && aPackage.getDirectories(globalSearchScope).length > 0;
    }

    public static boolean isJUnit5(@Nullable Module module, @Nullable SourceScope sourceScope, Project project) {
        return JUnitUtil.isJUnit5((GlobalSearchScope)TestObject.getScopeForJUnit(module, sourceScope, project), (Project)project);
    }

    private static GlobalSearchScope getScopeForJUnit(@Nullable Module module, @Nullable SourceScope sourceScope, Project project) {
        return module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : (sourceScope != null ? sourceScope.getLibrariesScope() : GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    protected OSProcessHandler createHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        String repeatMode = this.getConfiguration().getRepeatMode();
        if (!"Once".equals(repeatMode)) {
            int repeatCount = this.getConfiguration().getRepeatCount();
            String countString = "N Times".equals(repeatMode) && repeatCount > 0 ? RepeatCount.getCountString((int)repeatCount) : repeatMode;
            this.getJavaParameters().getProgramParametersList().add(countString);
        }
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        SearchForTestsTask searchForTestsTask = this.createSearchingForTestsTask();
        if (searchForTestsTask != null) {
            searchForTestsTask.attachTaskToProcess((OSProcessHandler)processHandler);
        }
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "createHandler"));
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    protected String getForkMode() {
        String string = this.getConfiguration().getForkMode();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getForkMode"));
        }
        return string;
    }

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters) throws CantRunException {
        try {
            if (createTempFile) {
                this.createTempFiles(javaParameters);
            }
            TreeMap<Module, ArrayList<String>> perModule = this.forkPerModule() ? new TreeMap<Module, ArrayList<String>>((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)) : null;
            ArrayList<String> testNames = new ArrayList<String>();
            for (Object element : elements) {
                String name = (String)nameFunction.fun(element);
                if (name == null) continue;
                PsiElement psiElement = this.retrievePsiElement(element);
                if (perModule != null && psiElement != null) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                    if (module == null) continue;
                    ArrayList<String> list = (ArrayList<String>)perModule.get(module);
                    if (list == null) {
                        list = new ArrayList<String>();
                        perModule.put(module, list);
                    }
                    list.add(name);
                    continue;
                }
                testNames.add(name);
            }
            JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
            if (perModule != null) {
                for (List perModuleClasses : perModule.values()) {
                    Collections.sort(perModuleClasses);
                    testNames.addAll(perModuleClasses);
                }
            } else if ("package".equals(data.TEST_OBJECT)) {
                Collections.sort(testNames);
            }
            String category = "category".equals(data.TEST_OBJECT) ? data.getCategory() : "";
            JUnitStarter.printClassesList(testNames, (String)packageName, (String)category, (File)this.myTempFile);
            this.writeClassesPerModule(packageName, javaParameters, perModule);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected PsiElement retrievePsiElement(Object element) {
        return element instanceof PsiElement ? (PsiElement)element : null;
    }

    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.myListenersFile != null) {
            FileUtil.delete((File)this.myListenersFile);
        }
    }

    @NotNull
    protected String getFrameworkName() {
        if (JUNIT_TEST_FRAMEWORK_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getFrameworkName"));
        }
        return JUNIT_TEST_FRAMEWORK_NAME;
    }

    @NotNull
    protected String getFrameworkId() {
        if ("junit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getFrameworkId"));
        }
        return "junit";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add("@" + tempFilePath);
    }

    @NotNull
    public JUnitConfiguration getConfiguration() {
        JUnitConfiguration jUnitConfiguration = this.myConfiguration;
        if (jUnitConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getConfiguration"));
        }
        return jUnitConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistentData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) throws ExecutionException {
        parameters.getProgramParametersList().add("@@@" + forkMode + ',' + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parameters.getProgramParametersList().add("-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }
}

