/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.JspBundle;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class ELSpecComplianceInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELSpecComplianceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JspBundle.message("el.jsp.spec.validation.in.jsp", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELSpecComplianceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("ELSpecValidationInJSP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELSpecComplianceInspection", "getShortName"));
        }
        return "ELSpecValidationInJSP";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/jsp/ELSpecComplianceInspection", "buildVisitor"));
        }
        ELElementVisitor eLElementVisitor = new ELElementVisitor(){

            @Override
            public void visitELExpressionHolder(ELExpressionHolder expressionHolder) {
                PsiElement parent;
                if (expressionHolder.isJSFELHolder() && (parent = expressionHolder.getParent()) instanceof XmlTag) {
                    for (String faceletsUri : XmlUtil.FACELETS_URIS) {
                        String prefix = ((XmlTag)parent).getPrefixByNamespace(faceletsUri);
                        if (prefix == null || prefix.length() <= 0) continue;
                        return;
                    }
                    holder.registerProblem((PsiElement)expressionHolder, PsiBundle.message((String)"jsf.el.out.of.attribute", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])null);
                }
            }

            @Override
            public void visitELMethodCallExpression(ELMethodCallExpression methodCallExpression) {
                PsiFile file = methodCallExpression.getContainingFile();
                ELExpressionHolder elExpressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, ELExpressionHolder.class);
                if (elExpressionHolder != null && elExpressionHolder.isJSFELHolder()) {
                    return;
                }
                if (file != null && !JspManager.getInstance((Project)file.getProject()).getJspVersion((PsiFileSystemItem)file).betterThan(JspVersion.JSP_2_1)) {
                    holder.registerProblem((PsiElement)methodCallExpression.getELParameterList(), PsiBundle.message((String)"jsf.method.call.is.nonstd.extension", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])null);
                }
            }
        };
        if (eLElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELSpecComplianceInspection", "buildVisitor"));
        }
        return eLElementVisitor;
    }
}

