/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.utils;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.Props;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.persistence.integration.hibernate.SpringAnnoHibernateSessionFactory;
import com.intellij.spring.persistence.integration.hibernate.SpringXmlHibernateSessionFactory;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IntegrationUtil {
    @NonNls
    static final List<Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>> myAnnoProviders = new ArrayList<Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>>();
    @NonNls
    public static final List<Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>> myProviders = new ArrayList<Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>>();

    private IntegrationUtil() {
    }

    @Nullable
    public static <T> T getProvider(SpringBeanPointer bean, List<Pair<String, T>> providers, boolean allowAbstract) {
        if (!bean.isValid()) {
            return null;
        }
        if (!allowAbstract && bean.isAbstract()) {
            return null;
        }
        PsiClass beanClass = bean.getBeanClass();
        String beanClassName = beanClass != null ? beanClass.getQualifiedName() : (bean.getSpringBean() instanceof SpringBean ? ((SpringBean)bean.getSpringBean()).getClazz().getRawText() : null);
        for (Pair<String, T> pair : providers) {
            String name = (String)pair.getFirst();
            if (name.equals(beanClassName)) {
                return (T)pair.getSecond();
            }
            if (!JamCommonUtil.isSuperClass((PsiClass)beanClass, (String)name)) continue;
            return (T)pair.getSecond();
        }
        return null;
    }

    public static PersistencePackage getPersistencePackage(SpringBeanPointer pointer, PersistenceFacet facet, boolean supportsAnnotation) {
        return pointer instanceof DomSpringBeanPointer ? new SpringXmlHibernateSessionFactory((DomSpringBeanPointer)pointer, facet.getModule(), supportsAnnotation) : new SpringAnnoHibernateSessionFactory(pointer, facet.getModule());
    }

    public static boolean isSessionFactoryBean(@Nullable SpringBean bean, boolean annotationOnly, boolean allowAbstract) {
        return bean != null && IntegrationUtil.isSessionFactoryBean(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean), annotationOnly, allowAbstract);
    }

    public static boolean isSessionFactoryBean(@Nullable SpringBeanPointer bean, boolean annotationOnly, boolean allowAbstract) {
        return bean != null && IntegrationUtil.getProvider(bean, annotationOnly ? myAnnoProviders : myProviders, allowAbstract) != null;
    }

    public static SpringPropertyDefinition setBeanProperty(SpringBean bean, String propertyName, String propertyAlias, String propertyValue, boolean isList) {
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName);
        if (property == null && propertyAlias != null) {
            property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyAlias);
        }
        return IntegrationUtil.setBeanProperty(bean, property, propertyName, propertyValue, isList);
    }

    public static SpringPropertyDefinition setBeanProperty(SpringBean bean, SpringPropertyDefinition property, String propertyName, String propertyValue, boolean isList) {
        if (!(property instanceof SpringProperty)) {
            if (property != null) {
                property.undefine();
            }
            property = bean.addProperty();
            ((SpringProperty)property).getName().setStringValue(propertyName);
        }
        IntegrationUtil.setPropertyValue((SpringProperty)property, propertyValue, isList);
        return property;
    }

    @Nullable
    public static Prop findProp(Props props, String propertyName, String propertyAlias) {
        for (Prop prop : props.getProps()) {
            String value = (String)prop.getKey().getValue();
            if (!Comparing.strEqual((String)value, (String)propertyName) && !Comparing.strEqual((String)value, (String)propertyAlias)) continue;
            return prop;
        }
        return null;
    }

    public static void setBeanProperty(Props props, String propertyName, String propertyAlias, String propertyValue) {
        Prop prop = IntegrationUtil.findProp(props, propertyName, propertyAlias);
        if (prop == null) {
            prop = props.addProp();
            prop.getKey().setStringValue(propertyName);
        }
        prop.setStringValue(propertyValue);
    }

    private static void setPropertyValue(SpringProperty property, String stringValue, boolean isList) {
        ListOrSet listOrSet = property.getList();
        if (!DomUtil.hasXml((DomElement)listOrSet)) {
            GenericAttributeValue valueAttr = property.getValueAttr();
            XmlAttribute valueAttrElement = valueAttr.getXmlAttribute();
            String valueAttrString = valueAttr.getStringValue();
            if (valueAttrElement != null && StringUtil.isNotEmpty((String)valueAttrString)) {
                if (!isList) {
                    valueAttr.setStringValue(stringValue);
                    return;
                }
                listOrSet.addValue().setStringValue(valueAttrString);
                valueAttr.undefine();
            }
            SpringValue value = property.getValue();
            XmlTag valueElement = value.getXmlTag();
            String valueString = value.getStringValue();
            if (valueElement != null && StringUtil.isNotEmpty((String)valueString)) {
                if (!isList) {
                    value.setStringValue(stringValue);
                    return;
                }
                listOrSet.addValue().setStringValue(valueString);
                value.undefine();
            }
        }
        listOrSet.addValue().setStringValue(stringValue);
    }

    static {
        NullableFunction annoProvider = pair -> IntegrationUtil.getPersistencePackage((SpringBeanPointer)pair.getFirst(), (PersistenceFacet)pair.getSecond(), true);
        Pair annoHibernate3 = Pair.create((Object)"org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean", (Object)annoProvider);
        Pair annoHibernate4 = Pair.create((Object)"org.springframework.orm.hibernate4.LocalSessionFactoryBean", (Object)annoProvider);
        Pair effectiveSessionFactoryBeanType = Pair.create((Object)"org.hibernate.SessionFactory", (Object)annoProvider);
        myAnnoProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)annoHibernate3);
        myAnnoProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)annoHibernate4);
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)annoHibernate3);
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)annoHibernate4);
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)effectiveSessionFactoryBeanType);
        NullableFunction basicProvider = pair -> IntegrationUtil.getPersistencePackage((SpringBeanPointer)pair.getFirst(), (PersistenceFacet)pair.getSecond(), false);
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)Pair.create((Object)"org.springframework.orm.hibernate3.LocalSessionFactoryBean", (Object)basicProvider));
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)Pair.create((Object)"org.springframework.orm.hibernate4.LocalSessionFactoryBean", (Object)basicProvider));
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)Pair.create((Object)"org.springframework.orm.hibernate5.LocalSessionFactoryBean", (Object)basicProvider));
        myProviders.add((Pair<String, Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage>>)Pair.create((Object)"org.springframework.orm.hibernate.LocalSessionFactoryBean", (Object)basicProvider));
    }
}

