/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class NodeCommandLineUtil {
    private static final Key<Boolean> USE_WIP_CONNECTION = Key.create((String)"USE_WIP_CONNECTION");

    private NodeCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, long timeoutMillis) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        ProcessOutput processOutput = NodeCommandLineUtil.execute(commandLine, null, timeoutMillis);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator indicator, long timeoutMillis) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, false);
        processHandler.setShouldDestroyProcessRecursively(true);
        processHandler.setShouldKillProcessSoftly(true);
        ProcessOutputCatcher outputCatcher = new ProcessOutputCatcher((BaseOSProcessHandler)processHandler);
        ProcessOutput processOutput = outputCatcher.run(indicator, timeoutMillis);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        return processOutput;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir, @NotNull NodeJsLocalInterpreter interpreter, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(interpreter.getValidNpmCliJsFilePath());
        commandLine.addParameters(arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        return generalCommandLine;
    }

    public static void configureUsefulEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "configureUsefulEnvironment"));
        }
        Map env = commandLine.getEnvironment();
        env.putIfAbsent("DEBUG_COLORS", "true");
        env.putIfAbsent("DEBUG_FD", "1");
        env.putIfAbsent("FORCE_COLOR", "true");
        env.putIfAbsent("MOCHA_COLORS", "1");
        env.putIfAbsent("ELECTRON_NO_ATTACH_CONSOLE", "true");
    }

    public static void addDebugParameters(@NotNull GeneralCommandLine commandLine, int debugPort) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "addDebugParameters"));
        }
        if (debugPort > 0) {
            commandLine.addParameter("--debug-brk=" + debugPort);
            commandLine.addParameter("--expose_debug_as=v8debug");
        }
    }

    public static void addNodeOptions(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, @NotNull NodeJsInterpreter interpreter, boolean preferWipDebuggerProtocol) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "addNodeOptions"));
        }
        if (nodeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "addNodeOptions"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "addNodeOptions"));
        }
        if (debugPort == -1) {
            commandLine.addParameters(nodeOptions);
            return;
        }
        int inspectIndex = nodeOptions.indexOf("--inspect");
        if (inspectIndex != -1) {
            ArrayList<String> copy = new ArrayList<String>(nodeOptions);
            copy.set(inspectIndex, "--inspect=" + debugPort);
            commandLine.addParameters(copy);
            commandLine.addParameter("--debug-brk");
            commandLine.putUserData(USE_WIP_CONNECTION, (Object)true);
        } else {
            SemVer version = null;
            if (preferWipDebuggerProtocol) {
                Promise<SemVer> versionPromise = interpreter.provideCachedVersionOrFetch();
                version = (SemVer)versionPromise.blockingGet(1500, TimeUnit.MILLISECONDS);
            }
            if (version != null && version.getMajor() >= 7) {
                commandLine.addParameter("--inspect=" + debugPort);
                commandLine.addParameter("--debug-brk");
                commandLine.putUserData(USE_WIP_CONNECTION, (Object)true);
            } else {
                NodeCommandLineUtil.addDebugParameters(commandLine, debugPort);
            }
            commandLine.addParameters(nodeOptions);
        }
    }

    @NotNull
    public static OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createProcessHandler"));
        }
        if (Boolean.TRUE.equals(USE_WIP_CONNECTION.get((UserDataHolder)commandLine))) {
            SkippingProcessHandler skippingProcessHandler = new SkippingProcessHandler(commandLine, withMediator);
            if (skippingProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createProcessHandler"));
            }
            return skippingProcessHandler;
        }
        KillableColoredProcessHandler killableColoredProcessHandler = new KillableColoredProcessHandler(commandLine, withMediator);
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createProcessHandler"));
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public static ProcessHandler createSkippingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createSkippingProcessHandler"));
        }
        SkippingProcessHandler skippingProcessHandler = new SkippingProcessHandler(commandLine, false);
        if (skippingProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createSkippingProcessHandler"));
        }
        return skippingProcessHandler;
    }

    public static boolean shouldUseWipConnection(@Nullable ProcessHandler processHandler) {
        return processHandler instanceof SkippingProcessHandler || processHandler instanceof BaseOSProcessHandler && ((BaseOSProcessHandler)processHandler).getCommandLine().contains(" --inspect");
    }

    public static String formatErrorMessage(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "formatErrorMessage"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "formatErrorMessage"));
        }
        StringBuilder buf = new StringBuilder(commandLine.getCommandLineString());
        if (output.getStderr().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard error:\n").append(output.getStderr());
        }
        if (output.getStdout().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard output:\n").append(output.getStdout());
        }
        buf.append("\n\n");
        buf.append(IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{output.getExitCode()}));
        return buf.toString();
    }

    @NotNull
    public static String getInstallPackageCommand(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "getInstallPackageCommand"));
        }
        String string = interpreter.isYarnAlikePackage() ? "add" : "install";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "getInstallPackageCommand"));
        }
        return string;
    }

    private static class SkippingProcessHandler
    extends KillableColoredProcessHandler {
        private boolean myWarnSkipped;
        private boolean myExpectChromeTipLine1;
        private boolean myExpectChromeTipLine2;

        public SkippingProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil$SkippingProcessHandler", "<init>"));
            }
            super(commandLine, withMediator);
            this.myWarnSkipped = false;
            this.myExpectChromeTipLine1 = false;
            this.myExpectChromeTipLine2 = false;
        }

        public void coloredTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/NodeCommandLineUtil$SkippingProcessHandler", "coloredTextAvailable"));
            }
            if (outputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/javascript/nodejs/NodeCommandLineUtil$SkippingProcessHandler", "coloredTextAvailable"));
            }
            if (!this.myWarnSkipped && outputType == ProcessOutputTypes.STDERR && text.startsWith("Warning: This is an experimental feature")) {
                this.myWarnSkipped = true;
                this.myExpectChromeTipLine1 = true;
                return;
            }
            if (this.myExpectChromeTipLine1 && outputType == ProcessOutputTypes.STDERR && text.startsWith("To start debugging, open the following URL in Chrome:")) {
                this.myExpectChromeTipLine1 = false;
                this.myExpectChromeTipLine2 = true;
                return;
            }
            if (this.myExpectChromeTipLine2) {
                this.myExpectChromeTipLine2 = false;
                if (text.contains("chrome-devtools://")) {
                    return;
                }
            }
            super.coloredTextAvailable(text, outputType);
        }
    }
}

